/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project;

import org.w3c.dom.Element;

public class ColumnType {
    public static final ColumnType VARCHAR = new ColumnType("String", 45);
    public static final ColumnType NUMBER = new ColumnType("Number", 4);
    public static final ColumnType BIGNUMBER = new ColumnType("Big Number", 8);
    public static final ColumnType DECIMAL = new ColumnType("Decimal", 4);
    public static final ColumnType BIGDECIMAL = new ColumnType("Big Decimal", 8);
    public static final ColumnType BOOLEAN = new ColumnType("Boolean", 1);
    public static final ColumnType DATETIME = new ColumnType("DateTime", 8);
    public static final ColumnType TEXT = new ColumnType("Text", 16);
    private String typeName;
    private int length;
    private boolean nullable;
    private boolean autoIncrement;

    protected ColumnType(String typeName, int length) {
        this.typeName = typeName;
        this.length = length;
        this.nullable = true;
        this.autoIncrement = false;
    }

    public boolean canAutoIncrement() {
        return this.typeName.equals("Number") || this.typeName.equals("Big Number");
    }

    public int getLength() {
        return this.length;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void write(Element parent) {
        Element dt = parent.getOwnerDocument().createElement("column-type");
        parent.appendChild(dt);
        dt.setAttribute("type", this.typeName);
        dt.setAttribute("length", Integer.toString(this.length));
        dt.setAttribute("nullable", Boolean.toString(this.nullable));
        dt.setAttribute("autoIncrement", Boolean.toString(this.autoIncrement));
    }

    public static ColumnType custom(String typeName, int length, boolean nullable, boolean autoIncrement) {
        ColumnType ret = new ColumnType(typeName, length);
        ret.nullable = nullable;
        ret.autoIncrement = autoIncrement;
        return ret;
    }

    public static ColumnType load(Element element) {
        if (!element.getTagName().equals("column-type")) {
            throw new IllegalArgumentException("Element Format Exception");
        }
        String typeName = element.getAttribute("type");
        int length = Integer.parseInt(element.getAttribute("length"));
        ColumnType ret = new ColumnType(typeName, length);
        ret.nullable = Boolean.valueOf(element.getAttribute("nullable"));
        ret.autoIncrement = Boolean.valueOf(element.getAttribute("autoIncrement"));
        return ret;
    }
}

