/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project;

import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FieldType {
    public static final FieldType STRING = new FieldType("String");
    public static final FieldType NUMBER = new FieldType("Number");
    public static final FieldType DECIMAL = new FieldType("Decimal");
    public static final FieldType BOOLEAN = new FieldType("Boolean");
    public static final FieldType DATETIME = new FieldType("DateTime");
    private static final int ARRAY = 1;
    private static final int OBJECT = 2;
    public static final int SINGLE = 0;
    public static final int DOUBLE = 1;
    public static final int ABSOLUTE = 2;
    private String typeName;
    private int style;
    private int precision;

    protected FieldType(String typeName) {
        this.typeName = typeName;
        this.style = 0;
        this.precision = 0;
    }

    public boolean hasPrecision() {
        return this.typeName.equals("Number") || this.typeName.equals("Decimal");
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isObject() {
        return (this.style & 2) == 2;
    }

    public boolean isArray() {
        return (this.style & 1) == 1;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void write(Element parent) {
        Element dt = parent.getOwnerDocument().createElement("data-type");
        parent.appendChild(dt);
        Element type = dt.getOwnerDocument().createElement("type");
        dt.appendChild(type);
        Text typeText = type.getOwnerDocument().createTextNode(this.typeName);
        type.appendChild(typeText);
        Element styleElement = dt.getOwnerDocument().createElement("style");
        dt.appendChild(styleElement);
        styleElement.setAttribute("value", Integer.toString(this.style));
        Element precisionElement = dt.getOwnerDocument().createElement("precision");
        dt.appendChild(precisionElement);
        precisionElement.setAttribute("value", Integer.toString(this.precision));
    }

    public static FieldType number(int precision) {
        FieldType ret = new FieldType("Number");
        ret.precision = precision;
        return ret;
    }

    public static FieldType numberArray() {
        FieldType ret = new FieldType("Number");
        ret.style = 1;
        return ret;
    }

    public static FieldType numberArray(int precision) {
        FieldType ret = new FieldType("Number");
        ret.precision = precision;
        ret.style = 1;
        return ret;
    }

    public static FieldType stringArray() {
        FieldType ret = new FieldType("String");
        ret.style = 1;
        return ret;
    }

    public static FieldType dateTimeArray() {
        FieldType ret = new FieldType("DateTime");
        ret.style = 1;
        return ret;
    }

    public static FieldType decimal(int precision) {
        FieldType ret = new FieldType("Decimal");
        ret.precision = precision;
        return ret;
    }

    public static FieldType decimalArray() {
        FieldType ret = new FieldType("Decimal");
        ret.style = 1;
        return ret;
    }

    public static FieldType decimalArray(int precision) {
        FieldType ret = new FieldType("Decimal");
        ret.precision = precision;
        ret.style = 1;
        return ret;
    }

    public static FieldType booleanArray() {
        FieldType ret = new FieldType("Boolean");
        ret.style = 1;
        return ret;
    }

    public static FieldType object(IBusinessObject objectType) {
        FieldType ret = new FieldType(objectType.getName());
        ret.style = 2;
        return ret;
    }

    public static FieldType objectArray(IBusinessObject objectType) {
        FieldType ret = new FieldType(objectType.getName());
        ret.style = 3;
        return ret;
    }

    public static FieldType custom(String typeName, boolean object, boolean array, int precision) {
        FieldType ret = new FieldType(typeName);
        if (object) {
            ret.style += 2;
        }
        if (array) {
            ++ret.style;
        }
        ret.precision = precision;
        return ret;
    }

    public static FieldType load(Element element) {
        if (!element.getTagName().equals("data-type")) {
            throw new IllegalArgumentException("Element Format Exception");
        }
        String typeName = null;
        int style = -1;
        int precision = -1;
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 1) {
                Element child = (Element)nl.item(i);
                if (child.getTagName().equals("type")) {
                    NodeList nodes = child.getChildNodes();
                    if (nodes.getLength() > 0) {
                        typeName = ((Text)nodes.item(0)).getData();
                    }
                } else if (child.getTagName().equals("style")) {
                    try {
                        style = Integer.parseInt(child.getAttribute("value"));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                } else if (child.getTagName().equals("precision")) {
                    try {
                        precision = Integer.parseInt(child.getAttribute("value"));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        if (typeName == null || style == -1 || precision == -1) {
            throw new IllegalArgumentException("Element Format Exception");
        }
        FieldType ret = new FieldType(typeName);
        ret.style = style;
        ret.precision = precision;
        return ret;
    }
}

