/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.core.project.FieldType;
import org.eclipse.vtp.desktop.core.project.IBusinessObject;
import org.eclipse.vtp.desktop.core.project.IBusinessObjectSet;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.event.ReloadObjectDataEvent;
import org.eclipse.vtp.desktop.core.project.internals.BusinessObjectField;
import org.eclipse.vtp.desktop.core.project.internals.BusinessObjectSet;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.event.ObjectEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessObject
extends VoiceResource
implements IBusinessObject {
    private BusinessObjectSet objectSet;
    private IFile file;
    private String id;
    private String name;
    private List fields;

    public BusinessObject(BusinessObjectSet objectSet, IFile file) {
        this.objectSet = objectSet;
        this.file = file;
        this.activateEvents();
        this.loadModel();
    }

    private void loadModel() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file.getContents());
            Element rootElement = document.getDocumentElement();
            this.id = rootElement.getAttribute("id");
            this.name = rootElement.getAttribute("name");
            this.fields = new ArrayList();
            NodeList nl = rootElement.getElementsByTagName("field");
            int i = 0;
            while (i < nl.getLength()) {
                Element fieldElement = (Element)nl.item(i);
                String fieldName = fieldElement.getAttribute("name");
                String fieldInitialValue = fieldElement.getAttribute("initialValue");
                NodeList dtnl = fieldElement.getElementsByTagName("data-type");
                if (dtnl.getLength() > 0) {
                    FieldType fieldDataType = FieldType.load((Element)dtnl.item(0));
                    BusinessObjectField bof = new BusinessObjectField(this, fieldName, fieldDataType, fieldInitialValue);
                    this.fields.add(bof);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    protected String getObjectId() {
        return this.file.getFullPath().toPortableString();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public IVoiceResource getParent() {
        return this.objectSet;
    }

    public InputStream read() throws CoreException {
        return this.file.getContents();
    }

    public void processObjectEvent(ObjectEvent event) {
        if (event instanceof ReloadObjectDataEvent) {
            this.loadModel();
            this.refresh();
        } else {
            super.processObjectEvent(event);
        }
    }

    public void write(InputStream source) throws CoreException {
        this.file.setContents(source, true, true, null);
        DesktopCorePlugin.getDefault().postObjectEvent(new ReloadObjectDataEvent(this.getObjectId()));
    }

    public IBusinessObjectSet getBusinessObjectSet() {
        return this.objectSet;
    }
}

