/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.project.internals;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vtp.desktop.core.project.IMediaContainer;
import org.eclipse.vtp.desktop.core.project.IMediaFile;
import org.eclipse.vtp.desktop.core.project.IMediaFilesFolder;
import org.eclipse.vtp.desktop.core.project.IMediaFolder;
import org.eclipse.vtp.desktop.core.project.IVoiceResource;
import org.eclipse.vtp.desktop.core.project.internals.AudioFile;
import org.eclipse.vtp.desktop.core.project.internals.GrammarFile;
import org.eclipse.vtp.desktop.core.project.internals.MediaFile;
import org.eclipse.vtp.desktop.core.project.internals.MediaFolder;
import org.eclipse.vtp.desktop.core.project.internals.MediaResource;
import org.eclipse.vtp.desktop.core.project.internals.VoiceResource;

public class MediaFilesFolder
extends VoiceResource
implements IMediaFilesFolder {
    IFolder folder;
    IVoiceResource parent;

    public MediaFilesFolder(IVoiceResource parent, IFolder folder) {
        this.parent = parent;
        this.folder = folder;
        this.activateEvents();
    }

    public String getName() {
        return this.folder.getName();
    }

    public List listMediaResources() throws CoreException {
        ArrayList<MediaResource> ret = new ArrayList<MediaResource>();
        IResource[] res = this.folder.members();
        int i = 0;
        while (i < res.length) {
            if (!res[i].getName().startsWith(".")) {
                IFolder f;
                if (res[i] instanceof IFolder) {
                    f = (IFolder)res[i];
                    ret.add(new MediaFolder((IMediaContainer)this, f));
                } else {
                    f = (IFile)res[i];
                    String ext = f.getFileExtension();
                    if (ext == null) {
                        ext = "";
                    }
                    if (ext.equalsIgnoreCase("wav") || ext.equalsIgnoreCase("vox")) {
                        ret.add(new AudioFile((IMediaContainer)this, (IFile)f));
                    } else if (ext.equalsIgnoreCase("grxml") || ext.equalsIgnoreCase("grammar") || ext.equalsIgnoreCase("gr") || ext.equalsIgnoreCase("gsml")) {
                        ret.add(new GrammarFile((IMediaContainer)this, (IFile)f));
                    } else if (!f.getName().startsWith(".")) {
                        ret.add(new MediaFile((IMediaContainer)this, (IFile)f));
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public IMediaFolder getMediaFolder(String name) {
        IFolder f = this.folder.getFolder(name);
        return new MediaFolder((IMediaContainer)this, f);
    }

    public IMediaFile getMediaFile(String name) {
        IFile f = this.folder.getFile(name);
        String ext = f.getFileExtension();
        if (ext == null) {
            ext = "";
        }
        if (ext.equalsIgnoreCase("wav") || ext.equalsIgnoreCase("vox")) {
            return new AudioFile((IMediaContainer)this, f);
        }
        if (ext.equalsIgnoreCase("grxml") || ext.equalsIgnoreCase("grammar") || ext.equalsIgnoreCase("gr") || ext.equalsIgnoreCase("gsml")) {
            return new GrammarFile((IMediaContainer)this, f);
        }
        if (!f.getName().startsWith(".")) {
            return new MediaFile((IMediaContainer)this, f);
        }
        return null;
    }

    public IVoiceResource getParent() {
        return this.parent;
    }

    public IMediaFile create(String name) throws CoreException {
        return this.create(name, new ByteArrayInputStream(new byte[0]), null);
    }

    public IMediaFile create(String name, InputStream source, IProgressMonitor monitor) throws CoreException {
        IFile file = this.folder.getFile(name);
        file.create(source, false, null);
        String ext = file.getFileExtension();
        if (ext.equalsIgnoreCase("vox") || ext.equalsIgnoreCase("wav")) {
            return new AudioFile((IMediaContainer)this, file);
        }
        if (ext.equalsIgnoreCase("sgxml") || ext.equalsIgnoreCase("abnf") || ext.equalsIgnoreCase("gr") || ext.equalsIgnoreCase("grammar") || ext.equalsIgnoreCase("gsl") || ext.equalsIgnoreCase("gram") || ext.equalsIgnoreCase("grxml")) {
            return new GrammarFile((IMediaContainer)this, file);
        }
        return new MediaFile((IMediaContainer)this, file);
    }

    public IMediaFolder makeDirectory(String name) throws CoreException {
        IFolder f = this.folder.getFolder(name);
        f.create(false, true, null);
        return new MediaFolder((IMediaContainer)this, f);
    }

    public String getObjectId() {
        return this.folder.getFullPath().toPortableString();
    }

    public IFile getAlternateTextFile() {
        return this.folder.getFile(".audioFiles");
    }
}

