/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.WSDLParserFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class GetMonitorCommand
extends AbstractDataModelOperation {
    private boolean monitorService = true;
    private boolean create = true;
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private List endpoints;
    private String proxyEndpoint;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        this.endpoints = new Vector();
        if (this.monitorService && this.wsdlURI != null && this.wsdlURI.length() > 0) {
            this.webServicesParser = WSDLParserFactory.getWSDLParser();
            Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            if (definition != null) {
                Map services = definition.getServices();
                Iterator servicesIt = services.values().iterator();
                while (servicesIt.hasNext()) {
                    Service service = (Service)servicesIt.next();
                    Map ports = service.getPorts();
                    Iterator portsIt = ports.values().iterator();
                    while (portsIt.hasNext()) {
                        Port wsdlPort = (Port)portsIt.next();
                        List extElements = wsdlPort.getExtensibilityElements();
                        Iterator extElementsIt = extElements.iterator();
                        while (extElementsIt.hasNext()) {
                            ExtensibilityElement extElement = (ExtensibilityElement)extElementsIt.next();
                            String endpoint = null;
                            URL endpointURL = null;
                            if (extElement instanceof SOAPAddress) {
                                endpoint = ((SOAPAddress)extElement).getLocationURI();
                            } else if (extElement instanceof HTTPAddress) {
                                endpoint = ((HTTPAddress)extElement).getLocationURI();
                            }
                            if (endpoint != null) {
                                try {
                                    endpointURL = new URL(endpoint);
                                }
                                catch (MalformedURLException malformedURLException) {}
                            }
                            if (endpointURL == null) continue;
                            String protocol = endpointURL.getProtocol();
                            String host = endpointURL.getHost();
                            int port = endpointURL.getPort();
                            if (port == -1) {
                                if ("http".equalsIgnoreCase(protocol)) {
                                    port = 80;
                                } else if ("https".equalsIgnoreCase(protocol)) {
                                    port = 443;
                                }
                            }
                            if (protocol == null || !protocol.startsWith("http") || host == null || host.length() <= 0 || port == -1) continue;
                            IMonitor m = null;
                            IMonitor[] monitors = MonitorCore.getMonitors();
                            int i = 0;
                            while (i < monitors.length) {
                                if (host.equalsIgnoreCase(monitors[i].getRemoteHost()) && port == monitors[i].getRemotePort()) {
                                    m = monitors[i];
                                    break;
                                }
                                ++i;
                            }
                            if (m == null && this.create) {
                                int monitoredPort = SocketUtil.findUnusedPort((int)5000, (int)15000);
                                IMonitorWorkingCopy monitorWorkingCopy = MonitorCore.createMonitor();
                                monitorWorkingCopy.setLocalPort(monitoredPort);
                                monitorWorkingCopy.setRemoteHost(host);
                                monitorWorkingCopy.setRemotePort(port);
                                monitorWorkingCopy.setProtocol("HTTP");
                                try {
                                    m = monitorWorkingCopy.save();
                                }
                                catch (Throwable t) {
                                    IStatus warning = StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_UNABLE_TO_START_MONITOR, (Object[])new Object[]{String.valueOf(port), endpoint}), (Throwable)t);
                                    try {
                                        if (env != null) {
                                            env.getStatusHandler().report(warning);
                                        }
                                    }
                                    catch (StatusException statusException) {}
                                }
                            }
                            if (m == null) continue;
                            try {
                                if (!m.isRunning()) {
                                    m.start();
                                }
                                if (this.proxyEndpoint != null) {
                                    try {
                                        endpointURL = new URL(this.proxyEndpoint);
                                    }
                                    catch (MalformedURLException malformedURLException) {}
                                }
                                StringBuffer sb = new StringBuffer(endpointURL.getProtocol());
                                sb.append("://localhost:");
                                sb.append(String.valueOf(m.getLocalPort()));
                                sb.append(endpointURL.getFile());
                                this.endpoints.add(sb.toString());
                            }
                            catch (Throwable t) {
                                IStatus warning = StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_UNABLE_TO_START_MONITOR, (Object[])new Object[]{String.valueOf(port), endpoint}), (Throwable)t);
                                try {
                                    if (env == null) continue;
                                    env.getStatusHandler().report(warning);
                                }
                                catch (StatusException statusException) {}
                            }
                        }
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void setMonitorService(boolean monitorService) {
        this.monitorService = monitorService;
    }

    public void setDefinition(Definition definition) {
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setProxyEndpoint(String proxyEndpoint) {
        this.proxyEndpoint = proxyEndpoint;
    }
}

