/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorDocumentSetupParticipant;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLDBUtils;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLStatementSupport;

public class SQLRunAction
extends ResourceAction {
    private SQLEditor fSQLEditor;
    private boolean runSuccessful;

    public SQLRunAction(ResourceBundle bundle, String prefix) {
        super(bundle, prefix);
    }

    public SQLEditor getSQLEditor() {
        return this.fSQLEditor;
    }

    public void run() {
        this.runSuccessful = false;
        SQLEditor sqlEditor = this.getSQLEditor();
        if (sqlEditor != null) {
            ITextSelection textSelection;
            String text;
            List stmtList = new ArrayList();
            SQLStatementSupport stmtSupport = sqlEditor.getSQLStatementSupport();
            String stmtTerminator = stmtSupport.getStatementTerminator();
            ISelectionProvider selectionProvider = this.fSQLEditor.getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            if (!selection.isEmpty() && selection instanceof ITextSelection && (text = (textSelection = (ITextSelection)selection).getText()).length() > 0) {
                Document doc = new Document(text);
                SQLEditorDocumentSetupParticipant setupParticipant = new SQLEditorDocumentSetupParticipant();
                setupParticipant.setup((IDocument)doc);
                SQLStatementSupport stmtSupport2 = new SQLStatementSupport((IDocument)doc);
                stmtSupport2.setStatementTerminator(stmtTerminator);
                stmtList = stmtSupport2.getSQLStatementList();
            }
            if (stmtList.size() == 0) {
                stmtList = stmtSupport.getSQLStatementList();
            }
            if (stmtList.size() > 0) {
                boolean connected;
                Connection conn = null;
                ConnectionInfo connInfo = this.fSQLEditor.getConnectionInfo();
                if (connInfo == null && (connInfo = sqlEditor.requestConnectionFromUser()) != null) {
                    sqlEditor.setConnectionInfo(connInfo);
                }
                if (connInfo != null && (connected = SQLDBUtils.reestablishConnection(connInfo))) {
                    conn = connInfo.getSharedConnection();
                }
                if (conn != null) {
                    Iterator stmtListIter = stmtList.iterator();
                    while (stmtListIter.hasNext()) {
                        String sql = (String)stmtListIter.next();
                        QueryOutputHelper outputHelper = new QueryOutputHelper(sql, conn);
                        this.runSuccessful = outputHelper.runSQLScrapbookQuery();
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wst.rdb.internal.outputview.OutputView");
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            }
        }
    }

    public void setSQLEditor(SQLEditor sqlEditor) {
        this.fSQLEditor = sqlEditor;
    }

    public boolean isRunSuccessful() {
        return this.runSuccessful;
    }
}

