/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.api;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.eclipse.vtp.framework.api.AudioFilePrompt;
import org.eclipse.vtp.framework.api.CharacterPrompt;
import org.eclipse.vtp.framework.api.CompositePrompt;
import org.eclipse.vtp.framework.api.DatePrompt;
import org.eclipse.vtp.framework.api.DateTimePrompt;
import org.eclipse.vtp.framework.api.DigitsPrompt;
import org.eclipse.vtp.framework.api.ExternalFilePrompt;
import org.eclipse.vtp.framework.api.MoneyPrompt;
import org.eclipse.vtp.framework.api.NamedPrompt;
import org.eclipse.vtp.framework.api.NumberPrompt;
import org.eclipse.vtp.framework.api.OrdinalPrompt;
import org.eclipse.vtp.framework.api.TextPrompt;
import org.eclipse.vtp.framework.api.TimePrompt;
import org.eclipse.vtp.framework.api.VariablePrompt;

public abstract class Prompt
implements Serializable,
Comparable {
    public static final String DEFAULT_LANGUAGE = "";
    public static final int VARIABLE_TYPE_CHARACTERS = 0;
    public static final int VARIABLE_TYPE_DIGITS = 1;
    public static final int VARIABLE_TYPE_MONEY = 2;
    public static final int VARIABLE_TYPE_NUMBER = 3;
    public static final int VARIABLE_TYPE_TEXT = 4;
    private List tmpList = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.api.Prompt");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static Prompt fromAudioFile(String filename) {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        return new AudioFilePrompt(filename);
    }

    public static Prompt forCharacters(String text) {
        return Prompt.forCharacters(text, DEFAULT_LANGUAGE);
    }

    public static Prompt forCharacters(String text, String language) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        return new CharacterPrompt(text, language);
    }

    public static Prompt forDate(Date date) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        return new DatePrompt(date, DEFAULT_LANGUAGE);
    }

    public static Prompt forDate(Date date, String language) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new DatePrompt(date, language);
    }

    public static Prompt forTime(Date date) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        return new TimePrompt(date, DEFAULT_LANGUAGE);
    }

    public static Prompt forTime(Date date, String language) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new TimePrompt(date, language);
    }

    public static Prompt forDateTime(Date date) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        return new DateTimePrompt(date, DEFAULT_LANGUAGE);
    }

    public static Prompt forDateTime(Date date, String language) {
        if (!$assertionsDisabled && date == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new DateTimePrompt(date, language);
    }

    public static Prompt forDigits(String digits) {
        if (!$assertionsDisabled && digits == null) {
            throw new AssertionError();
        }
        return new DigitsPrompt(digits, DEFAULT_LANGUAGE);
    }

    public static Prompt fromExternalFile(String url, String alternateText) {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError();
        }
        return new ExternalFilePrompt(url, alternateText);
    }

    public static Prompt forDigits(String digits, String language) {
        if (!$assertionsDisabled && digits == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new DigitsPrompt(digits, language);
    }

    public static Prompt forMoney(BigDecimal money) {
        if (!$assertionsDisabled && money == null) {
            throw new AssertionError();
        }
        return new MoneyPrompt(money, DEFAULT_LANGUAGE);
    }

    public static Prompt forMoney(BigDecimal money, String language) {
        if (!$assertionsDisabled && money == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new MoneyPrompt(money, language);
    }

    public static Prompt named(String name) {
        return new NamedPrompt(name, DEFAULT_LANGUAGE);
    }

    public static Prompt named(String name, String language) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new NamedPrompt(name, language);
    }

    public static Prompt forNumber(int number) {
        return new NumberPrompt(number, DEFAULT_LANGUAGE);
    }

    public static Prompt forNumber(int number, String language) {
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new NumberPrompt(number, language);
    }

    public static Prompt forOrdinal(int number) {
        return new OrdinalPrompt(number, DEFAULT_LANGUAGE);
    }

    public static Prompt forOrdinal(int number, String language) {
        if (!$assertionsDisabled && language == null) {
            throw new AssertionError();
        }
        return new OrdinalPrompt(number, language);
    }

    public static Prompt forText(String text) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        return Prompt.forText(text, DEFAULT_LANGUAGE);
    }

    public static Prompt forText(String text, String language) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        return new TextPrompt(text, language);
    }

    public static Prompt forVariable(String variableName) {
        if (!$assertionsDisabled && variableName == null) {
            throw new AssertionError();
        }
        return new VariablePrompt(variableName, DEFAULT_LANGUAGE, 4);
    }

    public static Prompt forVariable(String variableName, int type) {
        if (!$assertionsDisabled && variableName == null) {
            throw new AssertionError();
        }
        return new VariablePrompt(variableName, DEFAULT_LANGUAGE, type);
    }

    public static Prompt forVariable(String variableName, String language) {
        if (!$assertionsDisabled && variableName == null) {
            throw new AssertionError();
        }
        return new VariablePrompt(variableName, language, 4);
    }

    public static Prompt forVariable(String variableName, String language, int type) {
        if (!$assertionsDisabled && variableName == null) {
            throw new AssertionError();
        }
        return new VariablePrompt(variableName, language, type);
    }

    public final Prompt followedBy(Prompt prompt) {
        if (!$assertionsDisabled && prompt == null) {
            throw new AssertionError();
        }
        return new CompositePrompt(this, prompt);
    }

    public final Object accept(Visitor visitor) {
        if (!$assertionsDisabled && visitor == null) {
            throw new AssertionError();
        }
        return this.process(visitor);
    }

    public void expand(List list) {
        list.add(this);
        this.tmpList = list;
    }

    public List getTmpList() {
        return this.tmpList;
    }

    int count() {
        return 1;
    }

    abstract Object process(Visitor var1);

    public final int compareTo(Object obj) {
        if (!$assertionsDisabled && obj == null) {
            throw new AssertionError();
        }
        if (!(obj instanceof Prompt)) {
            throw new IllegalArgumentException("Cannot compare " + this.getClass().getName() + " to " + obj.getClass().getName());
        }
        int result = this.count() - ((Prompt)obj).count();
        if (result == 0) {
            result = this.toString().compareTo(obj.toString());
        }
        return result;
    }

    public final boolean equals(Object obj) {
        return obj == this || this.getClass().isInstance(obj) && this.count() == ((Prompt)obj).count() && this.toString().equals(obj.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        final StringBuffer buf = new StringBuffer();
        this.accept(new Visitor(){

            public Object audioFilePrompt(String filename) {
                return buf.append("audioFile(").append(filename).append(')');
            }

            public Object ordinalPrompt(int ordinal, String language) {
                return buf.append("characters(").append(ordinal).append(',').append(language).append(')');
            }

            public Object characterPrompt(String text, String language) {
                return buf.append("characters(").append(text).append(',').append(language).append(')');
            }

            public Object datePrompt(Date date, String language) {
                return buf.append("date(").append(date).append(',').append(language).append(')');
            }

            public Object timePrompt(Date date, String language) {
                return buf.append("time(").append(date).append(',').append(language).append(')');
            }

            public Object dateTimePrompt(Date date, String language) {
                return buf.append("dateTime(").append(date).append(',').append(language).append(')');
            }

            public Object digitsPrompt(String digits, String language) {
                return buf.append("digits(").append(digits).append(',').append(language).append(')');
            }

            public Object moneyPrompt(BigDecimal money, String language) {
                return buf.append("money(").append(money).append(',').append(language).append(')');
            }

            public Object namedPrompt(String name, String language) {
                return buf.append("named(").append(name).append(',').append(language).append(')');
            }

            public Object numberPrompt(int number, String language) {
                return buf.append("number(").append(number).append(',').append(language).append(')');
            }

            public Object textPrompt(String text, String language) {
                return buf.append("text(").append(text).append(',').append(language).append(')');
            }

            public Object variablePrompt(String variableName, String language, int type) {
                return buf.append("variable(").append(variableName).append(',').append(language).append(',').append(type).append(')');
            }

            public Object externalFilePrompt(String url, String alternateText) {
                return buf.append("external(").append(url).append(',').append(alternateText).append(')');
            }

            public Object compositePrompt(Prompt first, Prompt second) {
                first.process(this);
                buf.append(',');
                return second.process(this);
            }
        });
        return buf.toString();
    }

    public static interface Resolvable {
    }

    public static interface Translatable {
    }

    public static interface Visitor {
        public Object audioFilePrompt(String var1);

        public Object characterPrompt(String var1, String var2);

        public Object datePrompt(Date var1, String var2);

        public Object timePrompt(Date var1, String var2);

        public Object dateTimePrompt(Date var1, String var2);

        public Object digitsPrompt(String var1, String var2);

        public Object ordinalPrompt(int var1, String var2);

        public Object moneyPrompt(BigDecimal var1, String var2);

        public Object namedPrompt(String var1, String var2);

        public Object numberPrompt(int var1, String var2);

        public Object textPrompt(String var1, String var2);

        public Object variablePrompt(String var1, String var2, int var3);

        public Object compositePrompt(Prompt var1, Prompt var2);

        public Object externalFilePrompt(String var1, String var2);
    }
}

