/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.data.AbstractExecutable;
import org.eclipse.ui.internal.cheatsheets.data.AbstractSubItem;
import org.eclipse.ui.internal.cheatsheets.data.ConditionalSubItem;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.data.RepeatedSubItem;
import org.eclipse.ui.internal.cheatsheets.data.SubItem;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetPage;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;
import org.eclipse.ui.internal.cheatsheets.views.StringDelimitedTokenizer;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;

public class CoreItem
extends ViewItem {
    protected boolean buttonsHandled = false;
    private ArrayList listOfSubItemCompositeHolders;
    private static final int SUBITEM_COLUMNS = 6;

    public CoreItem(CheatSheetPage page, Item item, Color itemColor, CheatSheetViewer viewer) {
        super(page, item, itemColor, viewer);
    }

    private void createButtonComposite() {
        this.buttonComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
        GridLayout buttonlayout = new GridLayout(1, false);
        buttonlayout.marginHeight = 2;
        buttonlayout.marginWidth = 2;
        buttonlayout.verticalSpacing = 2;
        TableWrapData buttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)buttonlayout);
        this.buttonComposite.setLayoutData((Object)buttonData);
        this.buttonComposite.setBackground(this.itemColor);
    }

    private void createButtons(AbstractExecutable executable) {
        boolean hideAction;
        boolean inDialog = this.isInDialogMode();
        boolean isDialogAction = this.getItem().isDialog();
        boolean bl = hideAction = isDialogAction && inDialog;
        if (executable != null && !hideAction) {
            final ImageHyperlink startButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, Messages.PERFORM_TASK_TOOLTIP);
            startButton.setLayoutData((Object)new GridData(4, 128, true, false));
            this.page.getToolkit().adapt((Control)startButton, true, true);
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runPerformExecutable(startButton);
                }
            });
        }
        if (this.item.isSkip()) {
            final ImageHyperlink skipButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP"), this, this.itemColor, Messages.SKIP_TASK_TOOLTIP);
            this.page.getToolkit().adapt((Control)skipButton, true, true);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(skipButton, false);
                }
            });
        }
        if (executable == null || executable.isConfirm()) {
            final ImageHyperlink completeButton = this.createButtonWithText(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, Messages.COMPLETE_TASK_TOOLTIP);
            this.page.getToolkit().adapt((Control)completeButton, true, true);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(completeButton, true);
                }
            });
        }
    }

    private void createSubItemButtonComposite() {
        this.buttonComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
        TableWrapLayout xbuttonlayout = new TableWrapLayout();
        xbuttonlayout.numColumns = 6;
        xbuttonlayout.leftMargin = 0;
        xbuttonlayout.rightMargin = 0;
        xbuttonlayout.horizontalSpacing = 0;
        TableWrapData xbuttonData = new TableWrapData(128);
        this.buttonComposite.setLayout((Layout)xbuttonlayout);
        this.buttonComposite.setLayoutData((Object)xbuttonData);
        this.buttonComposite.setBackground(this.itemColor);
    }

    private void createSubItemButtons(SubItem sub, String thisValue, int index) {
        int added = 0;
        Label checkDoneLabel = this.page.getToolkit().createLabel(this.buttonComposite, null);
        checkDoneLabel.setBackground(this.itemColor);
        ++added;
        String labelText = null;
        labelText = thisValue != null ? this.performLineSubstitution(sub.getLabel(), "${this}", thisValue) : sub.getLabel();
        Label label = this.page.getToolkit().createLabel(this.buttonComposite, labelText, 64);
        TableWrapData labelData = new TableWrapData();
        labelData.indent = 5;
        label.setLayoutData((Object)labelData);
        label.setBackground(this.itemColor);
        ++added;
        Label spacer = this.page.getToolkit().createLabel(this.buttonComposite, null);
        TableWrapData spacerData = new TableWrapData();
        spacerData.maxWidth = 0;
        spacerData.indent = 5;
        spacer.setLayoutData((Object)spacerData);
        ++added;
        AbstractExecutable subExecutable = null;
        if (sub.getPerformWhen() != null) {
            sub.getPerformWhen().setSelectedExecutable(this.viewer.getManager());
            subExecutable = sub.getPerformWhen().getSelectedExecutable();
        } else {
            subExecutable = sub.getExecutable();
        }
        final int fi = index;
        ImageHyperlink startButton = null;
        if (subExecutable != null) {
            ++added;
            final ImageHyperlink finalStartButton = startButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"), this, this.itemColor, Messages.PERFORM_TASK_TOOLTIP);
            this.page.getToolkit().adapt((Control)startButton, true, true);
            startButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.runSubItemPerformExecutable(finalStartButton, fi);
                }
            });
        }
        if (sub.isSkip()) {
            ++added;
            final ImageHyperlink skipButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP"), this, this.itemColor, Messages.SKIP_TASK_TOOLTIP);
            this.page.getToolkit().adapt((Control)skipButton, true, true);
            skipButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(skipButton, false, fi);
                }
            });
        }
        if (subExecutable == null || subExecutable.isConfirm()) {
            ++added;
            final ImageHyperlink completeButton = this.createButton(this.buttonComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE"), this, this.itemColor, Messages.COMPLETE_TASK_TOOLTIP);
            this.page.getToolkit().adapt((Control)completeButton, true, true);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceSubItem(completeButton, true, fi);
                }
            });
        }
        while (added < 6) {
            Label filler = this.page.getToolkit().createLabel(this.buttonComposite, null);
            TableWrapData fillerData = new TableWrapData();
            fillerData.maxWidth = 0;
            filler.setLayoutData((Object)fillerData);
            ++added;
        }
        this.listOfSubItemCompositeHolders.add(new SubItemCompositeHolder(checkDoneLabel, startButton, thisValue, sub));
    }

    private AbstractExecutable getExecutable() {
        AbstractExecutable executable = this.item.getExecutable();
        if (executable == null && this.item.getPerformWhen() != null) {
            executable = this.item.getPerformWhen().getSelectedExecutable();
        }
        return executable;
    }

    private AbstractExecutable getExecutable(int index) {
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null) {
            SubItem subItem = s.getSubItem();
            AbstractExecutable executable = subItem.getExecutable();
            if (executable == null && subItem.getPerformWhen() != null) {
                executable = subItem.getPerformWhen().getSelectedExecutable();
            }
            return executable;
        }
        return null;
    }

    public ArrayList getListOfSubItemCompositeHolders() {
        return this.listOfSubItemCompositeHolders;
    }

    private ImageHyperlink getStartButton() {
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            return null;
        }
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                String toolTipText;
                Control control = controls[i];
                if (control instanceof ImageHyperlink && (toolTipText = control.getToolTipText()) != null && (toolTipText.equals(Messages.PERFORM_TASK_TOOLTIP) || toolTipText.equals(Messages.RESTART_TASK_TOOLTIP))) {
                    return (ImageHyperlink)control;
                }
                ++i;
            }
        }
        return null;
    }

    void handleButtons() {
        if (this.item.isDynamic()) {
            this.handleDynamicButtons();
            return;
        }
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            try {
                this.handleSubButtons();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.LESS_THAN_2_SUBITEMS, (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.LESS_THAN_2_SUBITEMS, null, (IStatus)status);
            }
        }
        if (this.buttonsHandled) {
            return;
        }
        this.createButtonComposite();
        this.createButtons(this.item.getExecutable());
        this.buttonsHandled = true;
    }

    private void handleDynamicButtons() {
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0) {
            this.handleDynamicSubItemButtons();
        } else if (this.item.getPerformWhen() != null) {
            this.handlePerformWhenButtons();
        }
    }

    private void handleDynamicSubItemButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] children = this.buttonComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control control = children[i];
                control.dispose();
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createSubItemButtonComposite();
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        int i = 0;
        Iterator iter = this.item.getSubItems().iterator();
        while (iter.hasNext()) {
            Status status;
            String message;
            AbstractSubItem subItem = (AbstractSubItem)iter.next();
            if (subItem instanceof RepeatedSubItem) {
                RepeatedSubItem repeatedSubItem = (RepeatedSubItem)subItem;
                String values = repeatedSubItem.getValues();
                values = this.viewer.getManager().getVariableData(values);
                if (values == null || values.length() <= 0 || values.startsWith("${") && values.endsWith("}")) {
                    message = NLS.bind((String)Messages.ERROR_DATA_MISSING_LOG, (Object[])new Object[]{repeatedSubItem.getValues()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_DATA_MISSING, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                SubItem sub = (SubItem)repeatedSubItem.getSubItems().get(0);
                StringTokenizer tokenizer = new StringTokenizer(values, ",");
                while (tokenizer.hasMoreTokens()) {
                    String value = tokenizer.nextToken();
                    this.createSubItemButtons(sub, value, i++);
                }
                --i;
            } else if (subItem instanceof ConditionalSubItem) {
                ConditionalSubItem sub = (ConditionalSubItem)subItem;
                sub.setSelectedSubItem(this.viewer.getManager());
                SubItem selectedSubItem = sub.getSelectedSubItem();
                if (selectedSubItem == null) {
                    message = NLS.bind((String)Messages.ERROR_CONDITIONAL_DATA_MISSING_LOG, (Object[])new Object[]{sub.getCondition(), this.getItem().getTitle()});
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    status = new Status(4, "org.eclipse.ui.cheatsheets", 0, Messages.ERROR_DATA_MISSING, null);
                    CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
                    break;
                }
                this.createSubItemButtons(selectedSubItem, null, i);
            } else if (subItem instanceof SubItem) {
                this.createSubItemButtons((SubItem)subItem, null, i);
            }
            ++i;
        }
        if (refreshRequired) {
            this.refresh(this.buttonComposite);
        }
    }

    private void handlePerformWhenButtons() {
        boolean refreshRequired = false;
        if (this.buttonComposite != null) {
            Control[] controls = this.buttonComposite.getChildren();
            int i = 0;
            while (i < controls.length) {
                Control control = controls[i];
                if (control instanceof ImageHyperlink) {
                    control.dispose();
                }
                ++i;
            }
            refreshRequired = true;
        } else {
            this.createButtonComposite();
        }
        this.item.getPerformWhen().setSelectedExecutable(this.viewer.getManager());
        AbstractExecutable performExecutable = this.item.getPerformWhen().getSelectedExecutable();
        this.createButtons(performExecutable);
        if (refreshRequired) {
            this.refresh(this.buttonComposite);
        }
    }

    private void handleSubButtons() throws Exception {
        if (this.buttonsHandled) {
            return;
        }
        this.listOfSubItemCompositeHolders = new ArrayList(20);
        ArrayList sublist = this.item.getSubItems();
        if (sublist == null || sublist.size() <= 1) {
            throw new Exception(Messages.LESS_THAN_2_SUBITEMS);
        }
        this.createSubItemButtonComposite();
        int i = 0;
        while (i < sublist.size()) {
            this.createSubItemButtons((SubItem)sublist.get(i), null, i);
            ++i;
        }
        this.buttonsHandled = true;
    }

    boolean hasConfirm() {
        AbstractExecutable executable = this.getExecutable();
        return executable == null || executable.isConfirm();
    }

    boolean hasConfirm(int index) {
        AbstractExecutable executable = this.getExecutable(index);
        return executable == null || executable.isConfirm();
    }

    public String performLineSubstitution(String line, String variable, String value) {
        StringBuffer buffer = new StringBuffer(line.length());
        StringDelimitedTokenizer tokenizer = new StringDelimitedTokenizer(line, variable);
        boolean addValue = false;
        while (tokenizer.hasMoreTokens()) {
            if (addValue) {
                buffer.append(value);
            }
            buffer.append(tokenizer.nextToken());
            addValue = true;
        }
        if (tokenizer.endsWithDelimiter()) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    IStatus runExecutable(CheatSheetManager csm) {
        return this.runExecutable(this.getExecutable(), csm);
    }

    IStatus runExecutable(AbstractExecutable executable, CheatSheetManager csm) {
        if (executable != null) {
            return executable.execute(csm);
        }
        return Status.OK_STATUS;
    }

    byte runSubItemExecutable(CheatSheetManager csm, int index) {
        AbstractExecutable executable;
        SubItemCompositeHolder s;
        if (this.item.getSubItems() != null && this.item.getSubItems().size() > 0 && this.listOfSubItemCompositeHolders != null && (s = (SubItemCompositeHolder)this.listOfSubItemCompositeHolders.get(index)) != null && (executable = this.getExecutable(index)) != null) {
            IStatus status;
            block9: {
                try {
                    if (s.getThisValue() != null) {
                        csm.setData("this", s.getThisValue());
                    }
                    if (!(status = this.runExecutable(executable, csm)).isOK()) break block9;
                    Object var6_6 = null;
                    if (s.getThisValue() != null) {
                        csm.setData("this", null);
                    }
                    return 0;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (s.getThisValue() != null) {
                        csm.setData("this", null);
                    }
                    throw throwable;
                }
            }
            if (status.getSeverity() == 4) {
                CheatSheetPlugin.getPlugin().getLog().log(status);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, (IStatus)status);
            }
            Object var6_7 = null;
            if (s.getThisValue() != null) {
                csm.setData("this", null);
            }
            return 1;
        }
        return 0;
    }

    void setButtonsHandled(boolean handled) {
        this.buttonsHandled = handled;
    }

    void setIncomplete() {
        super.setIncomplete();
        ArrayList l = this.getListOfSubItemCompositeHolders();
        if (l != null) {
            int j = 0;
            while (j < l.size()) {
                SubItemCompositeHolder s = (SubItemCompositeHolder)l.get(j);
                if (s.isCompleted() || s.isSkipped()) {
                    s.getIconLabel().setImage(null);
                }
                if (s.startButton != null) {
                    s.getStartButton().setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
                    s.getStartButton().setToolTipText(Messages.PERFORM_TASK_TOOLTIP);
                }
                ++j;
            }
        }
    }

    void setRestartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_RESTART"));
            startButton.setText(Messages.RESTART_TASK_TOOLTIP);
            startButton.setToolTipText(Messages.RESTART_TASK_TOOLTIP);
        }
    }

    void setStartImage() {
        ImageHyperlink startButton = this.getStartButton();
        if (startButton != null) {
            startButton.setImage(CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_START"));
            if (startButton.getText() != null) {
                startButton.setText(Messages.PERFORM_TASK_TOOLTIP);
            }
            startButton.setToolTipText(Messages.PERFORM_TASK_TOOLTIP);
        }
    }

    boolean hasCompletionMessage() {
        return this.item.getCompletionMessage() != null;
    }

    void createCompletionComposite(boolean isFinalItem) {
        String completionMessage = this.viewer.getManager().performVariableSubstitution(this.item.getCompletionMessage());
        if (completionMessage != null) {
            Color backgroundColor = this.bodyWrapperComposite.getBackground();
            this.completionComposite = this.page.getToolkit().createComposite(this.bodyWrapperComposite);
            TableWrapLayout completionlayout = new TableWrapLayout();
            completionlayout.numColumns = 1;
            TableWrapData completionData = new TableWrapData(128);
            this.completionComposite.setLayout((Layout)completionlayout);
            this.completionComposite.setLayoutData((Object)completionData);
            this.completionComposite.setBackground(backgroundColor);
            Label completionLabel = this.page.getToolkit().createLabel(this.completionComposite, completionMessage, 64);
            completionLabel.setBackground(backgroundColor);
            final ImageHyperlink completeButton = this.createButtonWithText(this.completionComposite, this.getCompletionButtonIcon(isFinalItem), this, backgroundColor, this.getCompletionButtonTooltip(isFinalItem));
            this.page.getToolkit().adapt((Control)completeButton, true, true);
            completeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CoreItem.this.viewer.advanceItem(completeButton, true);
                }
            });
            this.completionComposite.setVisible(false);
            this.setBackgroundColor(this.completionComposite, backgroundColor);
            this.refresh(this.completionComposite);
        }
    }

    private Image getCompletionButtonIcon(boolean isFinalItem) {
        if (isFinalItem) {
            return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_RETURN");
        }
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_BUTTON_COMPLETE");
    }

    private String getCompletionButtonTooltip(boolean isFinalItem) {
        if (isFinalItem) {
            return Messages.RETURN_TO_INTRO_TOOLTIP;
        }
        return Messages.ADVANCE_TASK_TOOLTIP;
    }

    private void refresh(Composite composite) {
        composite.layout();
        this.getMainItemComposite().layout();
        this.page.getForm().reflow(true);
    }

    public void refreshItem() {
        if (this.buttonComposite != null) {
            this.refresh(this.buttonComposite);
        }
    }
}

