/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.scheduler.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.update.internal.scheduler.SchedulerStartup;
import org.eclipse.update.internal.scheduler.UpdateSchedulerMessages;
import org.eclipse.update.internal.scheduler.UpdateSchedulerPlugin;

public class AutomaticUpdatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enabledCheck;
    private Button onStartupRadio;
    private Button onScheduleRadio;
    private Combo dayCombo;
    private Label atLabel;
    private Combo hourCombo;
    private Button searchOnlyRadio;
    private Button searchAndDownloadRadio;
    private Group updateScheduleGroup;
    private Group downloadGroup;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.enabledCheck = new Button(container, 32);
        this.enabledCheck.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_findUpdates);
        this.createSpacer(container, 1);
        this.updateScheduleGroup = new Group(container, 0);
        this.updateScheduleGroup.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_UpdateSchedule);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.updateScheduleGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.updateScheduleGroup.setLayoutData((Object)gd);
        this.onStartupRadio = new Button((Composite)this.updateScheduleGroup, 16);
        this.onStartupRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_findOnStart);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onStartupRadio.setLayoutData((Object)gd);
        this.onStartupRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.onScheduleRadio = new Button((Composite)this.updateScheduleGroup, 16);
        this.onScheduleRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_findOnSchedule);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onScheduleRadio.setLayoutData((Object)gd);
        this.onScheduleRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.dayCombo = new Combo((Composite)this.updateScheduleGroup, 8);
        this.dayCombo.setItems(SchedulerStartup.DAYS);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalIndent = 30;
        this.dayCombo.setLayoutData((Object)gd);
        this.atLabel = new Label((Composite)this.updateScheduleGroup, 0);
        this.atLabel.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_at);
        this.hourCombo = new Combo((Composite)this.updateScheduleGroup, 8);
        this.hourCombo.setItems(SchedulerStartup.HOURS);
        gd = new GridData();
        gd.widthHint = 100;
        this.hourCombo.setLayoutData((Object)gd);
        this.createSpacer(container, 1);
        this.downloadGroup = new Group(container, 0);
        this.downloadGroup.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_downloadOptions);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.downloadGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.downloadGroup.setLayoutData((Object)gd);
        this.searchOnlyRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchOnlyRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_searchAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchOnlyRadio.setLayoutData((Object)gd);
        this.searchOnlyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.searchAndDownloadRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchAndDownloadRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_downloadAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchAndDownloadRadio.setLayoutData((Object)gd);
        this.searchAndDownloadRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.initialize();
        this.enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        Preferences pref = UpdateSchedulerPlugin.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getBoolean("enabled"));
        this.setSchedule(pref.getString("schedule"));
        this.dayCombo.setText(SchedulerStartup.DAYS[this.getDay(pref, false)]);
        this.hourCombo.setText(SchedulerStartup.HOURS[this.getHour(pref, false)]);
        this.searchOnlyRadio.setSelection(!pref.getBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getBoolean("download"));
        this.pageChanged();
    }

    private void setSchedule(String value) {
        if (value.equals("on-startup")) {
            this.onStartupRadio.setSelection(true);
        } else {
            this.onScheduleRadio.setSelection(true);
        }
    }

    private void pageChanged() {
        boolean master = this.enabledCheck.getSelection();
        this.updateScheduleGroup.setEnabled(master);
        this.onStartupRadio.setEnabled(master);
        this.onScheduleRadio.setEnabled(master);
        this.dayCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.atLabel.setEnabled(master && this.onScheduleRadio.getSelection());
        this.hourCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.downloadGroup.setEnabled(master);
        this.searchOnlyRadio.setEnabled(master);
        this.searchAndDownloadRadio.setEnabled(master);
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences pref = UpdateSchedulerPlugin.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getDefaultBoolean("enabled"));
        this.setSchedule(pref.getDefaultString("schedule"));
        this.onScheduleRadio.setSelection(pref.getDefaultBoolean("schedule"));
        this.dayCombo.setText(SchedulerStartup.DAYS[this.getDay(pref, true)]);
        this.hourCombo.setText(SchedulerStartup.HOURS[this.getHour(pref, true)]);
        this.searchOnlyRadio.setSelection(!pref.getDefaultBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getDefaultBoolean("download"));
        this.pageChanged();
    }

    public boolean performOk() {
        Preferences pref = UpdateSchedulerPlugin.getDefault().getPluginPreferences();
        pref.setValue("enabled", this.enabledCheck.getSelection());
        if (this.onStartupRadio.getSelection()) {
            pref.setValue("schedule", "on-startup");
        } else {
            pref.setValue("schedule", "on-schedule");
        }
        pref.setValue("day", this.dayCombo.getText());
        pref.setValue("hour", this.hourCombo.getText());
        pref.setValue("download", this.searchAndDownloadRadio.getSelection());
        UpdateSchedulerPlugin.getDefault().savePluginPreferences();
        UpdateSchedulerPlugin.getScheduler().scheduleUpdateJob();
        return true;
    }

    private int getDay(Preferences pref, boolean useDefault) {
        String day = useDefault ? pref.getDefaultString("day") : pref.getString("day");
        int i = 0;
        while (i < SchedulerStartup.DAYS.length) {
            if (SchedulerStartup.DAYS[i].equals(day)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getHour(Preferences pref, boolean useDefault) {
        String hour = useDefault ? pref.getDefaultString("hour") : pref.getString("hour");
        int i = 0;
        while (i < SchedulerStartup.HOURS.length) {
            if (SchedulerStartup.HOURS[i].equals(hour)) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

