/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.RDBWizardPage;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public class NewCWUidPwd
implements Listener {
    protected int contentOptions;
    protected Label userIdLabel;
    protected Label passwordLabel;
    protected Combo userIdCombo;
    protected Text passwordText;
    protected RDBWizardPage parentPage;
    protected Composite contents;

    public NewCWUidPwd(RDBWizardPage parentPage, int options) {
        this.parentPage = parentPage;
        this.contentOptions = options;
    }

    public Composite getComposite(Composite parent, RSCCoreUIWidgetFactory factory) {
        if (this.contents == null) {
            this.contents = factory.createGroup(parent, this.parentPage.getString("CUI_NEWCW_SPECIFY_USER_INFO_UI_"), 0);
            this.createLayout(this.contents);
            this.createGUI(this.contents, factory);
        }
        return this.contents;
    }

    public void createLayout(Composite contents) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
    }

    public void addListeners() {
        this.userIdCombo.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
    }

    public void removeListeners() {
        this.userIdCombo.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
    }

    protected void createGUI(Composite parent, RSCCoreUIWidgetFactory factory) {
        this.userIdLabel = factory.createLabel(parent, 0);
        this.userIdLabel.setText(this.parentPage.getString("CUI_NEWCW_USERID_LBL_UI_"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.userIdLabel.setLayoutData((Object)gd);
        this.userIdCombo = factory.createCombo(parent, 2052);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.userIdCombo.setLayoutData((Object)gd);
        this.passwordLabel = factory.createLabel(parent, 0);
        this.passwordLabel.setText(this.parentPage.getString("CUI_NEWCW_PASSWORD_LBL_UI_"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.passwordLabel.setLayoutData((Object)gd);
        this.passwordText = factory.createText(parent, 2048);
        this.passwordText.setEchoChar('*');
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
    }

    public void setUserId(String id) {
        this.userIdCombo.setText(id);
    }

    public void setPassword(String pwd) {
        this.passwordText.setText(pwd);
    }

    public String getUserId() {
        return this.userIdCombo.getText();
    }

    public String getPassword() {
        return this.passwordText.getText();
    }

    public void handleEvent(Event e) {
        this.parentPage.setPageComplete(this.parentPage.determinePageCompletion());
    }

    protected void enableUidPwd(boolean enable) {
        this.userIdLabel.setEnabled(enable);
        this.passwordLabel.setEnabled(enable);
        this.userIdCombo.setEnabled(enable);
        this.passwordText.setEnabled(enable);
    }

    public void fillFromConnection(ConnectionInfo connection) {
        if (connection.getUserName() != null) {
            this.userIdCombo.setText(connection.getUserName());
        } else {
            this.userIdCombo.setText("");
        }
        if (connection.getPassword() != null) {
            this.passwordText.setText(connection.getPassword());
        } else {
            this.passwordText.setText("");
        }
        this.parentPage.setPageComplete(this.parentPage.determinePageCompletion());
    }

    public void setConnectionDetails(ConnectionInfo connection) {
        connection.setUserName(this.getUserId());
        connection.setPassword(this.getPassword());
    }

    public boolean determinePageCompletion() {
        return this.validateUserID();
    }

    protected boolean requiresUIDPwd() {
        return true;
    }

    protected boolean validateUserID() {
        if (this.userIdCombo != null && this.userIdCombo.getEnabled() && this.userIdCombo.getText().length() <= 0) {
            this.parentPage.setErrorMessage(this.parentPage.getString("CUI_NEWCW_VALIDATE_USERID_REQ_MSG_UI_"));
            return false;
        }
        return true;
    }

    protected boolean validatePassword() {
        if (this.requiresUIDPwd() && this.passwordText != null && this.passwordText.getEnabled() && this.passwordText.getText().length() <= 0) {
            this.parentPage.setErrorMessage(this.parentPage.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_MSG_UI_"));
            return false;
        }
        return true;
    }

    public void internalLoadWidgetValues() {
        IDialogSettings dialogSettings = this.parentPage.getWizard().getDialogSettings();
        if (dialogSettings != null) {
            String[] values = dialogSettings.getArray("NewConnectionWizard.STORE_USERIDS");
            if (values != null) {
                this.parentPage.loadComboSettings(this.userIdCombo, values, true);
            } else {
                this.userIdCombo.setText(System.getProperty("user.name"));
            }
        }
    }

    public void internalSaveWidgetValues() {
        IDialogSettings dialogSettings = this.parentPage.getWizard().getDialogSettings();
        if (dialogSettings != null) {
            boolean useCurrent = false;
            dialogSettings.put("NewConnectionWizard.STORE_USE_OS_UID_PWD", useCurrent);
            if (!useCurrent) {
                String[] userids = dialogSettings.getArray("NewConnectionWizard.STORE_USERIDS");
                userids = this.parentPage.addToHistory(userids, this.userIdCombo.getText().trim());
                dialogSettings.put("NewConnectionWizard.STORE_USERIDS", userids);
            }
        }
    }
}

