/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class LocalHistoryTableProvider {
    TreeViewer viewer;
    Font currentRevisionFont;
    private IFile currentFile;
    private static final int COL_DATE = 0;
    static /* synthetic */ Class class$0;

    protected IFileRevision adaptToFileRevision(Object element) {
        IFileRevision[] revisions;
        IFileRevision entry = null;
        if (element instanceof IFileRevision) {
            entry = (IFileRevision)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entry = (IFileRevision)iAdaptable.getAdapter((Class)clazz);
        } else if (element instanceof AbstractHistoryCategory && (revisions = ((AbstractHistoryCategory)element).getRevisions()).length > 0) {
            entry = revisions[0];
        }
        return entry;
    }

    private void createColumns(Tree tree, TableLayout layout) {
        SelectionListener headerListener = this.getColumnListener(this.viewer);
        TreeColumn col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        col.addSelectionListener(headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }

    private SelectionListener getColumnListener(final TreeViewer treeViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = treeViewer.getTree().indexOf((TreeColumn)e.widget);
                HistorySorter oldSorter = (HistorySorter)treeViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    treeViewer.refresh();
                } else {
                    treeViewer.setSorter((ViewerSorter)new HistorySorter(column));
                }
            }
        };
    }

    public TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        this.viewer = new TreeViewer(tree);
        this.createColumns(tree, layout);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LocalHistoryLabelProvider(this));
        HistorySorter sorter = new HistorySorter(0);
        sorter.setReversed(false);
        this.viewer.setSorter((ViewerSorter)sorter);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (LocalHistoryTableProvider.this.currentRevisionFont != null) {
                    LocalHistoryTableProvider.this.currentRevisionFont.dispose();
                }
            }
        });
        return this.viewer;
    }

    public void setFile(IFile file) {
        this.currentFile = file;
    }

    public long getCurrentRevision() {
        if (this.currentFile != null) {
            return this.currentFile.getLocalTimeStamp();
        }
        return 0L;
    }

    class LocalHistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        Image dateImage = null;
        ImageDescriptor dateDesc = null;
        Image localRevImage = null;
        ImageDescriptor localRevDesc = null;
        ThemeListener themeListener;

        public LocalHistoryLabelProvider(LocalHistoryTableProvider provider) {
            this.themeListener = new ThemeListener(provider);
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener((IPropertyChangeListener)this.themeListener);
        }

        public void dispose() {
            if (this.dateImage != null) {
                this.dateImage.dispose();
                this.dateImage = null;
            }
            if (this.localRevImage != null) {
                this.localRevImage.dispose();
                this.localRevImage = null;
            }
            if (this.themeListener != null) {
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener((IPropertyChangeListener)this.themeListener);
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof DateHistoryCategory && columnIndex == 0) {
                if (this.dateImage == null) {
                    this.dateDesc = TeamUIPlugin.getImageDescriptor("obj/dates.gif");
                    this.dateImage = this.dateDesc.createImage();
                }
                return this.dateImage;
            }
            if (element instanceof LocalFileRevision && columnIndex == 0) {
                if (this.localRevImage == null) {
                    this.localRevDesc = TeamUIPlugin.getImageDescriptor("obj/local_entry_tbl.gif");
                    this.localRevImage = this.localRevDesc.createImage();
                }
                return this.localRevImage;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AbstractHistoryCategory) {
                if (columnIndex != 0) {
                    return "";
                }
                return ((AbstractHistoryCategory)element).getName();
            }
            IFileRevision entry = LocalHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    long date = entry.getTimestamp();
                    Date dateFromLong = new Date(date);
                    return DateFormat.getInstance().format(dateFromLong);
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                return current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.cvshistorypagecategories");
            }
            IFileRevision entry = LocalHistoryTableProvider.this.adaptToFileRevision(element);
            if (!entry.exists()) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                return this.getCurrentRevisionFont();
            }
            IFileRevision entry = LocalHistoryTableProvider.this.adaptToFileRevision(element);
            if (entry == null) {
                return null;
            }
            long timestamp = entry.getTimestamp();
            long tempCurrentTimeStamp = LocalHistoryTableProvider.this.getCurrentRevision();
            if (tempCurrentTimeStamp != 0L && tempCurrentTimeStamp == timestamp) {
                return this.getCurrentRevisionFont();
            }
            return null;
        }

        private Font getCurrentRevisionFont() {
            if (LocalHistoryTableProvider.this.currentRevisionFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                LocalHistoryTableProvider.this.currentRevisionFont = new Font((Device)LocalHistoryTableProvider.this.viewer.getTree().getDisplay(), data);
            }
            return LocalHistoryTableProvider.this.currentRevisionFont;
        }
    }

    class HistorySorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN = new int[][]{new int[1]};

        public HistorySorter(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            IFileRevision e1 = LocalHistoryTableProvider.this.adaptToFileRevision(o1);
            IFileRevision e2 = LocalHistoryTableProvider.this.adaptToFileRevision(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(compareViewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, IFileRevision e1, IFileRevision e2) {
            switch (columnNumber) {
                case 0: {
                    long date1 = e1.getTimestamp();
                    long date2 = e2.getTimestamp();
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? -1 : 1;
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }

    private static class ThemeListener
    implements IPropertyChangeListener {
        private final LocalHistoryTableProvider provider;

        ThemeListener(LocalHistoryTableProvider provider) {
            this.provider = provider;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.provider.viewer.refresh();
        }
    }
}

