/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.site.PDEState;

public class ProductGenerator
extends AbstractScriptGenerator {
    private static final String BUNDLE_EQUINOX_COMMON = "org.eclipse.equinox.common";
    private static final String BUNDLE_OSGI = "org.eclipse.osgi";
    private static final String BUNDLE_CORE_RUNTIME = "org.eclipse.core.runtime";
    private static final String BUNDLE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    private static final String START_LEVEL_2 = "@2:start";
    private static final String START_LEVEL_3 = "@3:start";
    private static final String START = "@start";
    private String product = null;
    private ProductFile productFile = null;
    private String root = null;
    private boolean refactoredRuntime = false;
    private Properties buildProperties;

    public void generate() throws CoreException {
        this.initialize();
        if (this.productFile == null) {
            return;
        }
        if (this.productFile.getId() == null) {
            return;
        }
        String custom = this.findFile(this.productFile.getConfigIniPath(), false);
        String location = null;
        String fileList = null;
        Iterator iter = ProductGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            location = "productRootFiles/" + config.toStringReplacingAny(".", "ANY");
            String rootLocation = String.valueOf(this.root) + location;
            File rootDir = new File(rootLocation);
            if (!rootDir.exists() && !rootDir.mkdirs() || rootDir.isFile()) continue;
            if (this.buildProperties != null) {
                fileList = this.buildProperties.getProperty("root." + config.toString("."), "");
                fileList = String.valueOf(fileList) + (fileList.length() > 0 ? String.valueOf(',') + location : location);
                this.buildProperties.put("root." + config.toString("."), fileList);
            }
            if (custom != null) {
                this.copyFile(custom, String.valueOf(rootLocation) + "/configuration/config.ini");
            } else {
                this.createConfigIni(config, rootLocation);
            }
            if (config.getOs().equals(Config.ANY)) continue;
            this.createEclipseProductFile(rootLocation);
            this.createLauncherIniFile(rootLocation, config.getOs());
        }
    }

    private void initialize() throws CoreException {
        this.loadProduct();
        PDEState state = this.getSite(false).getRegistry();
        this.refactoredRuntime = state.getResolvedBundle(BUNDLE_EQUINOX_COMMON) != null;
    }

    private void loadProduct() throws CoreException {
        if (this.product == null || this.product.startsWith("${")) {
            this.productFile = null;
            return;
        }
        String productPath = this.findFile(this.product, false);
        if (productPath == null) {
            productPath = this.product;
        }
        this.productFile = new ProductFile(productPath, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(String src, String dest) {
        FileOutputStream out;
        block17: {
            File source = new File(src);
            if (!source.exists()) {
                return;
            }
            File destination = new File(dest);
            File destDir = destination.getParentFile();
            if (!destDir.exists()) {
                if (!destDir.mkdirs()) return;
            }
            if (destDir.isFile()) {
                return;
            }
            FileInputStream in = null;
            out = null;
            try {
                try {
                    int len;
                    in = new FileInputStream(source);
                    out = new FileOutputStream(destination);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (in == null) break block17;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createConfigIni(Config config, String location) throws CoreException {
        Object var9_9;
        String application;
        File configDir = new File(String.valueOf(location) + "/configuration");
        if (!configDir.exists()) {
            if (!configDir.mkdirs()) return;
        }
        if (configDir.isFile()) {
            return;
        }
        PDEState state = this.getSite(false).getRegistry();
        StringBuffer buffer = new StringBuffer();
        buffer.append("#Product Runtime Configuration File\n");
        String splash = this.getSplashLocation(config);
        if (splash != null) {
            buffer.append("osgi.splashPath=" + splash + '\n');
        }
        if ((application = this.productFile.getApplication()) != null) {
            buffer.append("eclipse.application=" + application + '\n');
        }
        buffer.append("eclipse.product=" + this.productFile.getId() + '\n');
        buffer.append("osgi.bundles=");
        if (this.productFile.useFeatures() || this.productFile.containsPlugin(BUNDLE_UPDATE_CONFIGURATOR)) {
            if (this.refactoredRuntime) {
                buffer.append(BUNDLE_EQUINOX_COMMON);
                buffer.append(START_LEVEL_2);
                buffer.append(',');
                buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
                buffer.append(START_LEVEL_3);
                buffer.append(',');
                buffer.append(BUNDLE_CORE_RUNTIME);
                buffer.append(START);
                buffer.append('\n');
            } else {
                buffer.append(BUNDLE_CORE_RUNTIME);
                buffer.append(START_LEVEL_2);
                buffer.append(',');
                buffer.append(BUNDLE_UPDATE_CONFIGURATOR);
                buffer.append(START_LEVEL_3);
                buffer.append('\n');
            }
        } else {
            Hashtable<String, String> environment = new Hashtable<String, String>(3);
            ((Dictionary)environment).put("osgi.os", config.getOs());
            ((Dictionary)environment).put("osgi.ws", config.getWs());
            ((Dictionary)environment).put("osgi.arch", config.getArch());
            List pluginList = this.productFile.getPlugins();
            BundleHelper helper = BundleHelper.getDefault();
            boolean first = true;
            Iterator iter = pluginList.iterator();
            while (true) {
                String filter;
                if (!iter.hasNext()) {
                    buffer.append('\n');
                    break;
                }
                String id = (String)iter.next();
                BundleDescription bundle = state.getResolvedBundle(id);
                if (bundle == null || (filter = bundle.getPlatformFilter()) != null && !helper.createFilter(filter).match(environment) || BUNDLE_OSGI.equals(id)) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(id);
                if (BUNDLE_EQUINOX_COMMON.equals(id)) {
                    buffer.append(START_LEVEL_2);
                    continue;
                }
                if (!BUNDLE_CORE_RUNTIME.equals(id)) continue;
                if (this.refactoredRuntime) {
                    buffer.append(START);
                    continue;
                }
                buffer.append(START_LEVEL_2);
            }
        }
        buffer.append("osgi.bundles.defaultStartLevel=4\n");
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(new File(configDir, "config.ini"));
                writer.write(buffer.toString());
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            var9_9 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            var9_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (writer == null) return;
        writer.close();
    }

    /*
     * Exception decompiling
     */
    private void createEclipseProductFile(String directory) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 203->207)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getBrandingPlugin() {
        String id = this.productFile.getId();
        if (id == null) {
            return null;
        }
        int dot = id.lastIndexOf(46);
        return dot != -1 ? id.substring(0, dot) : null;
    }

    private String getSplashLocation(Config config) throws CoreException {
        String plugin = this.productFile.getSplashLocation();
        if (plugin == null) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("platform:/base/plugins/");
        buffer.append(plugin);
        Hashtable<String, String> environment = new Hashtable<String, String>(4);
        ((Dictionary)environment).put("osgi.os", config.getOs());
        ((Dictionary)environment).put("osgi.ws", config.getWs());
        ((Dictionary)environment).put("osgi.arch", config.getArch());
        PDEState state = this.getSite(false).getRegistry();
        BundleHelper helper = BundleHelper.getDefault();
        BundleDescription bundle = state.getResolvedBundle(plugin);
        if (bundle != null) {
            BundleDescription[] fragments = bundle.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String fragmentId;
                String filter = fragments[i].getPlatformFilter();
                if ((filter == null || helper.createFilter(filter).match(environment)) && this.productFile.containsPlugin(fragmentId = fragments[i].getSymbolicName())) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(fragmentId);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    /*
     * Exception decompiling
     */
    private void createLauncherIniFile(String directory, String os) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 345->349)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getLauncherName() {
        String name = this.productFile.getLauncherName();
        if (name != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

