/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.fetch;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IAntScript;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;

public class CVSFetchTaskFactory
implements IFetchFactory {
    public static final String ID = "CVS";
    private static final String TARGET_GET_FROM_CVS = "FetchFromCVS";
    private static final String SEPARATOR = ",";
    public static final String OVERRIDE_TAG = "CVS";
    private static final String KEY_CVSROOT = "cvsRoot";
    private static final String KEY_CVSPASSFILE = "cvsPassFile";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_PATH = "path";
    private static final String PROP_DESTINATIONFOLDER = "destinationFolder";
    private static final String PROP_CVSROOT = "cvsRoot";
    private static final String PROP_MODULE = "module";
    private static final String PROP_TAG = "tag";
    private static final String PROP_QUIET = "quiet";
    private static final String PROP_FILETOCHECK = "fileToCheck";
    private static final String PROP_ELEMENTNAME = "elementName";

    private void generateAuthentificationAntTask(Map entryInfos, IAntScript script) {
        String password = (String)entryInfos.get(KEY_PASSWORD);
        String cvsPassFileLocation = (String)entryInfos.get(KEY_CVSPASSFILE);
        if (password != null) {
            this.printCVSPassTask((String)entryInfos.get("cvsRoot"), password, cvsPassFileLocation, script);
        }
    }

    public void generateRetrieveElementCall(Map entryInfos, IPath destination, IAntScript script) {
        String type = (String)entryInfos.get("type");
        String element = (String)entryInfos.get("element");
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put(PROP_DESTINATIONFOLDER, destination.uptoSegment(destination.segmentCount() - 1).toString());
        params.put(PROP_TAG, (String)entryInfos.get(PROP_TAG));
        params.put("cvsRoot", (String)entryInfos.get("cvsRoot"));
        params.put(PROP_QUIET, "${cvs.quiet}");
        params.put(PROP_ELEMENTNAME, element);
        params.put(PROP_MODULE, entryInfos.get(KEY_PATH) == null ? element : (String)entryInfos.get(KEY_PATH));
        IPath locationToCheck = (IPath)destination.clone();
        if (type.equals("feature")) {
            locationToCheck = locationToCheck.append("feature.xml");
        } else if (type.equals("plugin")) {
            locationToCheck = locationToCheck.append("plugin.xml");
        } else if (type.equals("fragment")) {
            locationToCheck = locationToCheck.append("fragment.xml");
        } else if (type.equals("bundle")) {
            locationToCheck = locationToCheck.append("META-INF/MANIFEST.MF");
        }
        params.put(PROP_FILETOCHECK, locationToCheck.toString());
        this.printAvailableTask(locationToCheck.toString(), locationToCheck.toString(), script);
        if (type.equals("plugin") || type.equals("fragment")) {
            this.printAvailableTask(locationToCheck.toString(), locationToCheck.removeLastSegments(1).append("META-INF/MANIFEST.MF").toString(), script);
        }
        this.generateAuthentificationAntTask(entryInfos, script);
        script.printAntCallTask(TARGET_GET_FROM_CVS, true, params);
    }

    public void generateRetrieveFilesCall(Map entryInfos, IPath destination, String[] files, IAntScript script) {
        this.generateAuthentificationAntTask(entryInfos, script);
        String path = (String)entryInfos.get(KEY_PATH);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            IPath filePath = path != null ? new Path(path).append(file) : new Path((String)entryInfos.get("element")).append(file);
            this.printCVSTask("export -r " + (String)entryInfos.get(PROP_TAG) + ' ' + filePath.toString(), (String)entryInfos.get("cvsRoot"), destination.toString(), null, null, "true", null, null, script);
            script.println("<move file=\"" + destination + '/' + filePath + "\"" + " tofile=\"" + destination.append(file) + "\" failonerror=\"false\" />");
            ++i;
        }
    }

    public void addTargets(IAntScript script) {
        script.printTargetDeclaration(TARGET_GET_FROM_CVS, null, null, "${fileToCheck}", null);
        this.printCVSTask("export -d ${elementName}", "${cvsRoot}", "${destinationFolder}", "${module}", "${tag}", "${quiet}", null, "CVS - ${module}", script);
        script.printTargetEnd();
    }

    public void parseMapFileEntry(String repoSpecificentry, Properties overrideTags, Map entryInfos) throws CoreException {
        String[] arguments = Utils.getArrayFromStringWithBlank(repoSpecificentry, SEPARATOR);
        if (arguments.length < 2) {
            String message = NLS.bind((String)Messages.error_incorrectDirectoryEntry, entryInfos.get("element"));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        String overrideTag = overrideTags.getProperty("CVS");
        entryInfos.put(KEY_CVSPASSFILE, arguments.length > 4 && !arguments[4].equals("") ? arguments[4] : null);
        entryInfos.put(PROP_TAG, overrideTag != null && overrideTag.trim().length() != 0 ? overrideTag : arguments[0]);
        entryInfos.put("cvsRoot", arguments[1]);
        entryInfos.put(KEY_PASSWORD, arguments.length > 2 && !arguments[2].equals("") ? arguments[2] : null);
        entryInfos.put(KEY_PATH, arguments.length > 3 && !arguments[3].equals("") ? arguments[3] : null);
    }

    private void printCVSTask(String command, String cvsRoot, String dest, String module, String tag, String quiet, String passFile, String taskname, IAntScript script) {
        script.printTabs();
        script.print("<cvs");
        script.printAttribute("command", command, false);
        script.printAttribute("cvsRoot", cvsRoot, false);
        script.printAttribute("dest", dest, false);
        script.printAttribute("package", module, false);
        script.printAttribute(PROP_TAG, tag, false);
        script.printAttribute(PROP_QUIET, quiet, false);
        script.printAttribute("passfile", passFile, false);
        script.printAttribute("taskname", taskname, false);
        script.println("/>");
    }

    private void printCVSPassTask(String cvsRoot, String password, String passFile, IAntScript script) {
        script.printTabs();
        script.print("<cvspass");
        script.printAttribute("cvsRoot", cvsRoot, true);
        script.printAttribute(KEY_PASSWORD, password, true);
        script.printAttribute("passfile", passFile, false);
        script.println("/>");
    }

    private void printAvailableTask(String property, String file, IAntScript script) {
        script.printTabs();
        script.print("<available");
        script.printAttribute("property", property, true);
        script.printAttribute("file", file, false);
        script.println("/>");
    }
}

