/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.command.RemoveMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class SetOverrideCommand
extends AbstractCommand {
    protected MappingDomain mappingDomain;
    protected SetCommand setCommand;
    protected Command mapCommand;

    public SetOverrideCommand(MappingDomain domain, SetCommand setCommand) {
        super(setCommand.doGetLabel(), setCommand.doGetDescription());
        this.mappingDomain = domain;
        this.setCommand = setCommand;
    }

    protected boolean prepare() {
        return this.setCommand.doCanExecute();
    }

    public void execute() {
        Object object;
        TreeIterator objects;
        this.setCommand.doExecute();
        MappingRoot mappingRoot = this.mappingDomain.getMappingRoot();
        CompoundCommand subcommands = new CompoundCommand();
        if (this.setCommand.getOldValue() != null) {
            Object oldValue = this.setCommand.getOldValue();
            objects = this.mappingDomain.treeIterator(oldValue);
            while (objects.hasNext()) {
                object = objects.next();
                Iterator mappings = mappingRoot.getMappings(object).iterator();
                while (mappings.hasNext()) {
                    Mapping mapping = (Mapping)mappings.next();
                    EList outputs = mapping.getOutputs();
                    if (outputs.size() == 1 && outputs.iterator().next() == object) {
                        subcommands.append(RemoveMappingCommand.create(this.mappingDomain, mapping));
                        continue;
                    }
                    subcommands.append(RemoveCommand.create((EditingDomain)this.mappingDomain, (Object)mapping, (Object)MappingPackage.eINSTANCE.getMapping_Outputs(), object));
                }
            }
        }
        if (this.setCommand.getValue() != null) {
            Object value = this.setCommand.getValue();
            objects = this.mappingDomain.treeIterator(value);
            while (objects.hasNext()) {
                object = objects.next();
                MappedObjectState mappedObjectState = mappingRoot.getMappedObjectState(object);
                Object originatingInput = mappedObjectState.getOriginatingInput();
                if (originatingInput == null) {
                    mappedObjectState.setOutput();
                    continue;
                }
                if (!mappingRoot.isAttachedObject(object)) continue;
                subcommands.append(CreateMappingCommand.create(this.mappingDomain, originatingInput, object));
            }
        }
        this.mapCommand = subcommands.unwrap();
        if (this.mapCommand.canExecute()) {
            this.mapCommand.execute();
        } else {
            this.mapCommand.dispose();
            this.mapCommand = null;
        }
    }

    public void undo() {
        if (this.mapCommand != null) {
            this.mapCommand.undo();
        }
        this.setCommand.doUndo();
    }

    public void redo() {
        this.setCommand.doRedo();
        if (this.mapCommand != null) {
            this.mapCommand.redo();
        }
    }

    public void dispose() {
        if (this.mapCommand != null) {
            this.mapCommand.dispose();
        }
        this.setCommand.doDispose();
    }

    public Collection getResult() {
        return this.setCommand.doGetResult();
    }

    public Collection getAffectedObjects() {
        return this.setCommand.doGetAffectedObjects();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingDomain: " + this.mappingDomain + ")");
        result.append(" (mapCommand: " + this.mapCommand + ")");
        return result.toString();
    }
}

