/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class FlexibleProjectContainer
implements IClasspathContainer {
    private static ClasspathDecorationsManager decorations;
    private static final String SEPARATOR = "!";
    protected final IPath path;
    protected final IJavaProject owner;
    protected final IProject project;
    private final IPath[] paths;
    private final PathType[] pathTypes;
    private final List entries;
    private final IClasspathEntry[] cpentries;
    private static final Set containerTypes;

    static {
        Listener.register();
        decorations = new ClasspathDecorationsManager("org.eclipse.jst.common.frameworks");
        containerTypes = new HashSet();
    }

    public static String getDecorationManagerKey(IProject project, String container) {
        return String.valueOf(project.getName()) + SEPARATOR + container;
    }

    public FlexibleProjectContainer(IPath path, IJavaProject owner, IProject project, IPath[] paths, PathType[] types) {
        this.path = path;
        this.owner = owner;
        this.project = project;
        this.paths = paths;
        this.pathTypes = types;
        if (!FlexibleProjectContainer.isFlexibleProject(this.project)) {
            this.entries = Collections.EMPTY_LIST;
            this.cpentries = new IClasspathEntry[0];
            return;
        }
        FlexibleProjectContainer.addFlexibleProjectContainerType(path.segment(0));
        this.entries = this.computeClasspathEntries();
        this.cpentries = new IClasspathEntry[this.entries.size()];
        int i = 0;
        int n = this.entries.size();
        while (i < n) {
            IPath entryPath = (IPath)this.entries.get(i);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            this.cpentries[i] = resource != null && resource.getType() == 4 ? JavaCore.newProjectEntry((IPath)entryPath, (boolean)false) : this.newLibraryEntry(entryPath);
            ++i;
        }
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.cpentries;
    }

    public boolean isOutOfDate(IResourceDelta delta) {
        if (delta == null) {
            return false;
        }
        List currentEntries = this.computeClasspathEntries();
        return !this.entries.equals(currentEntries);
    }

    public abstract void refresh();

    static ClasspathDecorationsManager getDecorationsManager() {
        return decorations;
    }

    private List computeClasspathEntries() {
        ArrayList<IPath> entries = new ArrayList<IPath>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)this.project);
        if (vc == null) {
            return entries;
        }
        Set existingEntries = ClasspathUtil.getResolvedClasspath(this.owner, this.getPath());
        IVirtualReference[] refs = vc.getReferences();
        IVirtualComponent comp = null;
        HashSet<String> jarsHandled = new HashSet<String>();
        String jarName = null;
        int i = 0;
        while (i < refs.length) {
            comp = refs[i].getReferencedComponent();
            if (refs[i].getRuntimePath().equals((Object)this.paths[0].makeAbsolute())) {
                jarName = refs[i].getArchiveName();
                if (jarName != null) {
                    jarsHandled.add(jarName);
                }
                IPath newPath = null;
                if (comp.isBinary()) {
                    VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                    File diskFile = archiveComp.getUnderlyingDiskFile();
                    if (diskFile.exists()) {
                        newPath = new Path(diskFile.getAbsolutePath());
                    } else {
                        IFile iFile = archiveComp.getUnderlyingWorkbenchFile();
                        if (!entries.contains(iFile.getFullPath())) {
                            newPath = iFile.getFullPath();
                        }
                    }
                } else {
                    IProject project = comp.getProject();
                    newPath = project.getFullPath();
                }
                if (newPath != null && !existingEntries.contains(newPath)) {
                    entries.add(newPath);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.paths.length) {
            block21: {
                IVirtualFolder rootFolder = vc.getRootFolder();
                IVirtualFolder vf = rootFolder.getFolder(this.paths[i]);
                if (this.pathTypes[i] == PathType.LIB_DIRECTORY) {
                    IVirtualResource[] contents;
                    try {
                        contents = this.members(vf);
                    }
                    catch (CoreException e) {
                        CommonFrameworksPlugin.log((Exception)((Object)e));
                        break block21;
                    }
                    int j = 0;
                    while (j < contents.length) {
                        IResource r = contents[j].getUnderlyingResource();
                        IPath p = r.getFullPath();
                        if (!jarsHandled.contains(p.lastSegment()) && FlexibleProjectContainer.isJarFile(r)) {
                            jarsHandled.add(p.lastSegment());
                            if (!existingEntries.contains(p)) {
                                entries.add(p);
                            }
                        }
                        ++j;
                    }
                } else {
                    IContainer[] uf = vf.getUnderlyingFolders();
                    int j = 0;
                    while (j < uf.length) {
                        IPath p = uf[j].getFullPath();
                        if (!jarsHandled.contains(p.lastSegment()) && !this.isSourceOrOutputDirectory(p)) {
                            jarsHandled.add(p.lastSegment());
                            if (!existingEntries.contains(p)) {
                                entries.add(p);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return entries;
    }

    protected IVirtualResource[] members(IVirtualFolder vf) throws CoreException {
        return vf.members();
    }

    private IClasspathEntry newLibraryEntry(IPath p) {
        IPath srcpath = null;
        IPath srcrootpath = null;
        IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
        IAccessRule[] access = new IAccessRule[]{};
        ClasspathDecorations dec = decorations.getDecorations(FlexibleProjectContainer.getDecorationManagerKey(this.project, this.getPath().toString()), p.toString());
        if (dec != null) {
            srcpath = dec.getSourceAttachmentPath();
            srcrootpath = dec.getSourceAttachmentRootPath();
            attrs = dec.getExtraAttributes();
        }
        return JavaCore.newLibraryEntry((IPath)p, (IPath)srcpath, (IPath)srcrootpath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSourceOrOutputDirectory(IPath aPath) {
        if (!FlexibleProjectContainer.isJavaProject(this.project)) return false;
        try {
            IJavaProject jproject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] cp = jproject.getRawClasspath();
            int i = 0;
            while (true) {
                if (i >= cp.length) {
                    if (!jproject.getOutputLocation().equals((Object)aPath)) return false;
                    return true;
                }
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3) {
                    IPath src = cpe.getPath();
                    IPath output = cpe.getOutputLocation();
                    if (src.equals((Object)aPath) || output != null && output.equals((Object)aPath)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            CommonFrameworksPlugin.log((Exception)((Object)e));
        }
        return false;
    }

    private static boolean isJavaProject(IProject pj) {
        try {
            return pj.getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean isFlexibleProject(IProject pj) {
        try {
            return pj.getNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private static boolean isJarFile(IResource f) {
        String fname;
        return f.getType() == 1 && ((fname = f.getName()).endsWith(".jar") || fname.endsWith(".zip"));
    }

    private static boolean isMetadataFile(IResource f) {
        String fname;
        return f.getType() == 1 && ((fname = f.getName()).equals(".component") || fname.equals("org.eclipse.wst.common.component") || fname.equals(".classpath"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isFlexibleProjectContainer(IPath path) {
        Set set = containerTypes;
        synchronized (set) {
            return containerTypes.contains(path.segment(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFlexibleProjectContainerType(String type) {
        Set set = containerTypes;
        synchronized (set) {
            containerTypes.add(type);
        }
    }

    static /* synthetic */ boolean access$2(IResource iResource) {
        return FlexibleProjectContainer.isJarFile(iResource);
    }

    static /* synthetic */ boolean access$3(IResource iResource) {
        return FlexibleProjectContainer.isMetadataFile(iResource);
    }

    private static final class Listener
    implements IResourceChangeListener {
        private Listener() {
        }

        public static void register() {
            Listener listener = new Listener();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)listener, 8);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!Listener.isInterestingEvent(event)) {
                return;
            }
            ArrayList<IClasspathContainer> containers = new ArrayList<IClasspathContainer>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                try {
                    if (FlexibleProjectContainer.isJavaProject(project)) {
                        IJavaProject jproj = JavaCore.create((IProject)project);
                        IClasspathEntry[] cpes = jproj.getRawClasspath();
                        int j = 0;
                        while (j < cpes.length) {
                            IClasspathEntry cpe = cpes[j];
                            IPath path = cpe.getPath();
                            if (cpe.getEntryKind() == 5 && FlexibleProjectContainer.isFlexibleProjectContainer(path)) {
                                IClasspathContainer cont = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)jproj);
                                containers.add(cont);
                            }
                            ++j;
                        }
                    }
                }
                catch (JavaModelException e) {
                    CommonFrameworksPlugin.log((Exception)((Object)e));
                }
                ++i;
            }
            IResourceDelta delta = event.getDelta();
            int i2 = 0;
            int n = containers.size();
            while (i2 < n) {
                FlexibleProjectContainer c = (FlexibleProjectContainer)containers.get(i2);
                if (c.isOutOfDate(delta)) {
                    c.refresh();
                }
                ++i2;
            }
        }

        private static boolean isInterestingEvent(IResourceChangeEvent event) {
            boolean[] result = new boolean[1];
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(result){
                private final /* synthetic */ boolean[] val$result;
                {
                    this.val$result = blArray;
                }

                public boolean visit(IResourceDelta delta) {
                    IResource r = delta.getResource();
                    switch (r.getType()) {
                        case 8: {
                            return true;
                        }
                        case 4: {
                            return ModuleCoreNature.isFlexibleProject((IProject)((IProject)r));
                        }
                        case 2: {
                            int kind = delta.getKind();
                            if (kind == 1 || kind == 2) {
                                this.val$result[0] = true;
                                return false;
                            }
                            return true;
                        }
                        case 1: {
                            if (FlexibleProjectContainer.access$2(r) || FlexibleProjectContainer.access$3(r)) {
                                this.val$result[0] = true;
                            }
                            return false;
                        }
                    }
                    return false;
                }
            };
            try {
                event.getDelta().accept(visitor, false);
            }
            catch (CoreException e) {
                CommonFrameworksPlugin.log((Exception)((Object)e));
            }
            return result[0];
        }
    }

    protected static final class PathType {
        public static final PathType LIB_DIRECTORY = new PathType();
        public static final PathType CLASSES_DIRECTORY = new PathType();

        protected PathType() {
        }
    }
}

