/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filehistory;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistory;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSLocalFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class CVSFileHistory
extends FileHistory {
    protected ICVSFile cvsFile;
    protected IFileRevision[] revisions;
    protected IFileRevision[] remoteRevisions;
    protected IFileRevision[] localRevisions;
    protected boolean includeLocalRevisions;
    protected boolean includeRemoteRevisions;
    protected boolean includesExists;
    protected boolean refetchRevisions;
    private int flag;

    public CVSFileHistory(ICVSFile file) {
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = 0;
    }

    public CVSFileHistory(ICVSFile file, int flag) {
        this.cvsFile = file;
        this.includeLocalRevisions = false;
        this.includeRemoteRevisions = true;
        this.refetchRevisions = true;
        this.flag = flag;
    }

    public IFileRevision[] getFileRevisions() {
        if (this.revisions == null) {
            return new IFileRevision[0];
        }
        return this.revisions;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(IProgressMonitor monitor) throws TeamException {
        if (!this.refetchRevisions) {
            this.arrangeRevisions();
            return;
        }
        monitor.beginTask(NLS.bind((String)CVSMessages.CVSFileHistory_0, (Object)this.cvsFile.getRepositoryRelativePath()), 300);
        try {
            block17: {
                block15: {
                    entries = this.cvsFile.getLogEntries((IProgressMonitor)new SubProgressMonitor(monitor, 200));
                    if (entries.length == 0 && (folder = this.cvsFile.getParent()).isManaged()) {
                        remoteFolderLocation = folder.getRemoteLocation(folder);
                        remoteFileName = remoteFolderLocation.concat("/" + this.cvsFile.getName());
                        pro = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)this.cvsFile.getIResource().getProject());
                        root = pro.getCVSWorkspaceRoot();
                        location = CVSRepositoryLocation.fromString(root.getRemoteLocation().getLocation(false));
                        remFile = RemoteFile.create(remoteFileName, location);
                        entries = remFile.getLogEntries(monitor);
                    }
                    if (this.flag != 1) break block15;
                    revisionNumber = this.cvsFile.getSyncInfo().getRevision();
                    i = 0;
                    while (i < entries.length) {
                        block16: {
                            if (!entries[i].getRevision().equals(revisionNumber)) break block16;
                            this.remoteRevisions = new IFileRevision[]{new CVSFileRevision(entries[i])};
                            this.revisions = new IFileRevision[1];
                            System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                            ** GOTO lbl-1000
                        }
                        ++i;
                    }
                    ** GOTO lbl-1000
                }
                if (this.flag != 2) break block17;
                tempTag = this.cvsFile.getSyncInfo().getTag();
                entriesOfInterest = new ArrayList<ILogEntry>();
                i = 0;
                while (true) {
                    if (i >= entries.length) break;
                    tags = entries[i].getTags();
                    j = 0;
                    while (j < tags.length) {
                        if (tags[j].getType() == tempTag.getType()) {
                            if (tempTag.getType() == 1 && tempTag.getName().equals(tags[j].getName())) {
                                entriesOfInterest.add(entries[i]);
                                break;
                            }
                            entriesOfInterest.add(entries[i]);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.remoteRevisions = new IFileRevision[entriesOfInterest.size()];
                iter = entriesOfInterest.iterator();
                i = 0;
                while (true) {
                    block18: {
                        if (iter.hasNext()) break block18;
                        this.revisions = new IFileRevision[this.remoteRevisions.length];
                        System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                        ** GOTO lbl-1000
                    }
                    this.remoteRevisions[i++] = new CVSFileRevision((ILogEntry)iter.next());
                }
            }
            this.localRevisions = new IFileRevision[0];
            localResource = this.cvsFile.getIResource();
            this.includesExists = false;
            if (localResource != null && localResource instanceof IFile) {
                try {
                    localHistoryState = ((IFile)localResource).getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.localRevisions = this.convertToFileRevision(localHistoryState, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.includesExists = this.localRevisions.length > 0;
                }
                catch (CoreException e) {
                    TeamException.asTeamException((CoreException)e);
                }
            }
            this.remoteRevisions = new IFileRevision[entries.length];
            i = 0;
            while (true) {
                block19: {
                    if (i < entries.length) break block19;
                    this.revisions = new IFileRevision[0];
                    this.arrangeRevisions();
                    break;
                }
                this.remoteRevisions[i] = new CVSFileRevision(entries[i]);
                ++i;
            }
        }
        catch (Throwable var11_17) {
            var10_18 = null;
            monitor.done();
            throw var11_17;
        }
lbl-1000:
        // 4 sources

        {
            var10_19 = null;
            monitor.done();
            return;
        }
    }

    private void arrangeRevisions() {
        if (this.revisions != null) {
            if (this.includeLocalRevisions && this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length + this.localRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
                System.arraycopy(this.localRevisions, 0, this.revisions, this.remoteRevisions.length, this.localRevisions.length);
            } else if (this.includeLocalRevisions) {
                this.revisions = new IFileRevision[this.localRevisions.length];
                System.arraycopy(this.localRevisions, 0, this.revisions, 0, this.localRevisions.length);
            } else if (this.includeRemoteRevisions) {
                this.revisions = new IFileRevision[this.remoteRevisions.length];
                System.arraycopy(this.remoteRevisions, 0, this.revisions, 0, this.remoteRevisions.length);
            }
        }
    }

    public IFileRevision getFileRevision(String id) {
        IFileRevision[] revisions = this.getFileRevisions();
        int i = 0;
        while (i < revisions.length) {
            if (revisions[i].getContentIdentifier().equals(id)) {
                return revisions[i];
            }
            ++i;
        }
        return null;
    }

    public IFileRevision[] getContributors(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        IFileRevision fileRevision = null;
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isPredecessorOf(revision)) {
                if (fileRevision == null) {
                    fileRevision = revisions[i];
                }
                if (revisions[i].getTimestamp() > fileRevision.getTimestamp()) {
                    fileRevision = revisions[i];
                }
            }
            ++i;
        }
        if (fileRevision == null) {
            return new IFileRevision[0];
        }
        return new IFileRevision[]{fileRevision};
    }

    public IFileRevision[] getTargets(IFileRevision revision) {
        IFileRevision[] revisions = this.getFileRevisions();
        ArrayList<IFileRevision> directDescendents = new ArrayList<IFileRevision>();
        int i = 0;
        while (i < revisions.length) {
            if (((CVSFileRevision)revisions[i]).isDescendentOf(revision)) {
                directDescendents.add(revisions[i]);
            }
            ++i;
        }
        return directDescendents.toArray(new IFileRevision[directDescendents.size()]);
    }

    private IFileRevision[] convertToFileRevision(IFileState[] localRevisions, IProgressMonitor monitor) {
        boolean modified = false;
        try {
            modified = this.cvsFile.isModified(monitor);
        }
        catch (CVSException cVSException) {}
        IFile localFile = (IFile)this.cvsFile.getIResource();
        boolean localFileExists = localFile != null && localFile.exists();
        int arrayLength = 0;
        if (modified && localFileExists) {
            ++arrayLength;
        }
        IFileRevision[] fileRevisions = new IFileRevision[arrayLength += localRevisions.length];
        int i = 0;
        while (i < localRevisions.length) {
            IFileState localFileState = localRevisions[i];
            CVSLocalFileRevision localRevision = new CVSLocalFileRevision(localFileState);
            fileRevisions[i] = localRevision;
            ++i;
        }
        if (modified && localFileExists) {
            CVSLocalFileRevision currentFile = new CVSLocalFileRevision(localFile);
            CVSFileHistoryProvider provider = new CVSFileHistoryProvider();
            currentFile.setBaseRevision(provider.getWorkspaceFileRevision((IResource)localFile));
            fileRevisions[localRevisions.length] = currentFile;
        }
        return fileRevisions;
    }

    public void includeLocalRevisions(boolean flag) {
        this.includeLocalRevisions = flag;
    }

    public boolean getIncludesExists() {
        return this.includesExists;
    }

    public void setRefetchRevisions(boolean refetch) {
        this.refetchRevisions = refetch;
    }

    public void includeRemoteRevisions(boolean flag) {
        this.includeRemoteRevisions = flag;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetchLocalOnly(IProgressMonitor monitor) {
        try {
            try {
                this.localRevisions = new IFileRevision[0];
                IResource localResource = this.cvsFile.getIResource();
                this.includesExists = false;
                if (localResource != null && localResource instanceof IFile) {
                    IFileState[] localHistoryState = ((IFile)localResource).getHistory((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.localRevisions = this.convertToFileRevision(localHistoryState, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.includesExists = this.localRevisions.length > 0;
                }
                this.remoteRevisions = new IFileRevision[0];
                this.revisions = new IFileRevision[0];
                this.arrangeRevisions();
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public boolean isInitialized() {
        return this.revisions != null;
    }

    public boolean isIncludeLocal() {
        return this.includeLocalRevisions;
    }
}

