/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;

public class MoveDeleteHook
implements IMoveDeleteHook {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFile(final IResourceTree tree, final IFile file, final int updateFlags, IProgressMonitor monitor) {
        try {
            try {
                block12: {
                    block11: {
                        block10: {
                            monitor.beginTask(null, 100);
                            if (!file.isTeamPrivateMember()) break block10;
                            break block11;
                        }
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor(file);
                        if (!cvsFile.isIgnored()) break block12;
                    }
                    Object var6_5 = null;
                    monitor.done();
                    return false;
                }
                if (!this.checkOutFiles(tree, new IFile[]{file}, Policy.subMonitorFor(monitor, 30))) {
                    Object var6_6 = null;
                    monitor.done();
                    return true;
                }
                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws CVSException {
                        try {
                            monitor.beginTask(null, 100);
                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)file, Policy.subMonitorFor(monitor, 40));
                            tree.standardDeleteFile(file, updateFlags, Policy.subMonitorFor(monitor, 60));
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var2_4 = null;
                        }
                        monitor.done();
                    }
                }, Policy.subMonitorFor(monitor, 70));
            }
            catch (CVSException e) {
                tree.failed(e.getStatus());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFolder(final IResourceTree tree, final IFolder folder, final int updateFlags, IProgressMonitor monitor) {
        block9: {
            block8: {
                if (folder.isTeamPrivateMember()) {
                    return false;
                }
                monitor.beginTask(null, 100);
                try {
                    try {
                        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)folder);
                        if (cvsFolder.isCVSFolder() && this.ensureCheckedOut(new IFolder[]{folder}, tree, Policy.subMonitorFor(monitor, 30))) {
                            EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                                /*
                                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run(IProgressMonitor monitor) throws CVSException {
                                    try {
                                        monitor.beginTask(null, 100);
                                        EclipseSynchronizer.getInstance().prepareForDeletion((IResource)folder, Policy.subMonitorFor(monitor, 20));
                                        tree.standardDeleteFolder(folder, updateFlags, Policy.subMonitorFor(monitor, 50));
                                    }
                                    catch (Throwable throwable) {
                                        Object var2_3 = null;
                                        monitor.done();
                                        throw throwable;
                                    }
                                    {
                                        Object var2_4 = null;
                                    }
                                    monitor.done();
                                }
                            }, Policy.subMonitorFor(monitor, 70));
                            Object var6_7 = null;
                            break block8;
                        }
                        if (!cvsFolder.isIgnored()) {
                            EclipseSynchronizer.getInstance().prepareForDeletion(cvsFolder.getIResource(), Policy.subMonitorFor(monitor, 70));
                        }
                        break block9;
                    }
                    catch (CVSException e) {
                        tree.failed(e.getStatus());
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }
        Object var6_9 = null;
        monitor.done();
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        try {
            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)project, monitor);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveFile(final IResourceTree tree, final IFile source, final IFile destination, final int updateFlags, IProgressMonitor monitor) {
        block7: {
            block6: {
                try {
                    try {
                        monitor.beginTask(null, 100);
                        IFile[] filesToCheckOut = destination.exists() ? new IFile[]{source, destination} : new IFile[]{source};
                        if (!this.checkOutFiles(tree, filesToCheckOut, Policy.subMonitorFor(monitor, 30))) {
                            Object var7_8 = null;
                            break block6;
                        }
                        EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IProgressMonitor monitor) throws CVSException {
                                try {
                                    monitor.beginTask(null, 100);
                                    EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, Policy.subMonitorFor(monitor, 40));
                                    if (destination.exists()) {
                                        EclipseSynchronizer.getInstance().prepareForDeletion((IResource)destination, Policy.subMonitorFor(monitor, 20));
                                    }
                                    tree.standardMoveFile(source, destination, updateFlags, Policy.subMonitorFor(monitor, 40));
                                    EclipseSynchronizer.getInstance().postMove((IResource)destination);
                                }
                                catch (Throwable throwable) {
                                    Object var2_3 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                                {
                                    Object var2_4 = null;
                                }
                                monitor.done();
                            }
                        }, Policy.subMonitorFor(monitor, 70));
                    }
                    catch (CVSException e) {
                        tree.failed(e.getStatus());
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }
        Object var7_10 = null;
        monitor.done();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveFolder(final IResourceTree tree, final IFolder source, final IFolder destination, final int updateFlags, IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        try {
            block10: {
                block9: {
                    try {
                        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)source);
                        if (cvsFolder.isManaged()) {
                            if (!this.ensureCheckedOut(new IFolder[]{source, destination}, tree, Policy.subMonitorFor(monitor, 20))) {
                                break block9;
                            } else {
                                EclipseSynchronizer.getInstance().performMoveDelete(new ICVSRunnable(){

                                    public void run(IProgressMonitor monitor) throws CVSException {
                                        EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, Policy.subMonitorFor(monitor, 20));
                                        if (destination.exists()) {
                                            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)destination, Policy.subMonitorFor(monitor, 20));
                                        }
                                        tree.standardMoveFolder(source, destination, updateFlags, Policy.subMonitorFor(monitor, 30));
                                        this.purgeCVSFolders(destination, Policy.subMonitorFor(monitor, 20));
                                        EclipseSynchronizer.getInstance().postMove((IResource)destination);
                                    }

                                    private void purgeCVSFolders(IFolder destination2, IProgressMonitor monitor) throws CVSException {
                                        try {
                                            destination2.accept(new IResourceVisitor(this, tree, updateFlags, monitor){
                                                final /* synthetic */ 4 this$1;
                                                private final /* synthetic */ IResourceTree val$tree;
                                                private final /* synthetic */ int val$updateFlags;
                                                private final /* synthetic */ IProgressMonitor val$monitor;
                                                {
                                                    this.this$1 = var1_1;
                                                    this.val$tree = iResourceTree;
                                                    this.val$updateFlags = n;
                                                    this.val$monitor = iProgressMonitor;
                                                }

                                                public boolean visit(IResource resource) throws CoreException {
                                                    if (resource.getType() == 2 && resource.getName().equals("CVS")) {
                                                        this.val$tree.standardDeleteFolder((IFolder)resource, this.val$updateFlags, this.val$monitor);
                                                        return false;
                                                    }
                                                    return true;
                                                }
                                            }, 2, 2);
                                        }
                                        catch (CoreException e) {
                                            throw CVSException.wrapException(e);
                                        }
                                    }
                                }, Policy.subMonitorFor(monitor, 60));
                            }
                            break block9;
                        }
                        if (!cvsFolder.isIgnored()) {
                            EclipseSynchronizer.getInstance().prepareForDeletion(cvsFolder.getIResource(), Policy.subMonitorFor(monitor, 60));
                        }
                        break block10;
                    }
                    catch (CVSException e) {
                        tree.failed(e.getStatus());
                    }
                }
                Object var7_8 = null;
                monitor.done();
                return true;
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        try {
            EclipseSynchronizer.getInstance().prepareForDeletion((IResource)source, monitor);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    boolean checkOutFiles(IResourceTree tree, IFile[] files, IProgressMonitor monitor) {
        IFileModificationValidator validator = this.getFileModificationValidator(files);
        if (validator instanceof ICVSFileModificationValidator) {
            IStatus status = ((ICVSFileModificationValidator)validator).validateMoveDelete(files, monitor);
            if (status.isOK()) {
                return true;
            }
            tree.failed(status);
            return false;
        }
        return true;
    }

    private boolean ensureCheckedOut(IFolder[] folders, IResourceTree tree, IProgressMonitor monitor) {
        ArrayList readOnlyFiles;
        block5: {
            readOnlyFiles = new ArrayList();
            try {
                int i = 0;
                while (i < folders.length) {
                    IFolder folder = folders[i];
                    if (folder.exists()) {
                        folder.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                IFile file;
                                if (resource.getType() == 1 && (file = (IFile)resource).isReadOnly()) {
                                    readOnlyFiles.add(file);
                                }
                                return true;
                            }
                        });
                    }
                    ++i;
                }
                if (!readOnlyFiles.isEmpty()) break block5;
                return true;
            }
            catch (CoreException e) {
                tree.failed(e.getStatus());
                return false;
            }
        }
        return this.checkOutFiles(tree, readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), monitor);
    }

    private IFileModificationValidator getFileModificationValidator(IFile[] files) {
        return this.getProvider(files).getFileModificationValidator();
    }

    private CVSTeamProvider getProvider(IFile[] files) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)files[0].getProject(), (String)CVSProviderPlugin.getTypeId());
        return provider;
    }
}

