/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.text.TextSearchEngineRegistry;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPageDescriptor;
import org.eclipse.search.internal.ui.SorterDescriptor;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.text2.TextSearchQueryProviderRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SearchPlugin
extends AbstractUIPlugin {
    public static final String SEARCH_PAGE_EXTENSION_POINT = "searchPages";
    public static final String SORTER_EXTENSION_POINT = "searchResultSorters";
    public static final String FILTERED_SEARCH_MARKER = "org.eclipse.search.filteredsearchmarker";
    public static final String SEARCH_ANNOTATION_TYPE = "org.eclipse.search.results";
    public static final String FILTERED_SEARCH_ANNOTATION_TYPE = "org.eclipse.search.filteredResults";
    public static final int INTERNAL_ERROR = 1;
    private static SearchPlugin fgSearchPlugin;
    private List fPageDescriptors;
    private List fSorterDescriptors;
    private TextSearchEngineRegistry fTextSearchEngineRegistry;
    private TextSearchQueryProviderRegistry fTextSearchQueryProviderRegistry;

    public SearchPlugin() {
        Assert.isTrue((fgSearchPlugin == null ? 1 : 0) != 0);
        fgSearchPlugin = this;
        this.fTextSearchEngineRegistry = null;
        this.fTextSearchQueryProviderRegistry = null;
    }

    public static SearchPlugin getDefault() {
        return fgSearchPlugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = fgSearchPlugin.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            final WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    SearchPlugin.setActiveWorkbenchWindow(windowRef);
                }
            });
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            shell = shell.getParent();
        }
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            ++i;
        }
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = SearchPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void beep() {
        SearchPlugin.getActiveWorkbenchShell().getDisplay().beep();
    }

    public static IWorkbenchPage getActivePage() {
        return SearchPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    static boolean setAutoBuilding(boolean state) {
        IWorkspaceDescription workspaceDesc = SearchPlugin.getWorkspace().getDescription();
        boolean isAutobuilding = workspaceDesc.isAutoBuilding();
        if (isAutobuilding != state) {
            workspaceDesc.setAutoBuilding(state);
            try {
                SearchPlugin.getWorkspace().setDescription(workspaceDesc);
            }
            catch (CoreException ex) {
                ExceptionHandler.handle(ex, SearchMessages.Search_Error_setDescription_title, SearchMessages.Search_Error_setDescription_message);
            }
        }
        return isAutobuilding;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        InternalSearchUI.shutdown();
        SearchPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)SearchManager.getDefault());
        super.stop(context);
        fgSearchPlugin = null;
    }

    public List getSearchPageDescriptors() {
        if (this.fPageDescriptors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search", SEARCH_PAGE_EXTENSION_POINT);
            this.fPageDescriptors = this.createSearchPageDescriptors(elements);
        }
        return this.fPageDescriptors;
    }

    public List getEnabledSearchPageDescriptors(String pageId) {
        Iterator iter = this.getSearchPageDescriptors().iterator();
        ArrayList<SearchPageDescriptor> enabledDescriptors = new ArrayList<SearchPageDescriptor>(5);
        while (iter.hasNext()) {
            SearchPageDescriptor desc = (SearchPageDescriptor)iter.next();
            if (!desc.isEnabled() && !desc.getId().equals(pageId)) continue;
            enabledDescriptors.add(desc);
        }
        return enabledDescriptors;
    }

    public String getSearchViewHelpContextId() {
        Search currentSearch = SearchManager.getDefault().getCurrentSearch();
        if (currentSearch != null) {
            String pageId = currentSearch.getPageId();
            Iterator iter = this.getSearchPageDescriptors().iterator();
            while (iter.hasNext()) {
                SearchPageDescriptor desc = (SearchPageDescriptor)iter.next();
                if (!desc.getId().equals(pageId)) continue;
                String helpId = desc.getSearchViewHelpContextId();
                if (helpId == null) {
                    return "org.eclipse.search.search_view_context";
                }
                return desc.getSearchViewHelpContextId();
            }
        }
        return "org.eclipse.search.search_view_context";
    }

    private List createSearchPageDescriptors(IConfigurationElement[] elements) {
        ArrayList<SearchPageDescriptor> result = new ArrayList<SearchPageDescriptor>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("page".equals(element.getName())) {
                SearchPageDescriptor desc = new SearchPageDescriptor(element);
                result.add(desc);
            }
            ++i;
        }
        Collections.sort(result);
        return result;
    }

    public List getSorterDescriptors() {
        if (this.fSorterDescriptors == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search", SORTER_EXTENSION_POINT);
            this.fSorterDescriptors = this.createSorterDescriptors(elements);
        }
        return this.fSorterDescriptors;
    }

    public TextSearchEngineRegistry getTextSearchEngineRegistry() {
        if (this.fTextSearchEngineRegistry == null) {
            this.fTextSearchEngineRegistry = new TextSearchEngineRegistry();
        }
        return this.fTextSearchEngineRegistry;
    }

    public TextSearchQueryProviderRegistry getTextSearchQueryProviderRegistry() {
        if (this.fTextSearchQueryProviderRegistry == null) {
            this.fTextSearchQueryProviderRegistry = new TextSearchQueryProviderRegistry();
        }
        return this.fTextSearchQueryProviderRegistry;
    }

    private List createSorterDescriptors(IConfigurationElement[] elements) {
        ArrayList<SorterDescriptor> result = new ArrayList<SorterDescriptor>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("sorter".equals(element.getName())) {
                result.add(new SorterDescriptor(element));
            }
            ++i;
        }
        return result;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void log(IStatus status) {
        SearchPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        SearchPlugin.log((IStatus)new Status(4, "org.eclipse.search", 1, SearchMessages.SearchPlugin_internal_error, e));
    }

    public static String getID() {
        return "org.eclipse.search";
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.removeMatches"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        private WindowRef() {
        }
    }
}

