/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class JavaLineBreakpoint
extends JavaBreakpoint
implements IJavaLineBreakpoint {
    protected static final String CONDITION = "org.eclipse.jdt.debug.core.condition";
    protected static final String CONDITION_ENABLED = "org.eclipse.jdt.debug.core.conditionEnabled";
    protected static final String CONDITION_SUSPEND_ON_TRUE = "org.eclipse.jdt.debug.core.conditionSuspendOnTrue";
    protected static final String SOURCE_NAME = "org.eclipse.jdt.debug.core.sourceName";
    private static final String JAVA_LINE_BREAKPOINT = "org.eclipse.jdt.debug.javaLineBreakpointMarker";
    private Map fSuspendEvents = new HashMap();
    private Map fCompiledExpressions = new HashMap();
    private Map fProjectsByFrame = new HashMap();
    private Map fConditionValues = new HashMap();
    public static final int NO_LINE_NUMBERS = 162;
    static /* synthetic */ Class class$0;

    public JavaLineBreakpoint() {
    }

    public JavaLineBreakpoint(IResource resource, String typeName, int lineNumber, int charStart, int charEnd, int hitCount, boolean add, Map attributes) throws DebugException {
        this(resource, typeName, lineNumber, charStart, charEnd, hitCount, add, attributes, JAVA_LINE_BREAKPOINT);
    }

    protected JavaLineBreakpoint(final IResource resource, final String typeName, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaLineBreakpoint.this.setMarker(resource.createMarker(markerType));
                JavaLineBreakpoint.this.addLineBreakpointAttributes(attributes, JavaLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                JavaLineBreakpoint.this.addTypeNameAndHitCount(attributes, typeName, hitCount);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(JavaLineBreakpoint.this.getDefaultSuspendPolicy()));
                JavaLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaLineBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public void addToTarget(JDIDebugTarget target) throws CoreException {
        this.clearCachedExpressionFor(target);
        super.addToTarget(target);
    }

    public void removeFromTarget(JDIDebugTarget target) throws CoreException {
        this.clearCachedExpressionFor(target);
        this.clearCachedSuspendEvents(target);
        this.fConditionValues.remove(target);
        super.removeFromTarget(target);
    }

    protected void clearCachedSuspendEvents(JDIDebugTarget target) {
        this.removeCachedThreads(this.fSuspendEvents, target);
    }

    private void removeCachedThreads(Map map, JDIDebugTarget target) {
        Set threads = map.keySet();
        ArrayList<JDIThread> threadsToRemove = new ArrayList<JDIThread>();
        Iterator<Object> iter = threads.iterator();
        while (iter.hasNext()) {
            JDIThread thread = (JDIThread)iter.next();
            if (thread.getDebugTarget() != target) continue;
            threadsToRemove.add(thread);
        }
        iter = threadsToRemove.iterator();
        while (iter.hasNext()) {
            map.remove(iter.next());
        }
    }

    protected void clearCachedExpressionFor(JDIDebugTarget target) {
        this.removeCachedThreads(this.fCompiledExpressions, target);
        Set frames = this.fProjectsByFrame.keySet();
        ArrayList<JDIStackFrame> framesToRemove = new ArrayList<JDIStackFrame>();
        Iterator<Object> iter = frames.iterator();
        while (iter.hasNext()) {
            JDIStackFrame frame = (JDIStackFrame)iter.next();
            if (frame.getDebugTarget() != target) continue;
            framesToRemove.add(frame);
        }
        iter = framesToRemove.iterator();
        while (iter.hasNext()) {
            this.fProjectsByFrame.remove(iter.next());
        }
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return JAVA_LINE_BREAKPOINT;
    }

    protected EventRequest[] newRequests(JDIDebugTarget target, ReferenceType type) throws CoreException {
        int lineNumber = this.getLineNumber();
        List locations = this.determineLocations(lineNumber, type, target);
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        EventRequest[] requests = new EventRequest[locations.size()];
        int i = 0;
        Iterator iterator = locations.iterator();
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            requests[i] = this.createLineBreakpointRequest(location, target);
            ++i;
        }
        return requests;
    }

    protected BreakpointRequest createLineBreakpointRequest(Location location, JDIDebugTarget target) throws CoreException {
        BreakpointRequest request = null;
        EventRequestManager manager = target.getEventRequestManager();
        if (manager == null) {
            target.requestFailed(JDIDebugBreakpointMessages.JavaLineBreakpoint_Unable_to_create_breakpoint_request___VM_disconnected__1, null);
        }
        try {
            request = manager.createBreakpointRequest(location);
            this.configureRequest(request, target);
        }
        catch (VMDisconnectedException e) {
            if (!target.isAvailable()) {
                return null;
            }
            JDIDebugPlugin.log(e);
        }
        catch (RuntimeException e) {
            target.internalError(e);
            return null;
        }
        return request;
    }

    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
        ((BreakpointRequest)request).addThreadFilter(thread);
    }

    protected List determineLocations(int lineNumber, ReferenceType type, JDIDebugTarget target) {
        List<Location> locations = null;
        try {
            locations = type.locationsOfLine(lineNumber);
        }
        catch (AbsentInformationException absentInformationException) {
            Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 162, JDIDebugBreakpointMessages.JavaLineBreakpoint_Absent_Line_Number_Information_1, null);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler != null) {
                try {
                    handler.handleStatus((IStatus)status, (Object)type);
                }
                catch (CoreException coreException) {}
            }
            return null;
        }
        catch (NativeMethodException nativeMethodException) {
            return null;
        }
        catch (InvalidLineNumberException invalidLineNumberException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            return null;
        }
        catch (RuntimeException e) {
            target.internalError(e);
            return null;
        }
        return locations;
    }

    public void addLineBreakpointAttributes(Map attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
    }

    public void addTypeNameAndHitCount(Map attributes, String typeName, int hitCount) {
        attributes.put("org.eclipse.jdt.debug.core.typeName", typeName);
        if (hitCount > 0) {
            attributes.put("org.eclipse.jdt.debug.core.hitCount", new Integer(hitCount));
            attributes.put("org.eclipse.jdt.debug.core.expired", Boolean.FALSE);
        }
    }

    public boolean handleBreakpointEvent(Event event, JDIDebugTarget target, JDIThread thread) {
        if (this.hasCondition()) {
            try {
                return this.handleConditionalBreakpointEvent(event, thread, target);
            }
            catch (CoreException exception) {
                JDIDebugPlugin.log(exception);
                return !this.suspendForEvent(event, thread);
            }
        }
        return !this.suspendForEvent(event, thread);
    }

    protected boolean hasCondition() {
        try {
            String condition = this.getCondition();
            return this.isConditionEnabled() && condition != null && condition.length() > 0;
        }
        catch (CoreException exception) {
            JDIDebugPlugin.log(exception);
            return false;
        }
    }

    protected boolean suspendForEvent(Event event, JDIThread thread) {
        this.expireHitCount(event);
        return this.suspend(thread);
    }

    protected boolean suspendForCondition(Event event, JDIThread thread) {
        this.expireHitCount(event);
        return thread.handleSuspendForBreakpoint(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleConditionalBreakpointEvent(Event event, JDIThread thread, JDIDebugTarget target) throws CoreException {
        JDIThread jDIThread = thread;
        synchronized (jDIThread) {
            if (thread.isPerformingEvaluation()) {
                return !this.suspendForEvent(event, thread);
            }
            String condition = this.getCondition();
            if (!this.hasCondition()) {
                return !this.suspendForEvent(event, thread);
            }
            EvaluationListener listener = new EvaluationListener();
            int suspendPolicy = 2;
            try {
                suspendPolicy = this.getSuspendPolicy();
            }
            catch (CoreException coreException) {}
            if (suspendPolicy == 1) {
                ((JDIDebugTarget)thread.getDebugTarget()).prepareToSuspendByBreakpoint(this);
            } else {
                thread.handleSuspendForBreakpointQuiet(this);
            }
            List frames = thread.computeNewStackFrames();
            if (frames.size() == 0) {
                return !this.suspendForEvent(event, thread);
            }
            JDIStackFrame frame = (JDIStackFrame)frames.get(0);
            IJavaProject project = this.getJavaProject(frame);
            if (project == null) {
                throw new CoreException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5012, JDIDebugBreakpointMessages.JavaLineBreakpoint_Unable_to_compile_conditional_breakpoint___missing_Java_project_context__1, null));
            }
            IAstEvaluationEngine engine = this.getEvaluationEngine(target, project);
            if (engine == null) {
                return !this.suspendForEvent(event, thread);
            }
            ICompiledExpression expression = (ICompiledExpression)this.fCompiledExpressions.get(thread);
            if (expression == null) {
                expression = engine.getCompiledExpression(condition, frame);
                this.fCompiledExpressions.put(thread, expression);
            }
            if (this.conditionHasErrors(expression)) {
                this.fireConditionHasErrors(expression);
                return !this.suspendForEvent(event, thread);
            }
            this.fSuspendEvents.put(thread, event);
            thread.setEvaluatingConditionalBreakpoint(true);
            engine.evaluateExpression(expression, frame, listener, 128, false);
            return false;
        }
    }

    private IJavaProject getJavaProject(JDIStackFrame stackFrame) {
        IJavaProject project = (IJavaProject)this.fProjectsByFrame.get(stackFrame);
        if (project == null && (project = this.computeJavaProject(stackFrame)) != null) {
            this.fProjectsByFrame.put(stackFrame, project);
        }
        return project;
    }

    private IJavaProject computeJavaProject(JDIStackFrame stackFrame) {
        IJavaProject project;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = null;
        try {
            String[] sourcePaths;
            IJavaType thisType;
            if (locator instanceof ISourceLookupDirector && !stackFrame.isStatic() && (thisType = stackFrame.getThis().getJavaType()) instanceof IJavaReferenceType && (sourcePaths = ((IJavaReferenceType)thisType).getSourcePaths(null)) != null && sourcePaths.length > 0) {
                sourceElement = ((ISourceLookupDirector)locator).getSourceElement((Object)sourcePaths[0]);
            }
        }
        catch (DebugException e) {
            DebugPlugin.log((Throwable)e);
        }
        if (sourceElement == null) {
            sourceElement = locator.getSourceElement((IStackFrame)stackFrame);
        }
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            Object element;
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = iAdaptable.getAdapter((Class)clazz)) != null) {
                sourceElement = element;
            }
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        return null;
    }

    private void fireConditionHasRuntimeErrors(DebugException exception) {
        JDIDebugPlugin.getDefault().fireBreakpointHasRuntimeException(this, exception);
    }

    private void fireConditionHasErrors(ICompiledExpression expression) {
        JDIDebugPlugin.getDefault().fireBreakpointHasCompilationErrors(this, this.getMessages(expression));
    }

    private Message[] getMessages(ICompiledExpression expression) {
        String[] errorMessages = expression.getErrorMessages();
        Message[] messages = new Message[errorMessages.length];
        int i = 0;
        while (i < messages.length) {
            messages[i] = new Message(errorMessages[i], -1);
            ++i;
        }
        return messages;
    }

    public boolean conditionHasErrors(ICompiledExpression expression) {
        return expression.hasErrors();
    }

    public IAstEvaluationEngine getEvaluationEngine(IJavaDebugTarget vm, IJavaProject project) {
        return ((JDIDebugTarget)vm).getEvaluationEngine(project);
    }

    public boolean supportsCondition() {
        return true;
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    public void setCondition(String condition) throws CoreException {
        this.fCompiledExpressions.clear();
        this.fConditionValues.clear();
        this.fSuspendEvents.clear();
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
        this.recreate();
    }

    protected String getMarkerMessage(boolean conditionEnabled, String condition, int hitCount, int suspendPolicy, int lineNumber) {
        StringBuffer message = new StringBuffer(super.getMarkerMessage(hitCount, suspendPolicy));
        if (lineNumber != -1) {
            message.append(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaLineBreakpoint___line___0___1, (Object[])new Object[]{Integer.toString(lineNumber)}));
        }
        if (conditionEnabled && condition != null) {
            message.append(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaLineBreakpoint___Condition___0___2, (Object[])new Object[]{condition}));
        }
        return message.toString();
    }

    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{conditionEnabled});
        this.recreate();
    }

    protected void cleanupForThreadTermination(JDIThread thread) {
        this.fSuspendEvents.remove(thread);
        this.fCompiledExpressions.remove(thread);
        super.cleanupForThreadTermination(thread);
    }

    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
        if (request instanceof BreakpointRequest) {
            ((BreakpointRequest)request).addInstanceFilter(object);
        }
    }

    public boolean isConditionSuspendOnTrue() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        if (this.isConditionSuspendOnTrue() != suspendOnTrue) {
            this.setAttributes(new String[]{CONDITION_SUSPEND_ON_TRUE}, new Object[]{suspendOnTrue});
            this.fConditionValues.clear();
            this.recreate();
        }
    }

    class EvaluationListener
    implements IEvaluationListener {
        EvaluationListener() {
        }

        public void evaluationComplete(IEvaluationResult result) {
            JDIThread thread = (JDIThread)result.getThread();
            thread.setEvaluatingConditionalBreakpoint(false);
            Event event = (Event)JavaLineBreakpoint.this.fSuspendEvents.get(thread);
            if (result.hasErrors()) {
                DebugException exception = result.getException();
                Throwable wrappedException = exception.getStatus().getException();
                if (wrappedException instanceof VMDisconnectedException) {
                    JDIDebugPlugin.log(wrappedException);
                    try {
                        thread.resumeQuiet();
                    }
                    catch (DebugException e) {
                        JDIDebugPlugin.log(e);
                    }
                } else {
                    JavaLineBreakpoint.this.fireConditionHasRuntimeErrors(exception);
                    JavaLineBreakpoint.this.suspendForCondition(event, thread);
                    return;
                }
            }
            try {
                IJavaValue value = result.getValue();
                if (JavaLineBreakpoint.this.isConditionSuspendOnTrue()) {
                    if (value instanceof IJavaPrimitiveValue) {
                        IJavaPrimitiveValue javaValue = (IJavaPrimitiveValue)value;
                        if (JavaLineBreakpoint.this.isConditionSuspendOnTrue() && javaValue.getJavaType().getName().equals("boolean") && javaValue.getBooleanValue()) {
                            JavaLineBreakpoint.this.suspendForCondition(event, thread);
                            return;
                        }
                    }
                } else {
                    IDebugTarget debugTarget = thread.getDebugTarget();
                    IValue lastValue = (IValue)JavaLineBreakpoint.this.fConditionValues.get(debugTarget);
                    JavaLineBreakpoint.this.fConditionValues.put(debugTarget, value);
                    if (!value.equals(lastValue)) {
                        JavaLineBreakpoint.this.suspendForCondition(event, thread);
                        return;
                    }
                }
                int suspendPolicy = 2;
                try {
                    suspendPolicy = JavaLineBreakpoint.this.getSuspendPolicy();
                }
                catch (CoreException coreException) {}
                if (suspendPolicy == 1) {
                    ((JDIDebugTarget)thread.getDebugTarget()).resumeQuiet();
                } else {
                    thread.resumeQuiet();
                }
                return;
            }
            catch (DebugException e) {
                JDIDebugPlugin.log(e);
                JavaLineBreakpoint.this.suspendForEvent(event, thread);
                return;
            }
        }
    }
}

