/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class CleanUpAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public CleanUpAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.CleanUpAction_label);
        this.setToolTipText(ActionMessages.CleanUpAction_tooltip);
        this.setDescription(ActionMessages.CleanUpAction_description);
    }

    public CleanUpAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = CleanUpAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.CleanUpAction_EmptySelection_title, (String)ActionMessages.CleanUpAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.runOnMultiple(cus);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(CleanUpAction.getCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block13: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block13;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block13;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.CleanUpAction_ErrorDialogTitle, this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        try {
            RefactoringExecutionStarter.startCleanupRefactoring(cu);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.showUnexpectedError((CoreException)((Object)e));
        }
    }

    public void runOnMultiple(ICompilationUnit[] cus) {
        String message = ActionMessages.CleanUpAction_MultiStateErrorTitle;
        MultiStatus status = new MultiStatus("org.eclipse.jdt.ui", 0, message, null);
        int i = 0;
        while (i < cus.length) {
            this.testOnBuildPath(cus[i], status);
            ++i;
        }
        if (!status.isOK()) {
            String title = ActionMessages.CleanUpAction_ErrorDialogTitle;
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            return;
        }
        try {
            RefactoringExecutionStarter.startCleanupRefactoring(cus);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.showUnexpectedError((CoreException)((Object)e));
        }
    }

    private void showUnexpectedError(CoreException e) {
        String message2 = Messages.format(ActionMessages.CleanUpAction_UnexpectedErrorMessage, e.getStatus().getMessage());
        Status status = new Status(4, "org.eclipse.jdt.ui", 4, message2, null);
        String title = ActionMessages.CleanUpAction_ErrorDialogTitle;
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    private boolean testOnBuildPath(ICompilationUnit cu, MultiStatus status) {
        IJavaProject project = cu.getJavaProject();
        if (!project.isOnClasspath((IJavaElement)cu)) {
            String cuLocation = cu.getPath().makeRelative().toString();
            String message = Messages.format(ActionMessages.CleanUpAction_CUNotOnBuildpathMessage, cuLocation);
            status.add((IStatus)new Status(1, "org.eclipse.jdt.ui", 4, message, null));
            return false;
        }
        return true;
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block17: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (!elem.exists()) break block17;
                        switch (elem.getElementType()) {
                            case 7: {
                                if (elem.getParent().getElementType() == 5) {
                                    result.add(elem.getParent());
                                    break;
                                }
                                break block17;
                            }
                            case 5: {
                                result.add(elem);
                                break;
                            }
                            case 12: {
                                result.add(elem.getParent());
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)elem, result);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                                int k = 0;
                                while (k < roots.length) {
                                    this.collectCompilationUnits(roots[k], result);
                                    ++k;
                                }
                                break block1;
                            }
                        }
                        break block17;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                        int k = 0;
                        while (k < packageFragments.length) {
                            IPackageFragment pack = packageFragments[k];
                            if (pack.exists()) {
                                this.collectCompilationUnits(pack, result);
                            }
                            ++k;
                        }
                    }
                }
                catch (JavaModelException e) {
                    if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block17;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }
}

