/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.CodeStyleCleanUp;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUp;
import org.eclipse.jdt.internal.ui.fix.StringCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnnecessaryCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.fix.VariableDeclarationCleanUp;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CleanUpRefactoringWizard
extends RefactoringWizard {
    private static final String CLEAN_UP_WIZARD_SETTINGS_SECTION_ID = "CleanUpWizard";
    private final boolean fShowCUPage;
    private final boolean fShowCleanUpPage;

    public CleanUpRefactoringWizard(CleanUpRefactoring refactoring, int flags, boolean showCUPage, boolean showCleanUpPage) {
        super((Refactoring)refactoring, flags);
        this.fShowCUPage = showCUPage;
        this.fShowCleanUpPage = showCleanUpPage;
        this.setDefaultPageTitle(MultiFixMessages.CleanUpRefactoringWizard_PageTitle);
        this.setWindowTitle(MultiFixMessages.CleanUpRefactoringWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_CLEAN_UP);
    }

    protected void addUserInputPages() {
        if (this.fShowCUPage) {
            SelectCUPage selectCUPage = new SelectCUPage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_name);
            if (this.fShowCleanUpPage) {
                selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_message);
            } else {
                ICleanUp[] cleanUps = ((CleanUpRefactoring)this.getRefactoring()).getCleanUps();
                if (cleanUps.length == 1) {
                    ICleanUp cleanUp = cleanUps[0];
                    String[] descriptions = cleanUp.getDescriptions();
                    if (descriptions.length == 1) {
                        selectCUPage.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSingleSelect_message, descriptions[0]));
                    } else {
                        selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSelect_message);
                    }
                } else {
                    selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSelect_message);
                }
            }
            this.addPage((IWizardPage)selectCUPage);
        }
        if (this.fShowCleanUpPage) {
            SelectCleanUpPage selectSolverPage = new SelectCleanUpPage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_name);
            if (this.fShowCUPage) {
                selectSolverPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_message);
            } else {
                ICompilationUnit[] compilationUnits = ((CleanUpRefactoring)this.getRefactoring()).getCompilationUnits();
                if (compilationUnits.length == 1) {
                    String label = JavaElementLabels.getElementLabel((IJavaElement)compilationUnits[0], JavaElementLabels.ALL_DEFAULT);
                    selectSolverPage.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_preSingleSelect_message, label));
                } else {
                    selectSolverPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_message);
                }
            }
            this.addPage((IWizardPage)selectSolverPage);
        }
    }

    private static IDialogSettings getCleanUpWizardSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(CLEAN_UP_WIZARD_SETTINGS_SECTION_ID);
        if (section == null) {
            section = settings.addNewSection(CLEAN_UP_WIZARD_SETTINGS_SECTION_ID);
        }
        return section;
    }

    private static interface ISelectionChangeListener {
        public void selectionChanged(ICleanUp var1, int var2, boolean var3);
    }

    private class SelectCUPage
    extends UserInputWizardPage {
        private ContainerCheckedTreeViewer fTreeViewer;

        public SelectCUPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createViewer(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private TreeViewer createViewer(Composite parent) {
            this.fTreeViewer = new ContainerCheckedTreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            this.fTreeViewer.getTree().setLayoutData((Object)gd);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(256));
            this.fTreeViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider());
            this.fTreeViewer.setSorter((ViewerSorter)new JavaElementSorter());
            this.fTreeViewer.addFilter(new ViewerFilter(this){
                final /* synthetic */ SelectCUPage this$1;
                {
                    this.this$1 = selectCUPage;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IJavaElement) {
                        IJavaElement jElement = (IJavaElement)element;
                        return !jElement.isReadOnly();
                    }
                    return false;
                }
            });
            IJavaModel create = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            this.fTreeViewer.setInput((Object)create);
            this.checkElements((CheckboxTreeViewer)this.fTreeViewer, (CleanUpRefactoring)this.getRefactoring());
            return this.fTreeViewer;
        }

        private void checkElements(CheckboxTreeViewer treeViewer, CleanUpRefactoring refactoring) {
            ICompilationUnit[] compilationUnits = refactoring.getCompilationUnits();
            int i = 0;
            while (i < compilationUnits.length) {
                ICompilationUnit compilationUnit = compilationUnits[i];
                treeViewer.expandToLevel((Object)compilationUnit, 0);
                treeViewer.setChecked((Object)compilationUnit, true);
                ++i;
            }
            if (compilationUnits.length > 0) {
                treeViewer.setSelection((ISelection)new StructuredSelection((Object[])this.smallestCommonParents((IJavaElement[])compilationUnits)), true);
            }
        }

        private IJavaElement[] smallestCommonParents(IJavaElement[] elements) {
            if (elements.length == 1) {
                return elements;
            }
            ArrayList<IJavaElement> parents = new ArrayList<IJavaElement>();
            boolean hasParents = false;
            IJavaElement parent = this.getParent(elements[0]);
            if (parent == null) {
                parent = elements[0];
            } else {
                hasParents = true;
            }
            parents.add(parent);
            int i = 1;
            while (i < elements.length) {
                parent = this.getParent(elements[i]);
                if (this.getParent(elements[i - 1]) != parent) {
                    if (parent == null) {
                        parent = elements[i];
                    } else {
                        hasParents = true;
                    }
                    if (!parents.contains(parent)) {
                        parents.add(parent);
                    }
                }
                ++i;
            }
            IJavaElement[] parentsArray = parents.toArray(new IJavaElement[parents.size()]);
            if (hasParents) {
                return this.smallestCommonParents(parentsArray);
            }
            return parentsArray;
        }

        private IJavaElement getParent(IJavaElement element) {
            if (element instanceof ICompilationUnit) {
                return element.getParent();
            }
            if (element instanceof IPackageFragment) {
                return element.getParent().getParent();
            }
            return element.getParent();
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            refactoring.clearCompilationUnits();
            Object[] checkedElements = this.fTreeViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElements.length) {
                if (checkedElements[i] instanceof ICompilationUnit) {
                    refactoring.addCompilationUnit((ICompilationUnit)checkedElements[i]);
                }
                ++i;
            }
            if (!refactoring.hasCleanUps()) {
                ICleanUp[] cleanUps = this.createAllCleanUps();
                int i2 = 0;
                while (i2 < cleanUps.length) {
                    refactoring.addCleanUp(cleanUps[i2]);
                    ++i2;
                }
            }
        }

        private ICleanUp[] createAllCleanUps() {
            IDialogSettings section = CleanUpRefactoringWizard.getCleanUpWizardSettings();
            ICleanUp[] result = new ICleanUp[]{new CodeStyleCleanUp(section), new ControlStatementsCleanUp(section), new UnusedCodeCleanUp(section), new Java50CleanUp(section), new StringCleanUp(section), new PotentialProgrammingProblemsCleanUp(section), new UnnecessaryCodeCleanUp(section), new ExpressionsCleanUp(section), new VariableDeclarationCleanUp(section)};
            return result;
        }
    }

    private class SelectCleanUpPage
    extends UserInputWizardPage {
        private ICleanUp[] fCleanUps;
        private List fConfigurationGroups = new ArrayList();
        private int fTotalCleanUpsCount;
        private int fSelectedCleanUpsCount;
        private Label fStatusLine;

        public SelectCleanUpPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            TabFolder tabFolder = new TabFolder(composite, 0);
            tabFolder.setLayout((Layout)new TabFolderLayout());
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fStatusLine = new Label(composite, 0);
            this.fStatusLine.setLayoutData((Object)new GridData(4, 1024, false, false));
            this.createGroups(tabFolder);
            this.fStatusLine.setText(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_statusLineText, new Object[]{new Integer(this.fSelectedCleanUpsCount), new Integer(this.fTotalCleanUpsCount)}));
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.select_clean_ups_wizard_page_context");
        }

        private void createGroups(TabFolder parent) {
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            IJavaProject[] projects = refactoring.getProjects();
            IJavaProject project = projects.length == 1 ? projects[0] : null;
            IDialogSettings section = CleanUpRefactoringWizard.getCleanUpWizardSettings();
            this.fCleanUps = new ICleanUp[9];
            Composite codeStyleTab = this.createTab(parent, MultiFixMessages.CleanUpRefactoringWizard_CodeStyleSection_description);
            this.fillCodeStyleTab(codeStyleTab, project, section);
            Composite accessesTab = this.createTab(parent, MultiFixMessages.CleanUpRefactoringWizard_memberAccesses_sectionDescription);
            this.fillMemberAccessesTab(accessesTab, project, section);
            Composite unnecessaryCodeTab = this.createTab(parent, MultiFixMessages.CleanUpRefactoringWizard_UnnecessaryCode_tabLabel);
            this.fillUnnecessaryCodeTab(unnecessaryCodeTab, project, section);
            Composite missingCodeTab = this.createTab(parent, MultiFixMessages.CleanUpRefactoringWizard_MissingCode_tabLabel);
            this.fillMissingCodeTab(missingCodeTab, project, section);
        }

        private Composite fillCodeStyleTab(Composite parent, IJavaProject project, IDialogSettings settings) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite left = new Composite(composite, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            left.setLayout((Layout)gridLayout);
            left.setLayoutData((Object)new GridData(4, 4, false, true));
            Composite groups = new Composite(left, 0);
            groups.setLayout((Layout)new GridLayout(1, false));
            groups.setLayoutData((Object)new GridData(4, 4, false, true));
            ControlStatementsCleanUp controlStatementsCleanUp = new ControlStatementsCleanUp(settings);
            Composite group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_controlStatements_sectionDescription);
            FlagConfigurationButton addBlock = new FlagConfigurationButton(controlStatementsCleanUp, 1, MultiFixMessages.ControlStatementsCleanUp_always_checkBoxLabel, 16);
            FlagConfigurationButton removeBlockReturn = new FlagConfigurationButton(controlStatementsCleanUp, 8, MultiFixMessages.CleanUpRefactoringWizard_NoBlockForReturnOrThrow_checkBoxLabel, 16);
            FlagConfigurationButton removeBlock = new FlagConfigurationButton(controlStatementsCleanUp, 4, MultiFixMessages.ControlStatementsCleanUp_removeIfPossible_checkBoxLabel, 16);
            FlagConfigurationGroup blockGroup = new FlagConfigurationGroup(MultiFixMessages.ControlStatementsCleanUp_useBlocks_checkBoxLabel, new FlagConfigurationButton[]{addBlock, removeBlockReturn, removeBlock}, 528, settings);
            blockGroup.createButton(group);
            FlagConfigurationButton convertLoop = new FlagConfigurationButton(controlStatementsCleanUp, 2, MultiFixMessages.ControlStatementsCleanUp_convertLoops_checkBoxLabel, 32);
            convertLoop.createButton(group);
            ExpressionsCleanUp expressionsCleanUp = new ExpressionsCleanUp(settings);
            group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_expressions_sectionDescription);
            FlagConfigurationButton addParanoic = new FlagConfigurationButton(expressionsCleanUp, 1, MultiFixMessages.ExpressionsCleanUp_addParanoiac_checkBoxLabel, 16);
            FlagConfigurationButton removeParanoic = new FlagConfigurationButton(expressionsCleanUp, 2, MultiFixMessages.ExpressionsCleanUp_removeUnnecessary_checkBoxLabel, 16);
            FlagConfigurationGroup parenthesisGroup = new FlagConfigurationGroup(MultiFixMessages.ExpressionsCleanUp_parenthesisAroundConditions_checkBoxLabel, new FlagConfigurationButton[]{addParanoic, removeParanoic}, 272, settings);
            parenthesisGroup.createButton(group);
            VariableDeclarationCleanUp varDeclCleanUp = new VariableDeclarationCleanUp(settings);
            group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_variableDeclaration_groupDescription);
            FlagConfigurationButton addFinalField = new FlagConfigurationButton(varDeclCleanUp, 1, MultiFixMessages.CleanUpRefactoringWizard_addFinalFields_checkBoxLabel, 32);
            FlagConfigurationButton addFinalParam = new FlagConfigurationButton(varDeclCleanUp, 2, MultiFixMessages.CleanUpRefactoringWizard_addFinalParameters_checkBoxLabel, 32);
            FlagConfigurationButton addFinalLocal = new FlagConfigurationButton(varDeclCleanUp, 4, MultiFixMessages.CleanUpRefactoringWizard_addFinalLocals_checkBoxLabel, 32);
            FlagConfigurationGroup addFinalGroup = new FlagConfigurationGroup(MultiFixMessages.CleanUpRefactoringWizard_changeToFinal_checkBoxLabel, new FlagConfigurationButton[]{addFinalField, addFinalParam, addFinalLocal}, 288, settings);
            addFinalGroup.createButton(group);
            FlagConfigurationButton[] flagConfigurationButtons = new FlagConfigurationButton[]{addBlock, removeBlock, removeBlockReturn, convertLoop, addParanoic, removeParanoic, addFinalField, addFinalParam, addFinalLocal};
            FlagConfigurationGroup[] radioButtonGroups = new FlagConfigurationGroup[]{blockGroup, parenthesisGroup};
            FlagConfigurationGroup[] checkBoxGroup = new FlagConfigurationGroup[]{addFinalGroup};
            CleanUpPreview preview = this.addPreview(composite, new ICleanUp[]{controlStatementsCleanUp, expressionsCleanUp, varDeclCleanUp}, flagConfigurationButtons);
            if (project != null && !JavaModelUtil.is50OrHigher(project)) {
                convertLoop.disable();
                convertLoop.deselect();
                this.addEnableButtonsGroup(left, flagConfigurationButtons, radioButtonGroups, checkBoxGroup, new FlagConfigurationButton[]{convertLoop}, preview);
            } else {
                this.addEnableButtonsGroup(left, flagConfigurationButtons, radioButtonGroups, checkBoxGroup, new FlagConfigurationButton[0], preview);
            }
            this.addSelectionCounter(flagConfigurationButtons);
            this.fCleanUps[1] = controlStatementsCleanUp;
            this.fCleanUps[3] = expressionsCleanUp;
            this.fCleanUps[2] = varDeclCleanUp;
            this.fConfigurationGroups.add(blockGroup);
            this.fConfigurationGroups.add(parenthesisGroup);
            this.fConfigurationGroups.add(addFinalGroup);
            return composite;
        }

        private Composite fillMemberAccessesTab(Composite parent, IJavaProject project, IDialogSettings settings) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite left = new Composite(composite, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            left.setLayout((Layout)gridLayout);
            left.setLayoutData((Object)new GridData(4, 4, false, true));
            Composite groups = new Composite(left, 0);
            groups.setLayout((Layout)new GridLayout(1, false));
            groups.setLayoutData((Object)new GridData(4, 4, false, true));
            CodeStyleCleanUp codeStyleCleanUp = new CodeStyleCleanUp(settings);
            Composite group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_NonStaticAccesses_groupDescription);
            FlagConfigurationButton addThisField = new FlagConfigurationButton(codeStyleCleanUp, 1, MultiFixMessages.CleanUpRefactoringWizard_qualifyNonStaticField_checkBoxLabel, 16);
            FlagConfigurationButton removeThisField = new FlagConfigurationButton(codeStyleCleanUp, 64, MultiFixMessages.CleanUpRefactoringWizard_removeThis_checkBoxLabel, 16);
            FlagConfigurationGroup addThisGroup = new FlagConfigurationGroup(MultiFixMessages.CodeStyleCleanUp_useThis_checkBoxLabel, new FlagConfigurationButton[]{addThisField, removeThisField}, 272, settings);
            addThisGroup.createButton(group);
            FlagConfigurationButton addThisMethod = new FlagConfigurationButton(codeStyleCleanUp, 16, MultiFixMessages.CleanUpRefactoringWizard_qualifyNonStaticMethod_checkBoxLabel, 16);
            FlagConfigurationButton removeThisMethod = new FlagConfigurationButton(codeStyleCleanUp, 128, MultiFixMessages.CleanUpRefactoringWizard_removeMethodThis_checkBoxLabel, 16);
            FlagConfigurationGroup addThisMethodGroup = new FlagConfigurationGroup(MultiFixMessages.CleanUpRefactoringWizard_addMethodThis_checkBoxLabel, new FlagConfigurationButton[]{addThisMethod, removeThisMethod}, 272, settings);
            addThisMethodGroup.createButton(group);
            group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_StaticAccesses_groupDescription);
            FlagConfigurationButton nonStatic = new FlagConfigurationButton(codeStyleCleanUp, 2, MultiFixMessages.CodeStyleCleanUp_changeNonStatic_checkBoxLabel, 32);
            FlagConfigurationButton indirect = new FlagConfigurationButton(codeStyleCleanUp, 8, MultiFixMessages.CodeStyleCleanUp_changeIndirect_checkBoxLabel, 32);
            FlagConfigurationButton qualifyStatic = new FlagConfigurationButton(codeStyleCleanUp, 4, MultiFixMessages.CodeStyleCleanUp_addStaticQualifier_checkBoxLabel, 32);
            FlagConfigurationButton qualifyStaticMethod = new FlagConfigurationButton(codeStyleCleanUp, 32, MultiFixMessages.CleanUpRefactoringWizard_qualifyStaticMethod_checkBoxLabel, 32);
            FlagConfigurationGroup staticGroup = new FlagConfigurationGroup(MultiFixMessages.CodeStyleCleanUp_useDeclaring_checkBoxLabel, new FlagConfigurationButton[]{qualifyStatic, qualifyStaticMethod, indirect, nonStatic}, 544, settings);
            staticGroup.createButton(group);
            FlagConfigurationButton[] flagConfigurationButtons = new FlagConfigurationButton[]{addThisField, removeThisField, addThisMethod, removeThisMethod, nonStatic, indirect, qualifyStatic, qualifyStaticMethod};
            FlagConfigurationGroup[] radioButtonGroups = new FlagConfigurationGroup[]{addThisGroup, addThisMethodGroup};
            CleanUpPreview preview = this.addPreview(composite, new ICleanUp[]{codeStyleCleanUp}, flagConfigurationButtons);
            this.addEnableButtonsGroup(left, flagConfigurationButtons, radioButtonGroups, new FlagConfigurationGroup[]{staticGroup}, new FlagConfigurationButton[0], preview);
            this.addSelectionCounter(flagConfigurationButtons);
            this.fCleanUps[0] = codeStyleCleanUp;
            this.fConfigurationGroups.add(addThisGroup);
            this.fConfigurationGroups.add(addThisMethodGroup);
            this.fConfigurationGroups.add(staticGroup);
            return composite;
        }

        private Composite fillUnnecessaryCodeTab(Composite parent, IJavaProject project, IDialogSettings section) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite left = new Composite(composite, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            left.setLayout((Layout)gridLayout);
            left.setLayoutData((Object)new GridData(4, 4, false, true));
            Composite groups = new Composite(left, 0);
            groups.setLayout((Layout)new GridLayout(1, false));
            groups.setLayoutData((Object)new GridData(4, 4, false, true));
            UnusedCodeCleanUp unusedCodeCleanUp = new UnusedCodeCleanUp(section);
            Composite group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_UnusedCodeSection_description);
            FlagConfigurationButton imports = new FlagConfigurationButton(unusedCodeCleanUp, 1, MultiFixMessages.UnusedCodeCleanUp_unusedImports_checkBoxLabel, 32);
            imports.createButton(group);
            FlagConfigurationButton types = new FlagConfigurationButton(unusedCodeCleanUp, 16, MultiFixMessages.UnusedCodeCleanUp_unusedTypes_checkBoxLabel, 32);
            FlagConfigurationButton contructors = new FlagConfigurationButton(unusedCodeCleanUp, 2, MultiFixMessages.UnusedCodeCleanUp_unusedConstructors_checkBoxLabel, 32);
            FlagConfigurationButton methods = new FlagConfigurationButton(unusedCodeCleanUp, 4, MultiFixMessages.UnusedCodeCleanUp_unusedMethods_checkBoxLabel, 32);
            FlagConfigurationButton fields = new FlagConfigurationButton(unusedCodeCleanUp, 8, MultiFixMessages.UnusedCodeCleanUp_unusedFields_checkBoxLabel, 32);
            FlagConfigurationGroup membersGroup = new FlagConfigurationGroup(MultiFixMessages.UnusedCodeCleanUp_unusedPrivateMembers_checkBoxLabel, new FlagConfigurationButton[]{types, contructors, fields, methods}, 288, section);
            membersGroup.createButton(group);
            FlagConfigurationButton locals = new FlagConfigurationButton(unusedCodeCleanUp, 32, MultiFixMessages.UnusedCodeCleanUp_unusedLocalVariables_checkBoxLabel, 32);
            locals.createButton(group);
            UnnecessaryCodeCleanUp unnecessaryCodeCleanUp = new UnnecessaryCodeCleanUp(section);
            StringCleanUp stringCleanUp = new StringCleanUp(section);
            group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_UnnecessaryCode_section);
            FlagConfigurationButton casts = new FlagConfigurationButton(unnecessaryCodeCleanUp, 1, MultiFixMessages.UnusedCodeCleanUp_unnecessaryCasts_checkBoxLabel, 32);
            casts.createButton(group);
            FlagConfigurationButton nlsTags = new FlagConfigurationButton(stringCleanUp, 2, MultiFixMessages.StringCleanUp_RemoveNLSTag_label, 32);
            nlsTags.createButton(group);
            FlagConfigurationButton[] flagConfigurationButtons = new FlagConfigurationButton[]{imports, types, contructors, methods, locals, fields, casts, nlsTags};
            CleanUpPreview preview = this.addPreview(composite, new ICleanUp[]{unusedCodeCleanUp, unnecessaryCodeCleanUp, stringCleanUp}, flagConfigurationButtons);
            this.addEnableButtonsGroup(left, flagConfigurationButtons, new FlagConfigurationGroup[0], new FlagConfigurationGroup[]{membersGroup}, new FlagConfigurationButton[0], preview);
            this.addSelectionCounter(flagConfigurationButtons);
            this.fCleanUps[4] = unusedCodeCleanUp;
            this.fCleanUps[7] = unnecessaryCodeCleanUp;
            this.fCleanUps[8] = stringCleanUp;
            this.fConfigurationGroups.add(membersGroup);
            return composite;
        }

        private Composite fillMissingCodeTab(Composite parent, IJavaProject project, IDialogSettings section) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite left = new Composite(composite, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            left.setLayout((Layout)gridLayout);
            left.setLayoutData((Object)new GridData(4, 4, false, true));
            Composite groups = new Composite(left, 0);
            groups.setLayout((Layout)new GridLayout(1, false));
            groups.setLayoutData((Object)new GridData(4, 4, false, true));
            Java50CleanUp java50CleanUp = new Java50CleanUp(section);
            Composite group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_Annotations_sectionName);
            FlagConfigurationButton override = new FlagConfigurationButton(java50CleanUp, 2, MultiFixMessages.Java50CleanUp_override_checkBoxLabel, 32);
            FlagConfigurationButton deprecated = new FlagConfigurationButton(java50CleanUp, 1, MultiFixMessages.Java50CleanUp_deprecated_checkBoxLabel, 32);
            FlagConfigurationGroup annotations = new FlagConfigurationGroup(MultiFixMessages.Java50CleanUp_addMissingAnnotations_checkBoxLabel, new FlagConfigurationButton[]{override, deprecated}, 544, section);
            annotations.createButton(group);
            PotentialProgrammingProblemsCleanUp potentialProgrammingProblemsCleanUp = new PotentialProgrammingProblemsCleanUp(section);
            group = this.createGroup(groups, MultiFixMessages.CleanUpRefactoringWizard_PotentialProgrammingProblems_description);
            FlagConfigurationButton hash = new FlagConfigurationButton(potentialProgrammingProblemsCleanUp, 1, MultiFixMessages.PotentialProgrammingProblemsCleanUp_Generated_radioButton_name, 16);
            FlagConfigurationButton defaultId = new FlagConfigurationButton(potentialProgrammingProblemsCleanUp, 2, MultiFixMessages.PotentialProgrammingProblemsCleanUp_Default_radioButton_name, 16);
            FlagConfigurationGroup serial = new FlagConfigurationGroup(MultiFixMessages.PotentialProgrammingProblemsCleanUp_AddSerialId_section_name, new FlagConfigurationButton[]{hash, defaultId}, 272, section);
            serial.createButton(group);
            FlagConfigurationButton[] flagConfigurationButtons = new FlagConfigurationButton[]{override, deprecated, hash, defaultId};
            CleanUpPreview preview = this.addPreview(composite, new ICleanUp[]{java50CleanUp, potentialProgrammingProblemsCleanUp}, flagConfigurationButtons);
            if (project != null && !JavaModelUtil.is50OrHigher(project)) {
                override.deselect();
                override.disableFlag();
                deprecated.deselect();
                deprecated.disableFlag();
                annotations.disable();
                this.addEnableButtonsGroup(left, flagConfigurationButtons, new FlagConfigurationGroup[]{serial}, new FlagConfigurationGroup[]{annotations}, new FlagConfigurationButton[]{override, deprecated}, preview);
            } else {
                this.addEnableButtonsGroup(left, flagConfigurationButtons, new FlagConfigurationGroup[]{serial}, new FlagConfigurationGroup[]{annotations}, new FlagConfigurationButton[0], preview);
            }
            this.addSelectionCounter(flagConfigurationButtons);
            this.fCleanUps[5] = java50CleanUp;
            this.fCleanUps[6] = potentialProgrammingProblemsCleanUp;
            this.fConfigurationGroups.add(annotations);
            this.fConfigurationGroups.add(serial);
            return composite;
        }

        private CleanUpPreview addPreview(Composite parent, ICleanUp[] cleanUps, FlagConfigurationButton[] flagConfigurationButtons) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(16384, 128, false, false));
            label.setText(MultiFixMessages.CleanUpRefactoringWizard_previewLabel_text);
            IJavaProject javaProject = ((CleanUpRefactoring)this.getRefactoring()).getProjects()[0];
            CleanUpPreview preview = new CleanUpPreview(composite, javaProject.getOptions(true), cleanUps);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 0;
            gd.heightHint = 0;
            preview.getControl().setLayoutData((Object)gd);
            preview.update();
            int i = 0;
            while (i < flagConfigurationButtons.length) {
                flagConfigurationButtons[i].addSelectionChangeListener(new ISelectionChangeListener(this, preview){
                    final /* synthetic */ SelectCleanUpPage this$1;
                    private final /* synthetic */ CleanUpPreview val$preview;
                    {
                        this.this$1 = selectCleanUpPage;
                        this.val$preview = cleanUpPreview;
                    }

                    public void selectionChanged(ICleanUp cleanUp, int flag, boolean selection) {
                        if (!this.val$preview.isUpdateSuspended()) {
                            this.val$preview.update();
                        }
                    }
                });
                ++i;
            }
            return preview;
        }

        private void addSelectionCounter(FlagConfigurationButton[] configs) {
            int i = 0;
            while (i < configs.length) {
                FlagConfigurationButton config = configs[i];
                if (config.getCleanUp().isFlag(config.getFlag())) {
                    ++this.fSelectedCleanUpsCount;
                }
                config.addSelectionChangeListener(new ISelectionChangeListener(this){
                    final /* synthetic */ SelectCleanUpPage this$1;
                    {
                        this.this$1 = selectCleanUpPage;
                    }

                    public void selectionChanged(ICleanUp cleanUp, int flag, boolean selection) {
                        if (selection) {
                            SelectCleanUpPage selectCleanUpPage = this.this$1;
                            SelectCleanUpPage.access$1(selectCleanUpPage, SelectCleanUpPage.access$0(selectCleanUpPage) + 1);
                        } else {
                            SelectCleanUpPage selectCleanUpPage = this.this$1;
                            SelectCleanUpPage.access$1(selectCleanUpPage, SelectCleanUpPage.access$0(selectCleanUpPage) - 1);
                        }
                        SelectCleanUpPage.access$2(this.this$1).setText(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_statusLineText, new Object[]{new Integer(SelectCleanUpPage.access$0(this.this$1)), new Integer(SelectCleanUpPage.access$3(this.this$1))}));
                    }
                });
                ++i;
            }
            this.fTotalCleanUpsCount += configs.length;
        }

        private void addEnableButtonsGroup(Composite parent, FlagConfigurationButton[] configButtons, FlagConfigurationGroup[] radioGroups, FlagConfigurationGroup[] checkBoxGroups, FlagConfigurationButton[] disabledButtons, CleanUpPreview preview) {
            Composite down = new Composite(parent, 0);
            down.setLayout((Layout)new GridLayout(2, false));
            down.setLayoutData((Object)new GridData(4, 4, true, false));
            Composite space = new Composite(down, 0);
            space.setLayout((Layout)new GridLayout(1, true));
            space.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite buttons = new Composite(down, 0);
            buttons.setLayout((Layout)new GridLayout(3, true));
            buttons.setLayoutData((Object)new GridData(4, 4, false, true));
            Button all = new Button(buttons, 8);
            all.setLayoutData((Object)new GridData(4, 4, true, true));
            all.setText(MultiFixMessages.CleanUpRefactoringWizard_EnableAllButton_label);
            all.addSelectionListener((SelectionListener)new SelectionAdapter(this, preview, configButtons, disabledButtons, checkBoxGroups, radioGroups){
                final /* synthetic */ SelectCleanUpPage this$1;
                private final /* synthetic */ CleanUpPreview val$preview;
                private final /* synthetic */ FlagConfigurationButton[] val$configButtons;
                private final /* synthetic */ FlagConfigurationButton[] val$disabledButtons;
                private final /* synthetic */ FlagConfigurationGroup[] val$checkBoxGroups;
                private final /* synthetic */ FlagConfigurationGroup[] val$radioGroups;
                {
                    this.this$1 = selectCleanUpPage;
                    this.val$preview = cleanUpPreview;
                    this.val$configButtons = flagConfigurationButtonArray;
                    this.val$disabledButtons = flagConfigurationButtonArray2;
                    this.val$checkBoxGroups = flagConfigurationGroupArray;
                    this.val$radioGroups = flagConfigurationGroupArray2;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$preview.blockUpdate();
                    int i = 0;
                    while (i < this.val$configButtons.length) {
                        FlagConfigurationButton config = this.val$configButtons[i];
                        boolean isDisabled = false;
                        int j = 0;
                        while (j < this.val$disabledButtons.length) {
                            if (config == this.val$disabledButtons[j]) {
                                isDisabled = true;
                            }
                            ++j;
                        }
                        if (!isDisabled) {
                            if (config.isRadio()) {
                                if (config.isSelected()) {
                                    config.enableFlag();
                                }
                            } else {
                                config.enableFlag();
                                config.select();
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$checkBoxGroups.length) {
                        if (!this.val$checkBoxGroups[i].isDisabled()) {
                            FlagConfigurationGroup.access$3(this.val$checkBoxGroups[i]);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$radioGroups.length) {
                        if (!this.val$radioGroups[i].isDisabled()) {
                            FlagConfigurationGroup.access$3(this.val$radioGroups[i]);
                        }
                        ++i;
                    }
                    this.val$preview.resumeUpdate();
                    this.val$preview.update();
                }
            });
            Button none = new Button(buttons, 8);
            none.setLayoutData((Object)new GridData(4, 4, true, true));
            none.setText(MultiFixMessages.CleanUpRefactoringWizard_DisableAllButton_label);
            none.addSelectionListener((SelectionListener)new SelectionAdapter(this, preview, configButtons, radioGroups, checkBoxGroups){
                final /* synthetic */ SelectCleanUpPage this$1;
                private final /* synthetic */ CleanUpPreview val$preview;
                private final /* synthetic */ FlagConfigurationButton[] val$configButtons;
                private final /* synthetic */ FlagConfigurationGroup[] val$radioGroups;
                private final /* synthetic */ FlagConfigurationGroup[] val$checkBoxGroups;
                {
                    this.this$1 = selectCleanUpPage;
                    this.val$preview = cleanUpPreview;
                    this.val$configButtons = flagConfigurationButtonArray;
                    this.val$radioGroups = flagConfigurationGroupArray;
                    this.val$checkBoxGroups = flagConfigurationGroupArray2;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$preview.blockUpdate();
                    int i = 0;
                    while (i < this.val$configButtons.length) {
                        FlagConfigurationButton config = this.val$configButtons[i];
                        config.disableFlag();
                        if (!config.isRadio()) {
                            config.deselect();
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$radioGroups.length) {
                        FlagConfigurationGroup group = this.val$radioGroups[i];
                        FlagConfigurationGroup.access$1(group);
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$checkBoxGroups.length) {
                        FlagConfigurationGroup.access$1(this.val$checkBoxGroups[i]);
                        ++i;
                    }
                    this.val$preview.resumeUpdate();
                    this.val$preview.update();
                }
            });
            Button def = new Button(buttons, 8);
            def.setLayoutData((Object)new GridData(4, 4, true, true));
            def.setText(MultiFixMessages.CleanUpRefactoringWizard_EnableDefaultsButton_label);
            def.addSelectionListener((SelectionListener)new SelectionAdapter(this, preview, configButtons, disabledButtons, radioGroups, checkBoxGroups){
                final /* synthetic */ SelectCleanUpPage this$1;
                private final /* synthetic */ CleanUpPreview val$preview;
                private final /* synthetic */ FlagConfigurationButton[] val$configButtons;
                private final /* synthetic */ FlagConfigurationButton[] val$disabledButtons;
                private final /* synthetic */ FlagConfigurationGroup[] val$radioGroups;
                private final /* synthetic */ FlagConfigurationGroup[] val$checkBoxGroups;
                {
                    this.this$1 = selectCleanUpPage;
                    this.val$preview = cleanUpPreview;
                    this.val$configButtons = flagConfigurationButtonArray;
                    this.val$disabledButtons = flagConfigurationButtonArray2;
                    this.val$radioGroups = flagConfigurationGroupArray;
                    this.val$checkBoxGroups = flagConfigurationGroupArray2;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.val$preview.blockUpdate();
                    int i = 0;
                    while (i < this.val$configButtons.length) {
                        FlagConfigurationButton config = this.val$configButtons[i];
                        if (!config.isRadio()) {
                            boolean isDisabled = false;
                            int j = 0;
                            while (j < this.val$disabledButtons.length) {
                                if (config == this.val$disabledButtons[j]) {
                                    isDisabled = true;
                                }
                                ++j;
                            }
                            if (!isDisabled) {
                                config.enableDefault();
                                config.selectDefault();
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$radioGroups.length) {
                        FlagConfigurationGroup group = this.val$radioGroups[i];
                        group.enableDefaults();
                        ++i;
                    }
                    i = 0;
                    while (i < this.val$checkBoxGroups.length) {
                        this.val$checkBoxGroups[i].enableDefaults();
                        ++i;
                    }
                    this.val$preview.resumeUpdate();
                    this.val$preview.update();
                }
            });
        }

        private Composite createTab(TabFolder parent, String label) {
            TabItem csTab = new TabItem(parent, 0);
            csTab.setText(label);
            Composite result = new Composite((Composite)parent, 0);
            result.setLayoutData((Object)new GridData(4, 4, true, true));
            result.setLayout((Layout)new GridLayout(1, false));
            csTab.setControl((Control)result);
            return result;
        }

        private Composite createGroup(Composite parent, String description) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 128, true, false));
            group.setLayout((Layout)new GridLayout(1, true));
            group.setText(description);
            return group;
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
            if (this.fCleanUps != null) {
                IDialogSettings settings = CleanUpRefactoringWizard.getCleanUpWizardSettings();
                int i = 0;
                while (i < this.fCleanUps.length) {
                    this.fCleanUps[i].saveSettings(settings);
                    ++i;
                }
                Iterator iter = this.fConfigurationGroups.iterator();
                while (iter.hasNext()) {
                    FlagConfigurationGroup group = (FlagConfigurationGroup)iter.next();
                    group.saveSettings(settings);
                }
            }
        }

        private void initializeRefactoring() {
            if (this.fCleanUps != null) {
                CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
                refactoring.clearCleanUps();
                int i = 0;
                while (i < this.fCleanUps.length) {
                    refactoring.addCleanUp(this.fCleanUps[i]);
                    ++i;
                }
            }
        }

        static /* synthetic */ int access$0(SelectCleanUpPage selectCleanUpPage) {
            return selectCleanUpPage.fSelectedCleanUpsCount;
        }

        static /* synthetic */ void access$1(SelectCleanUpPage selectCleanUpPage, int n) {
            selectCleanUpPage.fSelectedCleanUpsCount = n;
        }

        static /* synthetic */ Label access$2(SelectCleanUpPage selectCleanUpPage) {
            return selectCleanUpPage.fStatusLine;
        }

        static /* synthetic */ int access$3(SelectCleanUpPage selectCleanUpPage) {
            return selectCleanUpPage.fTotalCleanUpsCount;
        }

        private class TabFolderLayout
        extends Layout {
            private TabFolderLayout() {
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(600, 340);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle rect = composite.getClientArea();
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    children[i].setBounds(rect);
                    ++i;
                }
            }
        }

        private class FlagConfigurationButton {
            private final int fFlag;
            private final ICleanUp fCleanUp;
            private final String fLabel;
            private final int fStyle;
            private Button fButton;
            private final List fSelectionChangeListeners;

            public FlagConfigurationButton(ICleanUp cleanUp, int flag, String label, int style) {
                this.fCleanUp = cleanUp;
                this.fFlag = flag;
                this.fLabel = label;
                this.fStyle = style;
                this.fSelectionChangeListeners = new ArrayList();
            }

            public void createButton(Composite parent) {
                this.fButton = new Button(parent, this.fStyle);
                this.fButton.setText(this.fLabel);
                this.fButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.fButton.setSelection(this.fCleanUp.isFlag(this.fFlag));
                this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ FlagConfigurationButton this$2;
                    {
                        this.this$2 = flagConfigurationButton;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean selection = ((Button)e.getSource()).getSelection();
                        FlagConfigurationButton.access$0(this.this$2).setFlag(FlagConfigurationButton.access$1(this.this$2), selection);
                        Iterator<E> iter = FlagConfigurationButton.access$2(this.this$2).iterator();
                        while (iter.hasNext()) {
                            ISelectionChangeListener listener = (ISelectionChangeListener)iter.next();
                            listener.selectionChanged(FlagConfigurationButton.access$0(this.this$2), FlagConfigurationButton.access$1(this.this$2), selection);
                        }
                    }
                });
            }

            public Button getButton() {
                return this.fButton;
            }

            public void addSelectionChangeListener(ISelectionChangeListener listener) {
                this.fSelectionChangeListeners.add(listener);
            }

            public void select() {
                this.fButton.setSelection(true);
            }

            public void deselect() {
                this.fButton.setSelection(false);
            }

            public boolean isSelected() {
                return this.fButton.getSelection();
            }

            public void disable() {
                this.fButton.setEnabled(false);
            }

            public void enable() {
                this.fButton.setEnabled(true);
            }

            public int getFlag() {
                return this.fFlag;
            }

            public ICleanUp getCleanUp() {
                return this.fCleanUp;
            }

            public void enableFlag() {
                if (!this.fCleanUp.isFlag(this.fFlag)) {
                    this.internalSetFlag(true);
                }
            }

            public void disableFlag() {
                if (this.fCleanUp.isFlag(this.fFlag)) {
                    this.internalSetFlag(false);
                }
            }

            public void enableDefault() {
                int defaultFlag = this.fCleanUp.getDefaultFlag();
                if ((defaultFlag & this.fFlag) != 0) {
                    this.enableFlag();
                } else {
                    this.disableFlag();
                }
            }

            public void selectDefault() {
                int defaultFlag = this.fCleanUp.getDefaultFlag();
                if ((defaultFlag & this.fFlag) != 0) {
                    this.select();
                } else {
                    this.deselect();
                }
            }

            private void internalSetFlag(boolean b) {
                this.fCleanUp.setFlag(this.fFlag, b);
                Iterator iter = this.fSelectionChangeListeners.iterator();
                while (iter.hasNext()) {
                    ISelectionChangeListener listener = (ISelectionChangeListener)iter.next();
                    listener.selectionChanged(this.fCleanUp, this.fFlag, b);
                }
            }

            public boolean isRadio() {
                return (this.fStyle & 0x10) != 0;
            }

            static /* synthetic */ ICleanUp access$0(FlagConfigurationButton flagConfigurationButton) {
                return flagConfigurationButton.fCleanUp;
            }

            static /* synthetic */ int access$1(FlagConfigurationButton flagConfigurationButton) {
                return flagConfigurationButton.fFlag;
            }

            static /* synthetic */ List access$2(FlagConfigurationButton flagConfigurationButton) {
                return flagConfigurationButton.fSelectionChangeListeners;
            }
        }

        private class FlagConfigurationGroup {
            private final String fLabel;
            private final FlagConfigurationButton[] fButtons;
            private final int fStyle;
            private int fUIFlags;
            private Button fControlButton;

            public FlagConfigurationGroup(String label, FlagConfigurationButton[] buttons, int style, IDialogSettings settings) {
                this.fLabel = label;
                this.fButtons = buttons;
                this.fStyle = style;
                this.fUIFlags = this.loadSettings(settings);
            }

            public void enableDefaults() {
                if (this.isDisabled()) {
                    return;
                }
                boolean hasDefaultSelection = false;
                int i = 0;
                while (i < this.fButtons.length) {
                    if ((this.fButtons[i].getCleanUp().getDefaultFlag() & this.fButtons[i].getFlag()) != 0) {
                        hasDefaultSelection = true;
                    }
                    ++i;
                }
                if (hasDefaultSelection) {
                    this.select();
                    i = 0;
                    while (i < this.fButtons.length) {
                        this.fButtons[i].enableDefault();
                        this.fButtons[i].selectDefault();
                        ++i;
                    }
                } else {
                    this.deselect();
                    i = 0;
                    while (i < this.fButtons.length) {
                        this.fButtons[i].disableFlag();
                        ++i;
                    }
                }
            }

            public void disable() {
                this.fControlButton.setEnabled(false);
                int i = 0;
                while (i < this.fButtons.length) {
                    this.fButtons[i].disable();
                    ++i;
                }
            }

            public boolean isDisabled() {
                return !this.fControlButton.isEnabled();
            }

            public void createButton(Composite parent) {
                boolean isVertical = (this.fStyle & 0x200) != 0;
                this.fControlButton = new Button(parent, 32);
                this.fControlButton.setText(this.fLabel);
                this.fControlButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                Composite sub = new Composite(parent, 0);
                sub.setLayoutData((Object)new GridData(4, 128, true, false));
                GridLayout layout = new GridLayout(isVertical ? 1 : this.fButtons.length, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                sub.setLayout((Layout)layout);
                int i = 0;
                while (i < this.fButtons.length) {
                    FlagConfigurationButton config = this.fButtons[i];
                    config.createButton(sub);
                    Button button = config.getButton();
                    if (i == 0 || isVertical) {
                        GridData data = (GridData)button.getLayoutData();
                        data.horizontalIndent = 20;
                    }
                    config.addSelectionChangeListener(new ISelectionChangeListener(this){
                        final /* synthetic */ FlagConfigurationGroup this$2;
                        {
                            this.this$2 = flagConfigurationGroup;
                        }

                        public void selectionChanged(ICleanUp cleanUp, int flag, boolean selection) {
                            FlagConfigurationGroup.access$0(this.this$2, flag, selection);
                        }
                    });
                    ++i;
                }
                if (this.hasSelectedButtons()) {
                    this.select();
                    this.initUIFlags();
                } else {
                    this.deselect();
                    this.restoreFromUIFlags();
                }
                this.fControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ FlagConfigurationGroup this$2;
                    {
                        this.this$2 = flagConfigurationGroup;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (!((Button)e.getSource()).getSelection()) {
                            FlagConfigurationGroup.access$1(this.this$2);
                            int i = 0;
                            while (i < FlagConfigurationGroup.access$2(this.this$2).length) {
                                FlagConfigurationGroup.access$2(this.this$2)[i].disableFlag();
                                ++i;
                            }
                            i = 0;
                            while (i < FlagConfigurationGroup.access$2(this.this$2).length) {
                                if (FlagConfigurationGroup.access$2(this.this$2)[i].isSelected()) {
                                    FlagConfigurationGroup.access$0(this.this$2, FlagConfigurationGroup.access$2(this.this$2)[i].getFlag(), true);
                                }
                                ++i;
                            }
                        } else {
                            FlagConfigurationGroup.access$3(this.this$2);
                            int i = 0;
                            while (i < FlagConfigurationGroup.access$2(this.this$2).length) {
                                if (FlagConfigurationGroup.access$2(this.this$2)[i].isSelected()) {
                                    FlagConfigurationGroup.access$2(this.this$2)[i].enableFlag();
                                }
                                ++i;
                            }
                        }
                    }
                });
            }

            private void restoreFromUIFlags() {
                boolean hasCheck = false;
                int i = 0;
                while (i < this.fButtons.length) {
                    boolean flag = this.isFlag(this.fButtons[i].getFlag());
                    if (flag) {
                        if ((this.fStyle & 0x20) != 0) {
                            this.fButtons[i].select();
                        } else if (!hasCheck) {
                            this.fButtons[i].select();
                        }
                        hasCheck = true;
                    } else {
                        this.fButtons[i].deselect();
                    }
                    ++i;
                }
                if ((this.fStyle & 0x10) != 0 && !hasCheck) {
                    this.fButtons[0].select();
                }
            }

            private void initUIFlags() {
                int i = 0;
                while (i < this.fButtons.length) {
                    this.setFlag(this.fButtons[i].getFlag(), this.fButtons[i].isSelected());
                    ++i;
                }
            }

            private void deselect() {
                this.fControlButton.setSelection(false);
                int j = 0;
                while (j < this.fButtons.length) {
                    this.fButtons[j].disable();
                    ++j;
                }
            }

            private void select() {
                this.fControlButton.setSelection(true);
                int j = 0;
                while (j < this.fButtons.length) {
                    this.fButtons[j].enable();
                    ++j;
                }
            }

            private boolean hasSelectedButtons() {
                int j = 0;
                while (j < this.fButtons.length) {
                    if (this.fButtons[j].getCleanUp().isFlag(this.fButtons[j].getFlag())) {
                        return true;
                    }
                    ++j;
                }
                return false;
            }

            private void setFlag(int flag, boolean b) {
                if (!this.isFlag(flag) && b) {
                    this.fUIFlags |= flag;
                } else if (this.isFlag(flag) && !b) {
                    this.fUIFlags &= ~flag;
                }
            }

            private boolean isFlag(int flag) {
                return (this.fUIFlags & flag) != 0;
            }

            public void saveSettings(IDialogSettings settings) {
                String sectionName = this.getSectionName();
                IDialogSettings section = settings.getSection(sectionName);
                if (section == null) {
                    section = settings.addNewSection(sectionName);
                }
                section.put("uiFlags", this.fUIFlags);
            }

            private int loadSettings(IDialogSettings settings) {
                String sectionName = this.getSectionName();
                IDialogSettings section = settings.getSection(sectionName);
                if (section == null) {
                    return 0;
                }
                return section.getInt("uiFlags");
            }

            private String getSectionName() {
                StringBuffer buf = new StringBuffer(this.fLabel);
                int i = buf.length() - 1;
                while (i >= 0) {
                    if (buf.charAt(i) == '&' || buf.charAt(i) == ' ') {
                        buf.deleteCharAt(i);
                    }
                    --i;
                }
                return buf.toString();
            }

            static /* synthetic */ void access$0(FlagConfigurationGroup flagConfigurationGroup, int n, boolean bl) {
                flagConfigurationGroup.setFlag(n, bl);
            }

            static /* synthetic */ void access$1(FlagConfigurationGroup flagConfigurationGroup) {
                flagConfigurationGroup.deselect();
            }

            static /* synthetic */ FlagConfigurationButton[] access$2(FlagConfigurationGroup flagConfigurationGroup) {
                return flagConfigurationGroup.fButtons;
            }

            static /* synthetic */ void access$3(FlagConfigurationGroup flagConfigurationGroup) {
                flagConfigurationGroup.select();
            }
        }

        private class CleanUpPreview
        extends JavaPreview {
            private final ICleanUp[] fPreviewCleanUps;
            private boolean fUpdateBlocked;

            public CleanUpPreview(Composite parent, Map map, ICleanUp[] cleanUps) {
                super(map, parent);
                this.fPreviewCleanUps = cleanUps;
                this.fUpdateBlocked = false;
            }

            protected void doFormatPreview() {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < this.fPreviewCleanUps.length) {
                    buf.append(this.fPreviewCleanUps[i].getPreview());
                    buf.append("\n");
                    ++i;
                }
                this.format(buf.toString());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void format(String text) {
                if (text == null) {
                    this.fPreviewDocument.set("");
                    return;
                }
                this.fPreviewDocument.set(text);
                this.fSourceViewer.setRedraw(false);
                CommentFormattingContext context = new CommentFormattingContext();
                try {
                    block7: {
                        try {
                            IContentFormatter formatter = this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer);
                            if (formatter instanceof IContentFormatterExtension) {
                                IContentFormatterExtension extension = (IContentFormatterExtension)formatter;
                                context.setProperty("formatting.context.preferences", this.fWorkingValues);
                                context.setProperty("formatting.context.document", true);
                                extension.format((IDocument)this.fPreviewDocument, (IFormattingContext)context);
                                break block7;
                            }
                            formatter.format((IDocument)this.fPreviewDocument, (IRegion)new Region(0, this.fPreviewDocument.getLength()));
                        }
                        catch (Exception e) {
                            Status status = new Status(4, JavaPlugin.getPluginId(), 10001, MultiFixMessages.CleanUpRefactoringWizard_formatterException_errorMessage, (Throwable)e);
                            JavaPlugin.log((IStatus)status);
                        }
                    }
                    Object var5_9 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    context.dispose();
                    this.fSourceViewer.setRedraw(true);
                    throw throwable;
                }
                context.dispose();
                this.fSourceViewer.setRedraw(true);
            }

            public void resumeUpdate() {
                this.fUpdateBlocked = false;
            }

            public void blockUpdate() {
                this.fUpdateBlocked = true;
            }

            public boolean isUpdateSuspended() {
                return this.fUpdateBlocked;
            }
        }
    }
}

