/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.SnippetPreview;

public final class WhiteSpaceOptions {
    private static final SnippetPreview.PreviewSnippet FOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "for (int i= 0, j= array.length; i < array.length; i++, j--) {}\nfor (String s : names) {}");
    private static final SnippetPreview.PreviewSnippet WHILE_PREVIEW = new SnippetPreview.PreviewSnippet(2, "while (condition) {}; do {} while (condition);");
    private static final SnippetPreview.PreviewSnippet CATCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try { number= Integer.parseInt(value); } catch (NumberFormatException e) {}");
    private static final SnippetPreview.PreviewSnippet IF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (condition) { return foo; } else {return bar;}");
    private static final SnippetPreview.PreviewSnippet SYNCHRONIZED_PREVIEW = new SnippetPreview.PreviewSnippet(2, "synchronized (list) { list.add(element); }");
    private static final SnippetPreview.PreviewSnippet SWITCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "switch (number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}");
    private static final SnippetPreview.PreviewSnippet CONSTRUCTOR_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "MyClass() throws E0, E1 { this(0,0,0);}MyClass(int x, int y, int z) throws E0, E1 { super(x, y, z, true);}");
    private static final SnippetPreview.PreviewSnippet METHOD_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void foo() throws E0, E1 {};void bar(int x, int y) throws E0, E1 {}");
    private static final SnippetPreview.PreviewSnippet ARRAY_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int [] array0= new int [] {};\nint [] array1= new int [] {1, 2, 3};\nint [] array2= new int[3];");
    private static final SnippetPreview.PreviewSnippet ARRAY_REF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "array[i].foo();");
    private static final SnippetPreview.PreviewSnippet METHOD_CALL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "foo();\nbar(x, y);");
    private static final SnippetPreview.PreviewSnippet ALLOC_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String str= new String(); Point point= new Point(x, y);");
    private static final SnippetPreview.PreviewSnippet LABEL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "label: for (int i= 0; i<list.length; i++) {for (int j= 0; j < list[i].length; j++) continue label;}");
    private static final SnippetPreview.PreviewSnippet SEMICOLON_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 4; foo(); bar(x, y);");
    private static final SnippetPreview.PreviewSnippet CONDITIONAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String value= condition ? TRUE : FALSE;");
    private static final SnippetPreview.PreviewSnippet CLASS_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(8, "class MyClass implements I0, I1, I2 {}");
    private static final SnippetPreview.PreviewSnippet ANON_CLASS_PREVIEW = new SnippetPreview.PreviewSnippet(2, "AnonClass= new AnonClass() {void foo(Some s) { }};");
    private static final SnippetPreview.PreviewSnippet OPERATOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "List list= new ArrayList(); int a= -4 + -9; b= a++ / --number; c += 4; boolean value= true && false;");
    private static final SnippetPreview.PreviewSnippet CAST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String s= ((String)object);");
    private static final SnippetPreview.PreviewSnippet MULT_LOCAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 0, b= 1, c= 2, d= 3;");
    private static final SnippetPreview.PreviewSnippet MULT_FIELD_PREVIEW = new SnippetPreview.PreviewSnippet(4, "int a=0,b=1,c=2,d=3;");
    private static final SnippetPreview.PreviewSnippet BLOCK_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (true) { return 1; } else { return 2; }");
    private static final SnippetPreview.PreviewSnippet PAREN_EXPR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "result= (a *( b +  c + d) * (e + f));");
    private static final SnippetPreview.PreviewSnippet ASSERT_PREVIEW = new SnippetPreview.PreviewSnippet(2, "assert condition : reportError();");
    private static final SnippetPreview.PreviewSnippet RETURN_PREVIEW = new SnippetPreview.PreviewSnippet(2, "return (o);");
    private static final SnippetPreview.PreviewSnippet ANNOTATION_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "@interface MyAnnotation { String value(); }\n@interface OtherAnnotation { }\n");
    private static final SnippetPreview.PreviewSnippet ANNOTATION_MODIFIER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "@Annot(x=23, y=-3)\npublic class A { }\n");
    private static final SnippetPreview.PreviewSnippet ENUM_PREVIEW = new SnippetPreview.PreviewSnippet(4, "enum MyEnum { GREEN(0, 1), RED() {\nvoid process() {}\n}\n}");
    private static final SnippetPreview.PreviewSnippet PARAMETERIZED_TYPE_REFERENCE_PREVIEW = new SnippetPreview.PreviewSnippet(4, "Map<String, Element> map=\n new HashMap<String, Element>();");
    private static final SnippetPreview.PreviewSnippet TYPE_ARGUMENTS_PREVIEW = new SnippetPreview.PreviewSnippet(2, "x.<String, Element>foo();");
    private static final SnippetPreview.PreviewSnippet TYPE_PARAMETER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "class MyGenericType<S, T extends Element & List> { }");
    private static final SnippetPreview.PreviewSnippet VARARG_PARAMETER_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void format(String s, Object ... args) {}");
    private static final SnippetPreview.PreviewSnippet WILDCARD_PREVIEW = new SnippetPreview.PreviewSnippet(4, "Map<X<?>, Y<? extends K, ? super V>> t;");

    public static List createTreeBySyntaxElem(Map workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_paren);
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_paren);
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_brace);
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_brace);
        WhiteSpaceOptions.createBeforeClosingBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_bracket);
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_bracket);
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_operator);
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_comma);
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_colon);
        WhiteSpaceOptions.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_semicolon);
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_question_mark);
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        WhiteSpaceOptions.createBetweenEmptyBracesTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public static List createAltTree(Map workingValues) {
        ArrayList roots = new ArrayList();
        InnerNode parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_paren);
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_paren);
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_paren);
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_paren);
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_brace);
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_brace);
        WhiteSpaceOptions.createAfterOpenBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_brace);
        WhiteSpaceOptions.createBeforeClosingBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_brace);
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        WhiteSpaceOptions.createBetweenEmptyBracesTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_bracket);
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_bracket);
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_bracket);
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_angle_bracket);
        WhiteSpaceOptions.createBeforeOpenAngleBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_angle_bracket);
        WhiteSpaceOptions.createAfterOpenAngleBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_angle_bracket);
        WhiteSpaceOptions.createBeforeClosingAngleBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_angle_bracket);
        WhiteSpaceOptions.createAfterClosingAngleBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_operator);
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_operator);
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_comma);
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_comma);
        WhiteSpaceOptions.createAfterCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_colon);
        WhiteSpaceOptions.createAfterColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_colon);
        WhiteSpaceOptions.createBeforeColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon);
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_semicolon);
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_question_mark);
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_question_mark);
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_at);
        WhiteSpaceOptions.createBeforeAtTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_at);
        WhiteSpaceOptions.createAfterAtTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_and);
        WhiteSpaceOptions.createBeforeAndTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_and);
        WhiteSpaceOptions.createAfterAndTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_ellipsis);
        WhiteSpaceOptions.createBeforeEllipsis(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_ellipsis);
        WhiteSpaceOptions.createAfterEllipsis(workingValues, parent);
        return roots;
    }

    private static InnerNode createParentNode(List roots, Map workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public static ArrayList createTreeByJavaElement(Map workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_declarations);
        WhiteSpaceOptions.createClassTree(workingValues, declarations);
        WhiteSpaceOptions.createFieldTree(workingValues, declarations);
        WhiteSpaceOptions.createLocalVariableTree(workingValues, declarations);
        WhiteSpaceOptions.createConstructorTree(workingValues, declarations);
        WhiteSpaceOptions.createMethodDeclTree(workingValues, declarations);
        WhiteSpaceOptions.createLabelTree(workingValues, declarations);
        WhiteSpaceOptions.createAnnotationTree(workingValues, declarations);
        WhiteSpaceOptions.createEnumTree(workingValues, declarations);
        WhiteSpaceOptions.createAnnotationTypeTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_statements);
        WhiteSpaceOptions.createOption(statements, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
        WhiteSpaceOptions.createBlockTree(workingValues, statements);
        WhiteSpaceOptions.createIfStatementTree(workingValues, statements);
        WhiteSpaceOptions.createForStatementTree(workingValues, statements);
        WhiteSpaceOptions.createSwitchStatementTree(workingValues, statements);
        WhiteSpaceOptions.createDoWhileTree(workingValues, statements);
        WhiteSpaceOptions.createSynchronizedTree(workingValues, statements);
        WhiteSpaceOptions.createTryStatementTree(workingValues, statements);
        WhiteSpaceOptions.createAssertTree(workingValues, statements);
        WhiteSpaceOptions.createReturnTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_expressions);
        WhiteSpaceOptions.createFunctionCallTree(workingValues, expressions);
        WhiteSpaceOptions.createAssignmentTree(workingValues, expressions);
        WhiteSpaceOptions.createOperatorTree(workingValues, expressions);
        WhiteSpaceOptions.createParenthesizedExpressionTree(workingValues, expressions);
        WhiteSpaceOptions.createTypecastTree(workingValues, expressions);
        WhiteSpaceOptions.createConditionalTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_arrays);
        WhiteSpaceOptions.createArrayDeclarationTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayAllocTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayInitializerTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayElementAccessTree(workingValues, arrays);
        InnerNode paramtypes = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_parameterized_types);
        WhiteSpaceOptions.createParameterizedTypeTree(workingValues, paramtypes);
        WhiteSpaceOptions.createTypeArgumentTree(workingValues, paramtypes);
        WhiteSpaceOptions.createTypeParameterTree(workingValues, paramtypes);
        WhiteSpaceOptions.createWildcardTypeTree(workingValues, paramtypes);
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        roots.add(paramtypes);
        return roots;
    }

    private static void createBeforeQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_wildcard, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_wildcard", WILDCARD_PREVIEW);
    }

    private static void createBeforeAtTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_before_at_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
    }

    private static void createBeforeAndTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_and_in_type_parameter", TYPE_PARAMETER_PREVIEW);
    }

    private static void createBeforeSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_statements, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
    }

    private static void createBeforeColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", LABEL_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_case, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_default, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_for", FOR_PREVIEW);
    }

    private static void createBeforeCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_declarations", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_constant_arguments", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createBeforeOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createBeforeClosingBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createBeforeClosingAngleBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createBeforeOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createBeforeOpenAngleBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createBeforeClosingBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_init, "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", CLASS_DECL_PREVIEW);
    }

    private static void createBeforeOpenBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_class_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_anon_class_decl, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", ANON_CLASS_PREVIEW);
        InnerNode functionDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_declaration", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_body, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
    }

    private static void createBeforeClosingParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
    }

    private static void createBeforeOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        InnerNode returns = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return);
        WhiteSpaceOptions.createOption(returns, workingValues, FormatterMessages.WhiteSpaceOptions_return_with_parenthesized_expression, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_return", RETURN_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type_member, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation_type_member_declaration", ANNOTATION_DECL_PREVIEW);
    }

    private static void createAfterQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_wildcard, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_wildcard", WILDCARD_PREVIEW);
    }

    private static void createAfterAtTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
    }

    private static void createAfterAndTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_and_in_type_parameter", TYPE_PARAMETER_PREVIEW);
    }

    private static void createBeforeEllipsis(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_vararg_parameter, "org.eclipse.jdt.core.formatter.insert_space_before_ellipsis", VARARG_PARAMETER_PREVIEW);
    }

    private static void createAfterEllipsis(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_vararg_parameter, "org.eclipse.jdt.core.formatter.insert_space_after_ellipsis", VARARG_PARAMETER_PREVIEW);
    }

    private static void createAfterSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
    }

    private static void createAfterColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assert, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_for", FOR_PREVIEW);
    }

    private static void createAfterCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_initialization, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, FormatterMessages.WhiteSpaceOptions_incrementation, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_explicit_constructor_call, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_alloc_expr, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_throws);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_mult_decls);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_fields, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, FormatterMessages.WhiteSpaceOptions_local_vars, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_implements_clause, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_declaration, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_declarations", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_constant_arguments", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createAfterOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createAfterOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_element_access, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createAfterOpenAngleBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameterized_type, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createAfterOpenBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
    }

    private static void createAfterCloseBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", BLOCK_PREVIEW);
    }

    private static void createAfterCloseParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
    }

    private static void createAfterClosingAngleBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_parameters, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
    }

    private static void createAfterOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_synchronized, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_constructor, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_modifier_args, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
    }

    private static void createBetweenEmptyParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_constructor_decl, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_enum_constant_arguments, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_annotation_type_member, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", ANNOTATION_DECL_PREVIEW);
    }

    private static void createBetweenEmptyBracketsTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_alloc, "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_array_decl, "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_DECL_PREVIEW);
    }

    private static void createBetweenEmptyBracesTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer, "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", ARRAY_DECL_PREVIEW);
    }

    private static InnerNode createClassTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_classes);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_a_class, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_anon_class, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", ANON_CLASS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_comma_implements, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_after_comma_implements, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createAssignmentTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_before_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_after_assignment_operator, "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createOperatorTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_operators);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_binary_operators, "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_binary_operators, "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_unary_operators, "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_unary_operators, "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_prefix_operators, "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_prefix_operators, "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_postfix_operators, "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_postfix_operators, "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createMethodDeclTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_methods);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_ellipsis, "org.eclipse.jdt.core.formatter.insert_space_before_ellipsis", VARARG_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_ellipsis, "org.eclipse.jdt.core.formatter.insert_space_after_ellipsis", VARARG_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createConstructorTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_constructors);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_throws, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createFieldTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_fields);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_fields_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_LOCAL_PREVIEW);
        return root;
    }

    private static InnerNode createLocalVariableTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_localvars_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayInitializerTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayinit);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_brace, "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_braces, "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayDeclarationTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arraydecls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayElementAccessTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayelem);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        return root;
    }

    private static InnerNode createArrayAllocTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_arrayalloc);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createFunctionCallTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_calls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_method_args, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_method_args, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_alloc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_alloc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_qalloc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_qalloc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createBlockTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_blocks);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_brace, "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", BLOCK_PREVIEW);
        return root;
    }

    private static InnerNode createSwitchStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_switch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_case_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_default_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        return root;
    }

    private static InnerNode createDoWhileTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_do);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        return root;
    }

    private static InnerNode createSynchronizedTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_synchronized);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        return root;
    }

    private static InnerNode createTryStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_try);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        return root;
    }

    private static InnerNode createIfStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_if);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        return root;
    }

    private static InnerNode createForStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_for);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_init, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_init, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_before_comma_inc, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_for_after_comma_inc, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_for", FOR_PREVIEW);
        return root;
    }

    private static InnerNode createAssertTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assert);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", ASSERT_PREVIEW);
        return root;
    }

    private static InnerNode createReturnTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceOptions_return);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_parenthesized_expressions, "org.eclipse.jdt.core.formatter.insert_space_before_parenthesized_expression_in_return", RETURN_PREVIEW);
        return root;
    }

    private static InnerNode createLabelTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_labels);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", LABEL_PREVIEW);
        return root;
    }

    private static InnerNode createAnnotationTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_annotations);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_at, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_annotation", ANNOTATION_MODIFIER_PREVIEW);
        return root;
    }

    private static InnerNode createAnnotationTypeTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_annotation_types);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_at, "org.eclipse.jdt.core.formatter.insert_space_before_at_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_at, "org.eclipse.jdt.core.formatter.insert_space_after_at_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_annotation_type_declaration", ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_annot_type_method_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_annotation_type_member_declaration", ANNOTATION_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_annot_type_method_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", ANNOTATION_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createEnumTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_enums);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_declaration", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_declarations", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_decl_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_declarations", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_between_empty_parens, "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_enum_constant_arguments", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_enum_constant_arguments", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_arg_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_enum_constant", ENUM_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_enum_const_before_opening_brace, "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_enum_constant", ENUM_PREVIEW);
        return root;
    }

    private static InnerNode createParameterizedTypeTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_param_type_ref);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", PARAMETERIZED_TYPE_REFERENCE_PREVIEW);
        return root;
    }

    private static InnerNode createTypeArgumentTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_type_arguments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", TYPE_ARGUMENTS_PREVIEW);
        return root;
    }

    private static InnerNode createTypeParameterTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_type_parameters);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.jdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_parameters", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_and_list, "org.eclipse.jdt.core.formatter.insert_space_before_and_in_type_parameter", TYPE_PARAMETER_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_and_list, "org.eclipse.jdt.core.formatter.insert_space_after_and_in_type_parameter", TYPE_PARAMETER_PREVIEW);
        return root;
    }

    private static InnerNode createWildcardTypeTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_wildcardtype);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_wildcard", WILDCARD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_wildcard", WILDCARD_PREVIEW);
        return root;
    }

    private static InnerNode createConditionalTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_conditionals);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
        return root;
    }

    private static InnerNode createTypecastTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_typecasts);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
        return root;
    }

    private static InnerNode createParenthesizedExpressionTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_parenexpr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map workingValues, String message) {
        return new InnerNode(root, workingValues, message);
    }

    private static OptionNode createOption(InnerNode root, Map workingValues, String message, String key, SnippetPreview.PreviewSnippet snippet) {
        return new OptionNode(root, workingValues, message, key, snippet);
    }

    public static void makeIndexForNodes(List tree, List flatList) {
        Iterator iter = tree.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map fWorkingValues;
        protected final ArrayList fChildren;

        public Node(InnerNode parent, Map workingValues, String message) {
            if (workingValues == null || message == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = message;
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List getSnippets();

        public abstract void getCheckedLeafs(List var1);
    }

    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        public void setChecked(boolean checked) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        public List getSnippets() {
            ArrayList snippets = new ArrayList(this.fChildren.size());
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                List childSnippets = ((Node)iter.next()).getSnippets();
                Iterator chIter = childSnippets.iterator();
                while (chIter.hasNext()) {
                    Object snippet = chIter.next();
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        public void getCheckedLeafs(List list) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).getCheckedLeafs(list);
            }
        }
    }

    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList fSnippets;

        public OptionNode(InnerNode parent, Map workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "insert" : "do not insert");
        }

        public boolean getChecked() {
            return "insert".equals(this.fWorkingValues.get(this.fKey));
        }

        public List getSnippets() {
            return this.fSnippets;
        }

        public void getCheckedLeafs(List list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

