/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public final class MoveInstanceMethodAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public MoveInstanceMethodAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public MoveInstanceMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.MoveInstanceMethodAction_Move_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
        }
        catch (CoreException coreException) {
            this.setEnabled(false);
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IMethod)) {
            return null;
        }
        return (IMethod)first;
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isMoveMethodAvailable(selection));
            IMethod method = MoveInstanceMethodAction.getSingleSelectedMethod(selection);
            Assert.isNotNull((Object)method);
            if (!ActionUtil.isProcessable(this.getShell(), method)) {
                return;
            }
            RefactoringExecutionStarter.startMoveMethodRefactoring(method, this.getShell());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            this.run(selection, SelectionConverter.getInputAsCompilationUnit(this.fEditor));
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    private void run(ITextSelection selection, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull((Object)cu);
        Assert.isTrue((selection.getOffset() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selection.getLength() >= 0 ? 1 : 0) != 0);
        if (!ActionUtil.isProcessable(this.getShell(), cu)) {
            return;
        }
        IMethod method = MoveInstanceMethodAction.getMethod(cu, selection);
        if (method != null) {
            RefactoringExecutionStarter.startMoveMethodRefactoring(method, this.getShell());
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveInstanceMethodAction_dialog_title, (String)RefactoringMessages.MoveInstanceMethodAction_No_reference_or_declaration);
        }
    }

    private static IMethod getMethod(ICompilationUnit cu, ITextSelection selection) throws JavaModelException {
        IJavaElement element = SelectionConverter.getElementAtOffset((IJavaElement)cu, selection);
        if (element instanceof IMethod) {
            return (IMethod)element;
        }
        return null;
    }
}

