/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.ISavable;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerSwitchingCancelled;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class ContentMergeViewer
extends ContentViewer
implements IPropertyChangeNotifier,
ISavable {
    private static final String ANCESTOR_ENABLED = "org.eclipse.compare.InitiallyShowAncestorPane";
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final double HSPLIT = 0.5;
    static final double VSPLIT = 0.3;
    private int fStyles;
    private ResourceBundle fBundle;
    private CompareConfiguration fCompareConfiguration;
    private IPropertyChangeListener fPropertyChangeListener;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private ListenerList fListenerList;
    boolean fConfirmSave = true;
    private double fHSplit = 0.5;
    private double fVSplit = 0.3;
    private boolean fAncestorEnabled = true;
    boolean fShowAncestor = false;
    private boolean fIsThreeWay = false;
    private ActionContributionItem fAncestorItem;
    private Action fCopyLeftToRightAction;
    private Action fCopyRightToLeftAction;
    MergeViewerAction fLeftSaveAction;
    MergeViewerAction fRightSaveAction;
    private IKeyBindingService fKeyBindingService;
    Composite fComposite;
    private CLabel fAncestorLabel;
    private CLabel fLeftLabel;
    private CLabel fRightLabel;
    CLabel fDirectionLabel;
    Control fCenter;
    private Image fRightArrow;
    private Image fLeftArrow;
    private Image fBothArrow;
    Cursor fNormalCursor;
    private Cursor fHSashCursor;
    private Cursor fVSashCursor;
    private Cursor fHVSashCursor;

    protected ContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        this.fStyles = style & 0xF9FFFFFF;
        this.fBundle = bundle;
        this.fAncestorEnabled = Utilities.getBoolean(cc, ANCESTOR_ENABLED, this.fAncestorEnabled);
        this.fConfirmSave = Utilities.getBoolean(cc, "org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", this.fConfirmSave);
        this.setContentProvider(new MergeViewerContentProvider(cc));
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                ContentMergeViewer.this.internalRefresh(input);
            }
        };
        this.fCompareConfiguration = cc;
        if (this.fCompareConfiguration != null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ContentMergeViewer.this.propertyChange(event);
                }
            };
            this.fCompareConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fLeftSaveAction = new SaveAction(true);
        this.fLeftSaveAction.setEnabled(false);
        this.fRightSaveAction = new SaveAction(false);
        this.fRightSaveAction.setEnabled(false);
    }

    public String getTitle() {
        return Utilities.getString(this.getResourceBundle(), "title");
    }

    protected abstract void createControls(Composite var1);

    protected abstract void handleResizeAncestor(int var1, int var2, int var3, int var4);

    protected abstract void handleResizeLeftRight(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void createToolItems(ToolBarManager toolBarManager) {
    }

    protected abstract void updateContent(Object var1, Object var2, Object var3);

    protected abstract void copy(boolean var1);

    protected abstract byte[] getContents(boolean var1);

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IMergeViewerContentProvider));
        super.setContentProvider(contentProvider);
    }

    IMergeViewerContentProvider getMergeContentProvider() {
        return (IMergeViewerContentProvider)this.getContentProvider();
    }

    public ISelection getSelection() {
        return new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        };
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(ANCESTOR_ENABLED)) {
            this.fAncestorEnabled = Utilities.getBoolean(this.getCompareConfiguration(), ANCESTOR_ENABLED, this.fAncestorEnabled);
            this.fComposite.layout(true);
            this.updateCursor((Control)this.fLeftLabel, 2);
            this.updateCursor((Control)this.fDirectionLabel, 3);
            this.updateCursor((Control)this.fRightLabel, 2);
            return;
        }
    }

    void updateCursor(Control c, int dir) {
        if (!(c instanceof Sash)) {
            Cursor cursor = null;
            switch (dir) {
                case 2: {
                    if (this.fAncestorEnabled) {
                        if (this.fVSashCursor == null) {
                            this.fVSashCursor = new Cursor((Device)c.getDisplay(), 7);
                        }
                        cursor = this.fVSashCursor;
                        break;
                    }
                    if (this.fNormalCursor == null) {
                        this.fNormalCursor = new Cursor((Device)c.getDisplay(), 0);
                    }
                    cursor = this.fNormalCursor;
                    break;
                }
                case 1: {
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                    break;
                }
                case 3: {
                    if (this.fAncestorEnabled) {
                        if (this.fHVSashCursor == null) {
                            this.fHVSashCursor = new Cursor((Device)c.getDisplay(), 5);
                        }
                        cursor = this.fHVSashCursor;
                        break;
                    }
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                }
            }
            if (cursor != null) {
                c.setCursor(cursor);
            }
        }
    }

    void setAncestorVisibility(boolean visible, boolean enabled) {
        Action action;
        if (this.fAncestorItem != null && (action = (Action)this.fAncestorItem.getAction()) != null) {
            action.setChecked(visible);
            action.setEnabled(enabled);
        }
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.setProperty(ANCESTOR_ENABLED, new Boolean(visible));
        }
    }

    boolean isThreeWay() {
        return this.fIsThreeWay;
    }

    protected final void inputChanged(Object input, Object oldInput) {
        if (input != oldInput && oldInput instanceof ICompareInput) {
            ((ICompareInput)oldInput).removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        boolean success = this.doSave(input, oldInput);
        if (input != oldInput && input instanceof ICompareInput) {
            ((ICompareInput)input).addCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (success) {
            this.setLeftDirty(false);
            this.setRightDirty(false);
        }
        if (input != oldInput) {
            this.internalRefresh(input);
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        if (this.fLeftSaveAction.isEnabled() || this.fRightSaveAction.isEnabled()) {
            if (this.fConfirmSave) {
                Shell shell = this.fComposite.getShell();
                MessageDialog dialog = new MessageDialog(shell, Utilities.getString(this.getResourceBundle(), "saveDialog.title"), null, Utilities.getString(this.getResourceBundle(), "saveDialog.message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (dialog.open()) {
                    case 0: {
                        this.saveContent(oldInput);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                        break;
                    }
                    case 2: {
                        throw new ViewerSwitchingCancelled();
                    }
                }
            } else {
                this.saveContent(oldInput);
            }
            return true;
        }
        return false;
    }

    public void setConfirmSave(boolean enable) {
        this.fConfirmSave = enable;
    }

    public void refresh() {
        this.internalRefresh(this.getInput());
    }

    private void internalRefresh(Object input) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        if (content != null) {
            ToolBarManager tbm;
            Object ancestor = content.getAncestorContent(input);
            if (input instanceof ICompareInput) {
                this.fIsThreeWay = (((ICompareInput)input).getKind() & 0xC) != 0;
            } else {
                boolean bl = this.fIsThreeWay = ancestor != null;
            }
            if (this.fAncestorItem != null) {
                this.fAncestorItem.setVisible(this.fIsThreeWay);
            }
            boolean oldFlag = this.fShowAncestor;
            boolean bl = this.fShowAncestor = this.fIsThreeWay && content.showAncestor(input);
            if (this.fAncestorEnabled && oldFlag != this.fShowAncestor) {
                this.fComposite.layout(true);
            }
            if ((tbm = CompareViewerPane.getToolBarManager(this.fComposite.getParent())) != null) {
                this.updateToolItems();
                tbm.update(true);
                tbm.getControl().getParent().layout(true);
            }
            this.updateHeader();
            Object left = content.getLeftContent(input);
            Object right = content.getRightContent(input);
            this.updateContent(ancestor, left, right);
        }
    }

    protected final Control buildControl(Composite parent) {
        this.fComposite = new Composite(parent, this.fStyles | 0x2000000){

            public boolean setFocus() {
                return ContentMergeViewer.this.internalSetFocus();
            }
        };
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        this.hookControl((Control)this.fComposite);
        this.fComposite.setLayout((Layout)new ContentMergeViewerLayout());
        int style = 8;
        this.fAncestorLabel = new CLabel(this.fComposite, style);
        this.fLeftLabel = new CLabel(this.fComposite, style);
        new Resizer((Control)this.fLeftLabel, 2);
        this.fDirectionLabel = new CLabel(this.fComposite, style);
        this.fDirectionLabel.setAlignment(0x1000000);
        new Resizer((Control)this.fDirectionLabel, 3);
        this.fRightLabel = new CLabel(this.fComposite, style);
        new Resizer((Control)this.fRightLabel, 2);
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenter(this.fComposite);
        }
        this.createControls(this.fComposite);
        IWorkbenchPartSite ps = Utilities.findSite((Control)this.fComposite);
        this.fKeyBindingService = ps != null ? ps.getKeyBindingService() : null;
        ToolBarManager tbm = CompareViewerPane.getToolBarManager(parent);
        if (tbm != null) {
            tbm.removeAll();
            tbm.add((IContributionItem)new Separator("modes"));
            tbm.add((IContributionItem)new Separator("merge"));
            tbm.add((IContributionItem)new Separator("navigation"));
            CompareConfiguration cc = this.getCompareConfiguration();
            if (cc.isRightEditable()) {
                this.fCopyLeftToRightAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(true);
                    }
                };
                Utilities.initAction((IAction)this.fCopyLeftToRightAction, this.getResourceBundle(), "action.CopyLeftToRight.");
                tbm.appendToGroup("merge", (IAction)this.fCopyLeftToRightAction);
                Utilities.registerAction(this.fKeyBindingService, (IAction)this.fCopyLeftToRightAction, "org.eclipse.compare.copyAllLeftToRight");
            }
            if (cc.isLeftEditable()) {
                this.fCopyRightToLeftAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(false);
                    }
                };
                Utilities.initAction((IAction)this.fCopyRightToLeftAction, this.getResourceBundle(), "action.CopyRightToLeft.");
                tbm.appendToGroup("merge", (IAction)this.fCopyRightToLeftAction);
                Utilities.registerAction(this.fKeyBindingService, (IAction)this.fCopyRightToLeftAction, "org.eclipse.compare.copyAllRightToLeft");
            }
            ChangePropertyAction a = new ChangePropertyAction(this.fBundle, this.fCompareConfiguration, "action.EnableAncestor.", ANCESTOR_ENABLED);
            a.setChecked(this.fAncestorEnabled);
            this.fAncestorItem = new ActionContributionItem((IAction)a);
            this.fAncestorItem.setVisible(false);
            tbm.appendToGroup("modes", (IContributionItem)this.fAncestorItem);
            this.createToolItems(tbm);
            this.updateToolItems();
            tbm.update(true);
        }
        return this.fComposite;
    }

    boolean internalSetFocus() {
        return false;
    }

    int getCenterWidth() {
        return 3;
    }

    boolean getAncestorEnabled() {
        return this.fAncestorEnabled;
    }

    Control createCenter(Composite parent) {
        Sash sash = new Sash(parent, 512);
        new Resizer((Control)sash, 1);
        return sash;
    }

    Control getCenter() {
        return this.fCenter;
    }

    public Control getControl() {
        return this.fComposite;
    }

    protected void handleDispose(DisposeEvent event) {
        Object input;
        if (this.fKeyBindingService != null) {
            if (this.fCopyLeftToRightAction != null) {
                this.fKeyBindingService.unregisterAction((IAction)this.fCopyLeftToRightAction);
            }
            if (this.fCopyRightToLeftAction != null) {
                this.fKeyBindingService.unregisterAction((IAction)this.fCopyRightToLeftAction);
            }
            this.fKeyBindingService = null;
        }
        if ((input = this.getInput()) instanceof ICompareInput) {
            ((ICompareInput)input).removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (this.fCompareConfiguration != null && this.fPropertyChangeListener != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.fAncestorLabel = null;
        this.fLeftLabel = null;
        this.fDirectionLabel = null;
        this.fRightLabel = null;
        this.fCenter = null;
        if (this.fRightArrow != null) {
            this.fRightArrow.dispose();
            this.fRightArrow = null;
        }
        if (this.fLeftArrow != null) {
            this.fLeftArrow.dispose();
            this.fLeftArrow = null;
        }
        if (this.fBothArrow != null) {
            this.fBothArrow.dispose();
            this.fBothArrow = null;
        }
        if (this.fNormalCursor != null) {
            this.fNormalCursor.dispose();
            this.fNormalCursor = null;
        }
        if (this.fHSashCursor != null) {
            this.fHSashCursor.dispose();
            this.fHSashCursor = null;
        }
        if (this.fVSashCursor != null) {
            this.fVSashCursor.dispose();
            this.fVSashCursor = null;
        }
        if (this.fHVSashCursor != null) {
            this.fHVSashCursor.dispose();
            this.fHVSashCursor = null;
        }
        super.handleDispose(event);
    }

    protected void updateToolItems() {
        boolean enable;
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object input = this.getInput();
        if (this.fCopyLeftToRightAction != null) {
            enable = content.isRightEditable(input);
            this.fCopyLeftToRightAction.setEnabled(enable);
        }
        if (this.fCopyRightToLeftAction != null) {
            enable = content.isLeftEditable(input);
            this.fCopyRightToLeftAction.setEnabled(enable);
        }
    }

    protected void updateHeader() {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object input = this.getInput();
        if (this.fAncestorLabel != null) {
            this.fAncestorLabel.setImage(content.getAncestorImage(input));
            this.fAncestorLabel.setText(content.getAncestorLabel(input));
        }
        if (this.fLeftLabel != null) {
            this.fLeftLabel.setImage(content.getLeftImage(input));
            this.fLeftLabel.setText(content.getLeftLabel(input));
        }
        if (this.fRightLabel != null) {
            this.fRightLabel.setImage(content.getRightImage(input));
            this.fRightLabel.setText(content.getRightLabel(input));
        }
    }

    int getHeaderHeight() {
        int headerHeight = this.fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
        headerHeight = Math.max(headerHeight, this.fDirectionLabel.computeSize((int)-1, (int)-1, (boolean)true).y);
        return headerHeight;
    }

    boolean canToggleMergeDirection() {
        Object input;
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        return content.isLeftEditable(input = this.getInput()) && content.isRightEditable(input);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    void fireDirtyState(boolean state) {
        Utilities.firePropertyChange(this.fListenerList, this, "DIRTY_STATE", null, new Boolean(state));
    }

    protected void setLeftDirty(boolean dirty) {
        if (this.fLeftSaveAction.isEnabled() != dirty) {
            this.fLeftSaveAction.setEnabled(dirty);
            this.fireDirtyState(dirty);
        }
    }

    protected void setRightDirty(boolean dirty) {
        if (this.fRightSaveAction.isEnabled() != dirty) {
            this.fRightSaveAction.setEnabled(dirty);
            this.fireDirtyState(dirty);
        }
    }

    public void save(IProgressMonitor pm) throws CoreException {
        this.saveContent(this.getInput());
    }

    void saveContent(Object oldInput) {
        byte[] bytes;
        boolean rightEmpty;
        IMergeViewerContentProvider content = (IMergeViewerContentProvider)this.getContentProvider();
        boolean leftEmpty = content.getLeftContent(oldInput) == null;
        boolean bl = rightEmpty = content.getRightContent(oldInput) == null;
        if (this.fCompareConfiguration.isLeftEditable() && this.fLeftSaveAction.isEnabled()) {
            bytes = this.getContents(true);
            if (leftEmpty && bytes != null && bytes.length == 0) {
                bytes = null;
            }
            this.setLeftDirty(false);
            content.saveLeftContent(oldInput, bytes);
        }
        if (this.fCompareConfiguration.isRightEditable() && this.fRightSaveAction.isEnabled()) {
            bytes = this.getContents(false);
            if (rightEmpty && bytes != null && bytes.length == 0) {
                bytes = null;
            }
            this.setRightDirty(false);
            content.saveRightContent(oldInput, bytes);
        }
    }

    class SaveAction
    extends MergeViewerAction {
        SaveAction(boolean left) {
            super(true, false, false);
            Utilities.initAction((IAction)this, ContentMergeViewer.this.getResourceBundle(), "action.save.");
        }

        public void run() {
            ContentMergeViewer.this.saveContent(ContentMergeViewer.this.getInput());
        }
    }

    private class ContentMergeViewerLayout
    extends Layout {
        private ContentMergeViewerLayout() {
        }

        public Point computeSize(Composite c, int w, int h, boolean force) {
            return new Point(100, 100);
        }

        public void layout(Composite composite, boolean force) {
            int headerHeight = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
            Rectangle r = composite.getClientArea();
            int centerWidth = ContentMergeViewer.this.getCenterWidth();
            int width1 = (int)((double)(r.width - centerWidth) * ContentMergeViewer.this.fHSplit);
            int width2 = r.width - width1 - centerWidth;
            int height1 = 0;
            int height2 = 0;
            if (ContentMergeViewer.this.fAncestorEnabled && ContentMergeViewer.this.fShowAncestor) {
                height1 = (int)((double)(r.height - 2 * headerHeight) * ContentMergeViewer.this.fVSplit);
                height2 = r.height - 2 * headerHeight - height1;
            } else {
                height1 = 0;
                height2 = r.height - headerHeight;
            }
            int y = 0;
            if (ContentMergeViewer.this.fAncestorEnabled && ContentMergeViewer.this.fShowAncestor) {
                ContentMergeViewer.this.fAncestorLabel.setBounds(0, y, r.width, headerHeight);
                ContentMergeViewer.this.fAncestorLabel.setVisible(true);
                ContentMergeViewer.this.handleResizeAncestor(0, y += headerHeight, r.width, height1);
                y += height1;
            } else {
                ContentMergeViewer.this.fAncestorLabel.setVisible(false);
                ContentMergeViewer.this.handleResizeAncestor(0, 0, 0, 0);
            }
            ContentMergeViewer.this.fLeftLabel.getSize();
            if (centerWidth > 3) {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, y, width1 + 1, headerHeight);
                ContentMergeViewer.this.fDirectionLabel.setVisible(true);
                ContentMergeViewer.this.fDirectionLabel.setBounds(width1 + 1, y, centerWidth - 1, headerHeight);
                ContentMergeViewer.this.fRightLabel.setBounds(width1 + centerWidth, y, width2, headerHeight);
            } else {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, y, width1, headerHeight);
                ContentMergeViewer.this.fDirectionLabel.setVisible(false);
                ContentMergeViewer.this.fRightLabel.setBounds(width1, y, r.width - width1, headerHeight);
            }
            y += headerHeight;
            if (ContentMergeViewer.this.fCenter != null && !ContentMergeViewer.this.fCenter.isDisposed()) {
                ContentMergeViewer.this.fCenter.setBounds(width1, y, centerWidth, height2);
            }
            ContentMergeViewer.this.handleResizeLeftRight(0, y, width1, centerWidth, width2, height2);
        }
    }

    class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public Resizer(Control c, int dir) {
            this.fDirection = dir;
            this.fControl = c;
            this.fLiveResize = !(this.fControl instanceof Sash);
            ContentMergeViewer.this.updateCursor(c, dir);
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ Resizer this$1;
                {
                    this.this$1 = resizer;
                }

                public void widgetDisposed(DisposeEvent e) {
                    this.this$1.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
            if ((this.fDirection & 1) != 0) {
                ContentMergeViewer.this.fHSplit = 0.5;
            }
            if ((this.fDirection & 2) != 0) {
                ContentMergeViewer.this.fVSplit = 0.3;
            }
            ContentMergeViewer.this.fComposite.layout(true);
        }

        public void mouseDown(MouseEvent e) {
            Composite parent = this.fControl.getParent();
            Point s = parent.getSize();
            Point as = ContentMergeViewer.this.fAncestorLabel.getSize();
            Point ys = ContentMergeViewer.this.fLeftLabel.getSize();
            Point ms = ContentMergeViewer.this.fRightLabel.getSize();
            this.fWidth1 = ys.x;
            this.fWidth2 = ms.x;
            this.fHeight1 = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y - as.y;
            this.fHeight2 = s.y - (((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y + ys.y);
            this.fX = e.x;
            this.fY = e.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent e) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(e);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(e);
            }
        }

        private void resize(MouseEvent e) {
            int dx = e.x - this.fX;
            int dy = e.y - this.fY;
            int centerWidth = ContentMergeViewer.this.fCenter.getSize().x;
            if (this.fWidth1 + dx > centerWidth && this.fWidth2 - dx > centerWidth) {
                this.fWidth1 += dx;
                this.fWidth2 -= dx;
                if ((this.fDirection & 1) != 0) {
                    ContentMergeViewer.this.fHSplit = (double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2);
                }
            }
            if (this.fHeight1 + dy > centerWidth && this.fHeight2 - dy > centerWidth) {
                this.fHeight1 += dy;
                this.fHeight2 -= dy;
                if ((this.fDirection & 2) != 0) {
                    ContentMergeViewer.this.fVSplit = (double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2);
                }
            }
            ContentMergeViewer.this.fComposite.layout(true);
            this.fControl.getDisplay().update();
        }
    }
}

