/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.language.LanguageEntry;

public class LanguageGroup {
    public static final String DEFAULT_NAME = "Untitled Group";
    private String name;
    private Map entries = new LinkedHashMap();

    public LanguageGroup(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public LanguageGroup(String name, LanguageEntry[] entries) {
        this(name);
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.addEntry(entries[i]);
                ++i;
            }
        }
    }

    public LanguageGroup(String name, Collection entries) {
        this(name, entries == null ? null : entries.toArray(new LanguageEntry[entries.size()]));
    }

    public String getName() {
        return this.name;
    }

    public LanguageEntry getEntry(String name) {
        return (LanguageEntry)this.entries.get(name);
    }

    public boolean addEntry(LanguageEntry entry) {
        if (entry == null || this.entries.containsKey(entry.getName())) {
            return false;
        }
        this.entries.put(entry.getName(), entry);
        return true;
    }

    public boolean removeEntry(LanguageEntry entry) {
        if (entry == null || !this.entries.containsValue(entry)) {
            return false;
        }
        this.entries.remove(entry.getName());
        return true;
    }

    public Set getEntryNames() {
        return new LinkedHashSet(this.entries.keySet());
    }

    public Collection getEntries() {
        return new ArrayList(this.entries.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageGroup lg = (LanguageGroup)obj;
        return this.name.equals(lg.name) && this.entries.equals(lg.entries);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.entries.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',entries=" + this.entries.keySet() + ')';
    }
}

