/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.language;

import java.util.Locale;
import org.eclipse.vtp.framework.media.language.LanguageCategory;

public class MediaLanguage {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final String DEFAULT_TRANSLATOR;
    private Locale locale = DEFAULT_LOCALE;
    private String translator = DEFAULT_TRANSLATOR;
    private LanguageCategory promptsCategory = new LanguageCategory();
    private LanguageCategory grammarsCategory = new LanguageCategory();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.media.language.DefaultTranslator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_TRANSLATOR = clazz.getName();
    }

    public MediaLanguage() {
    }

    public MediaLanguage(Locale locale) {
        this.setLocale(locale);
    }

    public MediaLanguage(Locale locale, String translator) {
        this.setLocale(locale);
        this.setTranslator(translator);
    }

    public MediaLanguage(Locale locale, String translator, LanguageCategory promptsCategory, LanguageCategory grammarsCategory) {
        this.setLocale(locale);
        this.setTranslator(translator);
        this.setPromptsCategory(promptsCategory);
        this.setGrammarsCategory(grammarsCategory);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? DEFAULT_LOCALE : locale;
    }

    public String getTranslator() {
        return this.translator;
    }

    public void setTranslator(String translator) {
        this.translator = translator == null || translator.length() == 0 ? DEFAULT_TRANSLATOR : translator;
    }

    public LanguageCategory getPromptsCategory() {
        return this.promptsCategory;
    }

    public LanguageCategory getGrammarsCategory() {
        return this.grammarsCategory;
    }

    public void setPromptsCategory(LanguageCategory category) {
        this.promptsCategory = category == null ? new LanguageCategory() : category;
    }

    public void setGrammarsCategory(LanguageCategory category) {
        this.grammarsCategory = category == null ? new LanguageCategory() : category;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaLanguage lp = (MediaLanguage)obj;
        return this.locale.equals(lp.locale) && this.translator.equals(lp.translator) && this.promptsCategory.equals(lp.promptsCategory) && this.grammarsCategory.equals(lp.grammarsCategory);
    }

    public int hashCode() {
        return this.locale.hashCode() ^ this.translator.hashCode() ^ this.promptsCategory.hashCode() ^ this.grammarsCategory.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(locale=" + this.locale + ",translator='" + this.translator + "',prompts=" + this.promptsCategory + ",grammars=" + this.grammarsCategory + ')';
    }
}

