/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.library.LibraryPromptTranslation;

public class LibraryPromptEntry {
    public static final String DEFAULT_NAME = "Untitled Translation";
    private String name;
    private Map translations = new LinkedHashMap();

    public LibraryPromptEntry(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public LibraryPromptEntry(String name, LibraryPromptTranslation[] translations) {
        this(name);
        if (translations != null) {
            int i = 0;
            while (i < translations.length) {
                this.addTranslation(translations[i]);
                ++i;
            }
        }
    }

    public LibraryPromptEntry(String name, Collection translations) {
        this(name, translations == null ? null : translations.toArray(new LibraryPromptTranslation[translations.size()]));
    }

    public String getName() {
        return this.name;
    }

    public LibraryPromptTranslation getTranslation(Locale locale) {
        return (LibraryPromptTranslation)this.translations.get(locale);
    }

    public boolean addTranslation(LibraryPromptTranslation translation) {
        if (translation == null || this.translations.containsKey(translation.getLocale())) {
            return false;
        }
        this.translations.put(translation.getLocale(), translation);
        return true;
    }

    public boolean removeTranslation(LibraryPromptTranslation translation) {
        if (translation == null || !this.translations.containsValue(translation)) {
            return false;
        }
        this.translations.remove(translation.getLocale());
        return true;
    }

    public Set getTranslationNames() {
        return new LinkedHashSet(this.translations.keySet());
    }

    public Collection getTranslations() {
        return new ArrayList(this.translations.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LibraryPromptEntry other = (LibraryPromptEntry)obj;
        return this.name.equals(other.name) && this.translations.equals(other.translations);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.translations.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',translations=" + this.translations.keySet() + ')';
    }
}

