/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.persona;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.GrammarVisitorAdapter;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;

public class PersonaGrammarEntry {
    public static final String DEFAULT_NAME = "Untitled Entry";
    public static final Grammar.Visitor VALID_GRAMMAR_TYPES = new GrammarVisitorAdapter(){

        public Object charactersGrammar(CharactersGrammar charactersGrammar) {
            return charactersGrammar;
        }

        public Object fileGrammar(FileGrammar fileGrammar) {
            return fileGrammar;
        }

        public Object referenceGrammar(ReferenceGrammar referenceGrammar) {
            return referenceGrammar;
        }

        public Object textGrammar(TextGrammar textGrammar) {
            return textGrammar;
        }
    };
    private String name;
    private final List content = new ArrayList();

    public PersonaGrammarEntry(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public PersonaGrammarEntry(String name, List content) {
        this(name, content == null ? null : content.toArray(new Grammar[content.size()]));
    }

    public PersonaGrammarEntry(String name, Grammar[] content) {
        this(name);
        if (content != null) {
            int i = 0;
            while (i < content.length) {
                this.add(content[i]);
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean add(Grammar grammar) {
        if (grammar == null) {
            return false;
        }
        return this.content.add((Grammar)grammar.accept(VALID_GRAMMAR_TYPES));
    }

    public boolean insert(int index, Grammar grammar) {
        if (grammar == null) {
            return false;
        }
        this.content.add(index, (Grammar)grammar.accept(VALID_GRAMMAR_TYPES));
        return true;
    }

    public Grammar get(int index) {
        return (Grammar)this.content.get(index);
    }

    public List getAll() {
        return new ArrayList(this.content);
    }

    public int size() {
        return this.content.size();
    }

    public void moveUp(int index) {
        this.content.add(index - 1, this.content.remove(index));
    }

    public void moveDown(int index) {
        this.content.add(index + 1, this.content.remove(index));
    }

    public Grammar remove(int index) {
        return (Grammar)this.content.remove(index);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersonaGrammarEntry le = (PersonaGrammarEntry)obj;
        return this.name.equals(le.name) && this.content.equals(le.content);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.content.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',content=" + this.content + ")";
    }
}

