/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.persona;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarGroup;

public class PersonaGrammars {
    private Map groups = new LinkedHashMap();

    public PersonaGrammars() {
    }

    public PersonaGrammars(PersonaGrammarGroup[] groups) {
        if (groups != null) {
            int i = 0;
            while (i < groups.length) {
                this.addGroup(groups[i]);
                ++i;
            }
        }
    }

    public PersonaGrammars(Collection groups) {
        this(groups == null ? null : groups.toArray(new PersonaGrammarGroup[groups.size()]));
    }

    public PersonaGrammarGroup getGroup(String name) {
        return (PersonaGrammarGroup)this.groups.get(name);
    }

    public boolean addGroup(PersonaGrammarGroup group) {
        if (group == null || this.groups.containsKey(group.getName())) {
            return false;
        }
        this.groups.put(group.getName(), group);
        return true;
    }

    public boolean removeGroup(PersonaGrammarGroup group) {
        if (group == null || !this.groups.containsValue(group)) {
            return false;
        }
        this.groups.remove(group.getName());
        return true;
    }

    public Set getGroupNames() {
        return new LinkedHashSet(this.groups.keySet());
    }

    public Collection getGroups() {
        return new ArrayList(this.groups.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.groups.equals(((PersonaGrammars)obj).groups);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.groups.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(groups=" + this.groups.keySet() + ')';
    }
}

