/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.prompts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.framework.media.prompts.Prompt;

public class VariablePrompt
extends Prompt {
    public static final int TYPE_CHARACTERS = 0;
    public static final int TYPE_DIGITS = 1;
    public static final int TYPE_MONEY = 2;
    public static final int TYPE_NUMBER = 3;
    public static final int TYPE_TEXT = 4;
    private static List TYPE_NAMES = Collections.unmodifiableList(Arrays.asList("Characters", "digits", "Money", "Number", "Text"));
    private String variable = "";
    private int type = 4;

    public VariablePrompt() {
    }

    public VariablePrompt(String variable) {
        this.setVariable(variable);
    }

    public VariablePrompt(String variable, int type) {
        this.setVariable(variable);
        this.setType(type);
    }

    public static String getTypeName(int type) {
        return (String)TYPE_NAMES.get(type);
    }

    public static int getTypeByName(String typeName) {
        return TYPE_NAMES.indexOf(typeName);
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable == null ? "" : variable;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type < 0 || type >= TYPE_NAMES.size() ? 4 : type;
    }

    public Object accept(Prompt.Visitor visitor) {
        return visitor.variablePrompt(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VariablePrompt other = (VariablePrompt)obj;
        return this.variable.equals(other.variable) && this.type == other.type;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.variable.hashCode() ^ this.type;
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(variable='" + this.variable + "',type=" + VariablePrompt.getTypeName(this.type) + ")";
    }
}

