/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingDialog;
import org.eclipse.vtp.framework.media.binding.BindingFieldDialog;
import org.eclipse.vtp.framework.media.binding.BindingGrammarEntry;
import org.eclipse.vtp.framework.media.binding.BindingGrammarTranslation;
import org.eclipse.vtp.framework.media.binding.BindingGroup;
import org.eclipse.vtp.framework.media.binding.BindingMenuDialog;
import org.eclipse.vtp.framework.media.binding.BindingMessageDialog;
import org.eclipse.vtp.framework.media.binding.BindingModule;
import org.eclipse.vtp.framework.media.binding.BindingPromptEntry;
import org.eclipse.vtp.framework.media.binding.BindingPromptTranslation;
import org.eclipse.vtp.framework.media.binding.BindingRecordingDialog;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.GrammarSolutionCollector;
import org.eclipse.vtp.framework.media.util.GrammarSolutionOutput;
import org.eclipse.vtp.framework.media.util.PromptSolutionCollector;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public abstract class BindingIndex {
    private MediaBinding binding = null;
    private BrandLibraryIndex brand = null;

    public BindingIndex() {
    }

    public BindingIndex(MediaBinding binding, BrandLibraryIndex brand) {
        this.setBinding(binding);
        this.setBrand(brand);
    }

    public void setBinding(MediaBinding binding) {
        this.binding = binding;
    }

    public MediaBinding getBinding() {
        return this.binding;
    }

    public void setBrand(BrandLibraryIndex brand) {
        this.brand = brand;
    }

    public BrandLibraryIndex getBrand() {
        return this.brand;
    }

    public Locale[] getLocales() {
        return this.brand.getLocales();
    }

    public Locale getDefaultLocale() {
        return this.brand.getDefaultLocale();
    }

    public Set indexDialogs(String module, String instance) {
        HashSet tmp = new HashSet();
        if (this.getBinding() != null && this.getBinding().getModule(module) != null && this.getBinding().getModule(module).getGroup(instance) != null) {
            tmp.addAll(this.getBinding().getModule(module).getGroup(instance).getDialogs());
        }
        return tmp;
    }

    public Map indexAvailablePrompts(String excludeName, String excludeContainer) {
        return this.brand.indexAvailablePrompts(excludeName, excludeContainer);
    }

    public Map indexAvailableGrammars(String excludeName, String excludeContainer) {
        return this.brand.indexAvailablePrompts(excludeName, excludeContainer);
    }

    public List solvePrompt(Prompt prompt, String module, String instance) {
        PromptSolutionCollector collector = new PromptSolutionCollector();
        this.solvePrompt(prompt, module, instance, collector);
        return collector.getResults();
    }

    public List solvePrompt(Prompt prompt, String module, String instance, Locale locale) {
        PromptSolutionCollector collector = new PromptSolutionCollector();
        this.solvePrompt(prompt, module, instance, collector, locale);
        return collector.getResults();
    }

    public boolean solvePrompt(Prompt prompt, String module, String instance, PromptSolutionOutput output) {
        return this.solvePrompt(prompt, module, instance, output, this.getDefaultLocale());
    }

    public boolean solvePrompt(Prompt prompt, String module, String instance, PromptSolutionOutput output, Locale locale) {
        return this.solvePrompt(prompt, module, instance, "", output, locale);
    }

    public boolean solvePrompt(Prompt prompt, String module, String instance, String dialog, PromptSolutionOutput output, Locale locale) {
        return prompt.accept(new PromptSolver(output, module, instance, dialog, locale)) == Boolean.TRUE;
    }

    public List solveGrammar(Grammar grammar, String module, String instance) {
        GrammarSolutionCollector collector = new GrammarSolutionCollector();
        this.solveGrammar(grammar, module, instance, collector);
        return collector.getResults();
    }

    public List solveGrammar(Grammar grammar, String module, String instance, Locale locale) {
        GrammarSolutionCollector collector = new GrammarSolutionCollector();
        this.solveGrammar(grammar, module, instance, collector, locale);
        return collector.getResults();
    }

    public boolean solveGrammar(Grammar grammar, String module, String instance, GrammarSolutionOutput output) {
        return this.solveGrammar(grammar, module, instance, output, this.getDefaultLocale());
    }

    public boolean solveGrammar(Grammar grammar, String module, String instance, GrammarSolutionOutput output, Locale locale) {
        return this.solveGrammar(grammar, module, instance, "", output, locale);
    }

    public boolean solveGrammar(Grammar grammar, String module, String instance, String dialog, GrammarSolutionOutput output, Locale locale) {
        return grammar.accept(new GrammarSolver(output, module, instance, dialog, locale)) == Boolean.TRUE;
    }

    public boolean hasAudioFile(String path) {
        return this.brand.hasAudioFile(path);
    }

    public boolean hasAudioFile(String path, Locale locale) {
        return this.brand.hasAudioFile(path, locale);
    }

    public String getAlternateText(String filePath) {
        return this.brand.getAlternateText(filePath);
    }

    public String getAlternateText(String filePath, Locale locale) {
        return this.brand.getAlternateText(filePath, locale);
    }

    protected abstract boolean solveUnresolvedPrompt(ReferencePrompt var1, String var2, String var3, String var4, PromptSolutionOutput var5, Locale var6);

    protected abstract boolean solveUnresolvedGrammar(ReferenceGrammar var1, String var2, String var3, String var4, GrammarSolutionOutput var5, Locale var6);

    private class GrammarSolver
    implements Grammar.Visitor {
        private GrammarSolutionOutput output;
        private String module;
        private String instance;
        private String dialog;
        private Locale locale;

        public GrammarSolver(GrammarSolutionOutput output, String module, String instance, String dialog, Locale locale) {
            this.output = output;
            this.module = module;
            this.instance = instance;
            this.dialog = dialog;
            this.locale = locale;
        }

        public Object charactersGrammar(CharactersGrammar charactersGrammar) {
            this.output.writeCharacters(charactersGrammar.getCharacters());
            return Boolean.TRUE;
        }

        public Object fileGrammar(FileGrammar fileGrammar) {
            return BindingIndex.this.brand.solveGrammar(fileGrammar, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object referenceGrammar(ReferenceGrammar referenceGrammar) {
            BindingGroup grp;
            BindingModule mod;
            if ((referenceGrammar.getContainer().length() == 0 || "Local Grammars".equals(referenceGrammar.getContainer())) && (mod = BindingIndex.this.binding.getModule(this.module)) != null && (grp = mod.getGroup(this.instance)) != null) {
                BindingDialog dlg = grp.getDialog(this.dialog);
                BindingGrammarEntry entry = null;
                if (referenceGrammar.getName().startsWith("custom:")) {
                    entry = dlg.getCustomGrammar(referenceGrammar.getName().substring("custom:".length()));
                } else if (dlg instanceof BindingFieldDialog) {
                    if ("field".equals(referenceGrammar.getName())) {
                        entry = ((BindingFieldDialog)dlg).getFieldGrammar();
                    } else if ("confirmation-accept".equals(referenceGrammar.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmAcceptGrammar();
                    } else if ("confirmation-reject".equals(referenceGrammar.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmRejectGrammar();
                    }
                } else if (dlg instanceof BindingMenuDialog) {
                    if ("confirmation-accept".equals(referenceGrammar.getName())) {
                        entry = ((BindingMenuDialog)dlg).getConfirmAcceptGrammar();
                    } else if ("confirmation-reject".equals(referenceGrammar.getName())) {
                        entry = ((BindingMenuDialog)dlg).getConfirmRejectGrammar();
                    } else if (referenceGrammar.getName().startsWith("option:")) {
                        entry = ((BindingMenuDialog)dlg).getOptionGrammar(referenceGrammar.getName().substring("option:".length()));
                    }
                }
                if (entry != null) {
                    BindingGrammarTranslation trans = entry.getTranslation(this.locale);
                    if (trans == null || trans.getAll().isEmpty()) {
                        trans = entry.getTranslation(new Locale(this.locale.getLanguage(), this.locale.getCountry()));
                    }
                    if (trans == null || trans.getAll().isEmpty()) {
                        trans = entry.getTranslation(new Locale(this.locale.getLanguage()));
                    }
                    if (trans != null) {
                        boolean result = false;
                        Iterator i = trans.getAll().iterator();
                        while (i.hasNext()) {
                            result |= ((Grammar)i.next()).accept(this) == Boolean.TRUE;
                        }
                        if (result) {
                            return Boolean.TRUE;
                        }
                    }
                }
            }
            return BindingIndex.this.solveUnresolvedGrammar(referenceGrammar, this.module, this.instance, this.dialog, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object textGrammar(TextGrammar textGrammar) {
            this.output.writeText(textGrammar.getContent());
            return Boolean.TRUE;
        }
    }

    private class PromptSolver
    implements Prompt.Visitor {
        private PromptSolutionOutput output;
        private String module;
        private String instance;
        private String dialog;
        private Locale locale;

        public PromptSolver(PromptSolutionOutput output, String module, String instance, String dialog, Locale locale) {
            this.output = output;
            this.module = module;
            this.instance = instance;
            this.dialog = dialog;
            this.locale = locale;
        }

        public Object charactersPrompt(CharactersPrompt charactersPrompt) {
            return BindingIndex.this.brand.solvePrompt(charactersPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object datePrompt(DatePrompt datePrompt) {
            return BindingIndex.this.brand.solvePrompt(datePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object dateTimePrompt(DateTimePrompt dateTimePrompt) {
            return BindingIndex.this.brand.solvePrompt(dateTimePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object digitsPrompt(DigitsPrompt digitsPrompt) {
            return BindingIndex.this.brand.solvePrompt(digitsPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object filePrompt(FilePrompt filePrompt) {
            return BindingIndex.this.brand.solvePrompt(filePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object moneyPrompt(MoneyPrompt moneyPrompt) {
            return BindingIndex.this.brand.solvePrompt(moneyPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object numberPrompt(NumberPrompt numberPrompt) {
            return BindingIndex.this.brand.solvePrompt(numberPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object ordinalPrompt(OrdinalPrompt ordinalPrompt) {
            return BindingIndex.this.brand.solvePrompt(ordinalPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object referencePrompt(ReferencePrompt referencePrompt) {
            BindingGroup grp;
            BindingModule mod;
            if (referencePrompt.getContainer().length() == 0 && (mod = BindingIndex.this.binding.getModule(this.module)) != null && (grp = mod.getGroup(this.instance)) != null) {
                BindingDialog dlg = grp.getDialog(this.dialog);
                BindingPromptEntry entry = null;
                if (referencePrompt.getName().startsWith("custom:")) {
                    entry = dlg.getCustomPrompt(referencePrompt.getName().substring("custom:".length()));
                } else if (dlg instanceof BindingMessageDialog) {
                    if ("message".equals(referencePrompt.getName())) {
                        entry = ((BindingMessageDialog)dlg).getMessagePrompt();
                    }
                } else if (dlg instanceof BindingFieldDialog) {
                    if ("field".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getFieldPrompt();
                    } else if ("confirmation".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmPrompt();
                    } else if ("confirmation-accept".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmAcceptPrompt();
                    } else if ("confirmation-reject".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmRejectPrompt();
                    } else if ("no-input".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getNoInputPrompt();
                    } else if ("no-match".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getNoMatchPrompt();
                    }
                } else if (dlg instanceof BindingMenuDialog) {
                    if ("menu".equals(referencePrompt.getName())) {
                        entry = ((BindingMenuDialog)dlg).getMenuPrompt();
                    } else if ("confirmation".equals(referencePrompt.getName())) {
                        entry = ((BindingMenuDialog)dlg).getConfirmPrompt();
                    } else if ("confirmation-accept".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmAcceptPrompt();
                    } else if ("confirmation-reject".equals(referencePrompt.getName())) {
                        entry = ((BindingFieldDialog)dlg).getConfirmRejectPrompt();
                    } else if ("no-input".equals(referencePrompt.getName())) {
                        entry = ((BindingMenuDialog)dlg).getNoInputPrompt();
                    } else if ("no-match".equals(referencePrompt.getName())) {
                        entry = ((BindingMenuDialog)dlg).getNoMatchPrompt();
                    } else if (referencePrompt.getName().startsWith("option:")) {
                        entry = ((BindingMenuDialog)dlg).getOptionPrompt(referencePrompt.getName().substring("option:".length()));
                    }
                } else if (dlg instanceof BindingRecordingDialog) {
                    if ("recording".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getRecordingPrompt();
                    } else if ("no-input".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getNoInputPrompt();
                    } else if ("no-match".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getNoMatchPrompt();
                    }
                } else if (dlg instanceof BindingRecordingDialog) {
                    if ("recording".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getRecordingPrompt();
                    } else if ("no-input".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getNoInputPrompt();
                    } else if ("no-match".equals(referencePrompt.getName())) {
                        entry = ((BindingRecordingDialog)dlg).getNoMatchPrompt();
                    }
                }
                if (entry != null) {
                    BindingPromptTranslation trans = entry.getTranslation(this.locale);
                    if (trans == null || trans.getAll().isEmpty()) {
                        trans = entry.getTranslation(new Locale(this.locale.getLanguage(), this.locale.getCountry()));
                    }
                    if (trans == null || trans.getAll().isEmpty()) {
                        trans = entry.getTranslation(new Locale(this.locale.getLanguage()));
                    }
                    if (trans != null) {
                        boolean result = false;
                        Iterator i = trans.getAll().iterator();
                        while (i.hasNext()) {
                            Prompt p = (Prompt)i.next();
                            result |= p.accept(this) == Boolean.TRUE;
                        }
                        if (result) {
                            return Boolean.TRUE;
                        }
                    }
                }
            }
            return BindingIndex.this.solveUnresolvedPrompt(referencePrompt, this.module, this.instance, this.dialog, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object textPrompt(TextPrompt textPrompt) {
            return BindingIndex.this.brand.solvePrompt(textPrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object timePrompt(TimePrompt timePrompt) {
            System.out.println("Time Prompt: " + timePrompt);
            return BindingIndex.this.brand.solvePrompt(timePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object variablePrompt(VariablePrompt variablePrompt) {
            return BindingIndex.this.brand.solvePrompt(variablePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

