/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.DefaultBrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.GrammarSolutionOutput;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public class CustomBrandLibraryIndex
extends BrandLibraryIndex {
    private DefaultBrandLibraryIndex parentIndex = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.media.util.CustomBrandLibraryIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CustomBrandLibraryIndex() {
    }

    public CustomBrandLibraryIndex(MediaLibrary library, MediaFiles files, String filePrefix, DefaultBrandLibraryIndex parentIndex) {
        super(library, files, filePrefix);
        this.setParentIndex(parentIndex);
    }

    public void setParentIndex(DefaultBrandLibraryIndex parentIndex) {
        this.parentIndex = parentIndex;
    }

    public DefaultBrandLibraryIndex getParentIndex() {
        return this.parentIndex;
    }

    public Collection getPromptEntryNames() {
        Collection all = super.getPromptEntryNames();
        all.addAll(this.parentIndex.getPromptEntryNames());
        return all;
    }

    public LibraryPromptEntry getPromptEntry(String name) {
        LibraryPromptEntry entry = super.getPromptEntry(name);
        if (entry == null) {
            entry = this.parentIndex.getPromptEntry(name);
        }
        return entry;
    }

    public Locale[] getLocales() {
        return this.parentIndex.getLocales();
    }

    public Locale getDefaultLocale() {
        return this.parentIndex.getDefaultLocale();
    }

    public PersonaIndex getPersonaIndex(Locale locale) {
        return this.parentIndex.getPersonaIndex(locale);
    }

    public Map indexAvailablePrompts(String excludeName, String excludeContainer) {
        Map results = this.parentIndex.indexAvailablePrompts(excludeName, excludeContainer);
        List list = (List)results.get("");
        Iterator i = this.getLibrary().getPrompts().getEntries().iterator();
        while (i.hasNext()) {
            LibraryPromptEntry entry = (LibraryPromptEntry)i.next();
            if (entry.getName().equals(excludeName) || list.contains(entry.getName())) continue;
            list.add(entry.getName());
        }
        return results;
    }

    public Map indexAvailableGrammars(String excludeName, String excludeContainer) {
        Map results = this.parentIndex.indexAvailableGrammars(excludeName, excludeContainer);
        List list = (List)results.get("");
        Iterator i = this.getLibrary().getGrammars().getEntries().iterator();
        while (i.hasNext()) {
            LibraryGrammarEntry entry = (LibraryGrammarEntry)i.next();
            if (entry.getName().equals(excludeName) || list.contains(entry.getName())) continue;
            list.add(entry.getName());
        }
        return results;
    }

    public boolean hasAudioFile(String path, Locale locale) {
        return super.hasAudioFile(path, locale) || this.parentIndex.hasAudioFile(path, locale);
    }

    public String getAlternateText(String filePath, Locale locale) {
        String string = super.getAlternateText(filePath, locale);
        if (!$assertionsDisabled && string.length() != 0) {
            string = this.parentIndex.getAlternateText(filePath, locale);
            throw new AssertionError((Object)string);
        }
        return string;
    }

    protected boolean solveUnresolvedPrompt(ReferencePrompt prompt, PromptSolutionOutput output, Locale locale) {
        return this.parentIndex.solvePrompt(prompt, output, locale);
    }

    protected boolean solveUnresolvedGrammar(ReferenceGrammar grammar, GrammarSolutionOutput output, Locale locale) {
        return this.parentIndex.solveGrammar(grammar, output, locale);
    }
}

