/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.files.MediaFile;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.files.MediaObject;
import org.eclipse.vtp.framework.media.language.DefaultTranslator;
import org.eclipse.vtp.framework.media.language.LanguageEntry;
import org.eclipse.vtp.framework.media.language.LanguageGroup;
import org.eclipse.vtp.framework.media.language.MediaLanguage;
import org.eclipse.vtp.framework.media.language.Translator;
import org.eclipse.vtp.framework.media.language.TranslatorOutput;
import org.eclipse.vtp.framework.media.persona.MediaPersona;
import org.eclipse.vtp.framework.media.persona.PersonaPromptEntry;
import org.eclipse.vtp.framework.media.persona.PersonaPromptGroup;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.util.PromptSolutionCollector;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public class PersonaIndex {
    private Locale locale = Locale.getDefault();
    private MediaPersona persona = null;
    private MediaFiles files = null;
    private MediaLanguage language = null;
    private Translator translator = new DefaultTranslator();
    private String filePrefix = "";

    public PersonaIndex() {
    }

    public PersonaIndex(Locale locale, MediaPersona persona, MediaFiles files, MediaLanguage language, String filePrefix) {
        this.setLocale(locale);
        this.setPersona(persona);
        this.setFiles(files);
        this.setLanguage(language);
        this.setFilePrefix(filePrefix);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public MediaPersona getPersona() {
        return this.persona;
    }

    public void setPersona(MediaPersona persona) {
        this.persona = persona;
    }

    public MediaFiles getFiles() {
        return this.files;
    }

    public void setFiles(MediaFiles files) {
        this.files = files;
    }

    public MediaLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(MediaLanguage language) {
        this.setLanguage(language, this.getClass().getClassLoader());
    }

    public void setLanguage(MediaLanguage language, ClassLoader cl) {
        this.language = language;
        if (language == null) {
            this.translator = new DefaultTranslator();
        } else {
            try {
                this.translator = (Translator)cl.loadClass(language.getTranslator()).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.translator = new DefaultTranslator();
            }
        }
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix == null ? "" : filePrefix;
    }

    public Set getPromptGroupNames() {
        return this.language == null ? Collections.EMPTY_SET : this.language.getPromptsCategory().getGroupNames();
    }

    public Set getPromptEntryNames(String groupName) {
        return this.language == null ? Collections.EMPTY_SET : this.language.getPromptsCategory().getGroup(groupName).getEntryNames();
    }

    public String getPromptEntryDefault(String groupName, String entryName) {
        return this.language == null ? "" : this.language.getPromptsCategory().getGroup(groupName).getEntry(entryName).getContent();
    }

    public Map indexAvailablePrompts(String excludeGroup, String excludeName) {
        HashMap results = new HashMap();
        if (this.language != null) {
            Iterator i = this.language.getPromptsCategory().getGroups().iterator();
            while (i.hasNext()) {
                LanguageGroup group = (LanguageGroup)i.next();
                ArrayList<String> list = new ArrayList<String>();
                Iterator j = group.getEntries().iterator();
                while (j.hasNext()) {
                    LanguageEntry entry = (LanguageEntry)j.next();
                    if (group.getName().equals(excludeGroup) && entry.getName().equals(excludeName)) continue;
                    list.add(entry.getName());
                }
                results.put(group.getName(), list);
            }
        }
        return results;
    }

    public List solvePrompt(Prompt prompt) {
        PromptSolutionCollector collector = new PromptSolutionCollector();
        this.solvePrompt(prompt, collector);
        return collector.getResults();
    }

    public boolean solvePrompt(Prompt prompt, PromptSolutionOutput output) {
        return prompt.accept(new PromptSolver(output)) == Boolean.TRUE;
    }

    public Set getGrammarGroupNames() {
        return this.language == null ? Collections.EMPTY_SET : this.language.getGrammarsCategory().getGroupNames();
    }

    public Set getGrammarEntryNames(String groupName) {
        return this.language == null ? Collections.EMPTY_SET : this.language.getGrammarsCategory().getGroup(groupName).getEntryNames();
    }

    public boolean hasAudioFile(String path) {
        if (this.files == null) {
            return false;
        }
        return (this.filePrefix.length() > 0 && path.startsWith(this.filePrefix) ? this.files.find(path.substring(this.filePrefix.length())) : this.files.find(path)) != null;
    }

    public String getAlternateText(String filePath) {
        if (this.files != null) {
            MediaObject obj = this.files.find(filePath);
            if (obj instanceof MediaFile) {
                return ((MediaFile)obj).getAlternateText();
            }
            if (filePath.startsWith(this.filePrefix) && (obj = this.files.find(filePath.substring(this.filePrefix.length()))) instanceof MediaFile) {
                return ((MediaFile)obj).getAlternateText();
            }
        }
        return "";
    }

    private class PromptSolver
    implements Prompt.Visitor,
    TranslatorOutput {
        private PromptSolutionOutput output;

        public PromptSolver(PromptSolutionOutput output) {
            this.output = output;
        }

        public Object charactersPrompt(CharactersPrompt charactersPrompt) {
            this.characters(charactersPrompt.getCharacters());
            return Boolean.TRUE;
        }

        public Object datePrompt(DatePrompt datePrompt) {
            PersonaIndex.this.translator.translateDate(datePrompt.getValue(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object dateTimePrompt(DateTimePrompt dateTimePrompt) {
            PersonaIndex.this.translator.translateDateTime(dateTimePrompt.getValue(), dateTimePrompt.isShowingTimeZone(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object digitsPrompt(DigitsPrompt digitsPrompt) {
            PersonaIndex.this.translator.translateDigits(digitsPrompt.getContent(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object filePrompt(FilePrompt filePrompt) {
            this.audioFile(filePrompt.getPath());
            return Boolean.TRUE;
        }

        public Object moneyPrompt(MoneyPrompt moneyPrompt) {
            PersonaIndex.this.translator.translateMoney(moneyPrompt.getValue(), moneyPrompt.getCurrency(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object numberPrompt(NumberPrompt numberPrompt) {
            PersonaIndex.this.translator.translateNumber(numberPrompt.getValue(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object ordinalPrompt(OrdinalPrompt ordinalPrompt) {
            PersonaIndex.this.translator.translateOrdinal(ordinalPrompt.getValue(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object referencePrompt(ReferencePrompt referencePrompt) {
            LanguageEntry entry;
            LanguageGroup lgroup;
            PersonaPromptEntry entry2;
            PersonaPromptGroup group = PersonaIndex.this.persona.getPrompts().getGroup(referencePrompt.getContainer());
            if (group != null && (entry2 = group.getEntry(referencePrompt.getName())) != null) {
                boolean result = false;
                Iterator i = entry2.getAll().iterator();
                while (i.hasNext()) {
                    result |= ((Prompt)i.next()).accept(this) == Boolean.TRUE;
                }
                if (result) {
                    return Boolean.TRUE;
                }
            }
            if (PersonaIndex.this.language != null && (lgroup = PersonaIndex.this.language.getPromptsCategory().getGroup(referencePrompt.getContainer())) != null && (entry = lgroup.getEntry(referencePrompt.getName())) != null) {
                this.text(entry.getContent());
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object textPrompt(TextPrompt textPrompt) {
            this.text(textPrompt.getContent());
            return Boolean.TRUE;
        }

        public Object timePrompt(TimePrompt timePrompt) {
            PersonaIndex.this.translator.translateTime(timePrompt.getValue(), timePrompt.isShowingTimeZone(), PersonaIndex.this.locale, this);
            return Boolean.TRUE;
        }

        public Object variablePrompt(VariablePrompt variablePrompt) {
            this.output.writeVariable(variablePrompt.getVariable(), variablePrompt.getType());
            return Boolean.TRUE;
        }

        public void audioFile(String path) {
            this.output.writeFile(path.startsWith(PersonaIndex.this.filePrefix) ? path : String.valueOf(PersonaIndex.this.filePrefix) + path);
        }

        public void characters(String characters) {
            int i = 0;
            while (i < characters.length()) {
                PersonaIndex.this.translator.translateLetter(characters.charAt(i), PersonaIndex.this.getLocale(), this);
                ++i;
            }
        }

        public void prompt(String name, String container) {
            this.referencePrompt(new ReferencePrompt(name, container));
        }

        public void text(String text) {
            this.output.writeText(text);
        }
    }
}

