/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingDialog;
import org.eclipse.vtp.framework.media.binding.BindingFieldDialog;
import org.eclipse.vtp.framework.media.binding.BindingGrammarEntry;
import org.eclipse.vtp.framework.media.binding.BindingGrammarTranslation;
import org.eclipse.vtp.framework.media.binding.BindingGroup;
import org.eclipse.vtp.framework.media.binding.BindingInputDialog;
import org.eclipse.vtp.framework.media.binding.BindingMenuDialog;
import org.eclipse.vtp.framework.media.binding.BindingMessageDialog;
import org.eclipse.vtp.framework.media.binding.BindingModule;
import org.eclipse.vtp.framework.media.binding.BindingPromptEntry;
import org.eclipse.vtp.framework.media.binding.BindingPromptTranslation;
import org.eclipse.vtp.framework.media.binding.BindingRecordingDialog;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.eclipse.vtp.framework.media.xml.GrammarDecoder;
import org.eclipse.vtp.framework.media.xml.PromptDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BindingDecoder
extends AbstractDecoder {
    private static final Set ENTRY_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("characters", "date", "date-time", "digits", "file", "money", "number", "ordinal", "reference", "text", "time", "variable")));
    private final PromptDecoder promptDecoder = new PromptDecoder("brand");
    private final GrammarDecoder grammarDecoder = new GrammarDecoder("brand");
    private ContentHandler currentDecoder = null;
    private MediaBinding result = null;

    public void startDocument() throws SAXException {
        this.result = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0".equals(uri) && "descriptor".equals(localName) || "binding:descriptor".equals(qName)) {
            this.push(new MediaBinding());
        } else if ("".equals(uri)) {
            if ("module".equals(localName) || "module".equals(qName)) {
                this.push(new BindingModule(atts.getValue("name")));
            } else if ("shared".equals(localName) || "shared".equals(qName)) {
                this.push(new BindingGroup(""));
            } else if ("instance".equals(localName) || "instance".equals(qName)) {
                this.push(new BindingGroup(atts.getValue("name")));
            } else if ("message-dialog".equals(localName) || "message-dialog".equals(qName)) {
                this.push(new BindingMessageDialog(atts.getValue("name")));
                if (atts.getIndex("barge-in") >= 0) {
                    ((BindingMessageDialog)this.peek()).setBargeIn("true".equalsIgnoreCase(atts.getValue("barge-in")) ? Boolean.TRUE : Boolean.FALSE);
                }
            } else if ("field-dialog".equals(localName) || "field-dialog".equals(qName)) {
                this.push(new BindingFieldDialog(atts.getValue("name")));
                if (atts.getIndex("barge-in") >= 0) {
                    ((BindingFieldDialog)this.peek()).setBargeIn("true".equalsIgnoreCase(atts.getValue("barge-in")) ? Boolean.TRUE : Boolean.FALSE);
                }
                this.processInputDialog(atts);
            } else if ("menu-dialog".equals(localName) || "menu-dialog".equals(qName)) {
                this.push(new BindingMenuDialog(atts.getValue("name")));
                if (atts.getIndex("barge-in") >= 0) {
                    ((BindingMenuDialog)this.peek()).setBargeIn("true".equalsIgnoreCase(atts.getValue("barge-in")) ? Boolean.TRUE : Boolean.FALSE);
                }
                this.processInputDialog(atts);
            } else if ("recording-dialog".equals(localName) || "recording-dialog".equals(qName)) {
                this.push(new BindingRecordingDialog(atts.getValue("name")));
                if (atts.getIndex("final-silence") >= 0) {
                    ((BindingRecordingDialog)this.peek()).setFinalSilence(Long.parseLong(atts.getValue("final-silence")));
                }
                if (atts.getIndex("beep") >= 0) {
                    ((BindingRecordingDialog)this.peek()).setBeepOn("true".equalsIgnoreCase(atts.getValue("beep")) ? Boolean.TRUE : Boolean.FALSE);
                }
                if (atts.getIndex("max-time") >= 0) {
                    ((BindingRecordingDialog)this.peek()).setMaxTime(Long.parseLong(atts.getValue("max-time")));
                }
                if (atts.getIndex("dtmf-termination-on") >= 0) {
                    ((BindingRecordingDialog)this.peek()).setDtmfTermOn("true".equalsIgnoreCase(atts.getValue("dtmf-termination-on")) ? Boolean.TRUE : Boolean.FALSE);
                }
                this.processInputDialog(atts);
            } else if ("menu-option".equals(localName) || "menu-option".equals(qName)) {
                String id = atts.getValue("id");
                if (atts.getIndex("dtmf") >= 0) {
                    ((BindingMenuDialog)this.peek()).putOptionDtmfSetting(id, Integer.parseInt(atts.getValue("dtmf")));
                }
                if (atts.getIndex("silent") >= 0) {
                    ((BindingMenuDialog)this.peek()).putOptionSilentSetting(id, Boolean.valueOf(atts.getValue("silent")));
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", id);
                this.push(map);
            } else if ("custom".equals(localName) || "custom".equals(qName)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", atts.getValue("id"));
                Object[] objectArray = new Object[3];
                objectArray[0] = atts.getValue("id");
                this.push(objectArray);
            } else if ("message-prompt".equals(localName) || "message-prompt".equals(qName) || "field-prompt".equals(localName) || "field-prompt".equals(qName) || "menu-prompt".equals(localName) || "menu-prompt".equals(qName) || "recording-prompt".equals(localName) || "recording-prompt".equals(qName) || "menu-option-prompt".equals(localName) || "menu-option-prompt".equals(qName) || "no-input-prompt".equals(localName) || "no-input-prompt".equals(qName) || "no-match-prompt".equals(localName) || "no-match-prompt".equals(qName) || "confirm-prompt".equals(localName) || "confirm-prompt".equals(qName) || "confirm-accept-prompt".equals(localName) || "confirm-accept-prompt".equals(qName) || "confirm-reject-prompt".equals(localName) || "confirm-reject-prompt".equals(qName) || "prompt".equals(qName)) {
                this.push(new BindingPromptEntry(atts.getValue("name")));
            } else if ("field-grammar".equals(localName) || "field-grammar".equals(qName) || "menu-option-grammar".equals(localName) || "menu-option-grammar".equals(qName) || "confirm-reject-grammar".equals(localName) || "confirm-reject-grammar".equals(qName) || "confirm-accept-grammar".equals(localName) || "confirm-accept-grammar".equals(qName) || "grammar".equals(qName)) {
                this.push(new BindingGrammarEntry(atts.getValue("name")));
            } else if ("translation".equals(localName) || "translation".equals(qName)) {
                this.push(this.peek() instanceof BindingPromptEntry ? new BindingPromptTranslation(this.decodeLocale(atts.getValue("xml:lang"))) : new BindingGrammarTranslation(this.decodeLocale(atts.getValue("xml:lang"))));
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder = this.peek() instanceof BindingPromptTranslation ? this.promptDecoder : this.grammarDecoder;
                this.currentDecoder.startElement(uri, localName, qName, atts);
            }
        }
    }

    private void processInputDialog(Attributes atts) {
        BindingInputDialog dlg = (BindingInputDialog)this.peek();
        if ("voice".equals(atts.getValue("input-mode"))) {
            dlg.setInputMode(1);
        } else if ("hybrid".equals(atts.getValue("input-mode"))) {
            dlg.setInputMode(2);
        } else {
            dlg.setInputMode(0);
        }
        if (atts.getIndex("initial-input-timeout") >= 0) {
            dlg.setInitialInputTimeout(Long.parseLong(atts.getValue("initial-input-timeout")));
        }
        if (dlg.getInputMode() != 1) {
            if (atts.getIndex("inter-digit-timeout") >= 0) {
                dlg.setInterDigitTimeout(Long.parseLong(atts.getValue("inter-digit-timeout")));
            }
            if (atts.getIndex("termination-timeout") >= 0) {
                dlg.setTerminationTimeout(Long.parseLong(atts.getValue("termination-timeout")));
            }
            if (atts.getIndex("termination-character") >= 0) {
                dlg.setTerminationCharacter(atts.getValue("termination-character").charAt(0));
            }
        }
        if (dlg.getInputMode() != 0) {
            if (atts.getIndex("speech-completion-timeout") >= 0) {
                dlg.setSpeechCompletionTimeout(Long.parseLong(atts.getValue("speech-completion-timeout")));
            }
            if (atts.getIndex("incomplete-speech-timeout") >= 0) {
                dlg.setIncompleteSpeechTimeout(Long.parseLong(atts.getValue("incomplete-speech-timeout")));
            }
            if (atts.getIndex("confidence-level") >= 0) {
                dlg.setConfidenceLevel(new BigDecimal(atts.getValue("confidence-level")));
            }
            if (atts.getIndex("maximum-speech-length") >= 0) {
                dlg.setMaximumSpeechLength(Integer.parseInt(atts.getValue("maximum-speech-length")));
            }
            if (atts.getIndex("maximum-n-best-results") >= 0) {
                dlg.setMaximumNBestResults(Integer.parseInt(atts.getValue("maximum-n-best-results")));
            }
            if (atts.getIndex("sensitivity") >= 0) {
                dlg.setSensitivity(new BigDecimal(atts.getValue("sensitivity")));
            }
            if (atts.getIndex("speed-vs-accuracy") >= 0) {
                dlg.setSpeedVsAccuracy(new BigDecimal(atts.getValue("speed-vs-accuracy")));
            }
        }
        if ("always".equals(atts.getValue("confirmation"))) {
            dlg.setConfirmMode(1);
        }
        if ("conditional".equals(atts.getValue("confirmation"))) {
            dlg.setConfirmMode(2);
        } else {
            dlg.setConfirmMode(0);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentDecoder == null) {
            super.characters(ch, start, length);
        } else {
            this.currentDecoder.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0".equals(uri) && "descriptor".equals(localName) || "binding:descriptor".equals(qName)) {
            this.result = (MediaBinding)this.pop();
        } else if ("".equals(uri)) {
            if ("module".equals(localName) || "module".equals(qName)) {
                BindingModule module = (BindingModule)this.pop();
                ((MediaBinding)this.peek()).addModule(module);
            } else if ("shared".equals(localName) || "shared".equals(qName) || "instance".equals(localName) || "instance".equals(qName)) {
                BindingGroup group = (BindingGroup)this.pop();
                ((BindingModule)this.peek()).addGroup(group);
            } else if ("message-dialog".equals(localName) || "message-dialog".equals(qName) || "field-dialog".equals(localName) || "field-dialog".equals(qName) || "menu-dialog".equals(localName) || "menu-dialog".equals(qName) || "recording-dialog".equals(localName) || "recording-dialog".equals(qName)) {
                BindingDialog dlg = (BindingDialog)this.pop();
                ((BindingGroup)this.peek()).addDialog(dlg);
            } else if ("message-prompt".equals(localName) || "message-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingMessageDialog)this.peek()).setMessagePrompt(entry);
            } else if ("field-prompt".equals(localName) || "field-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingFieldDialog)this.peek()).setFieldPrompt(entry);
            } else if ("menu-prompt".equals(localName) || "menu-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingMenuDialog)this.peek()).setMenuPrompt(entry);
            } else if ("recording-prompt".equals(localName) || "recording-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingRecordingDialog)this.peek()).setRecordingPrompt(entry);
            } else if ("no-input-prompt".equals(localName) || "no-input-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingInputDialog)this.peek()).setNoInputPrompt(entry);
            } else if ("no-match-prompt".equals(localName) || "no-match-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingInputDialog)this.peek()).setNoMatchPrompt(entry);
            } else if ("confirm-prompt".equals(localName) || "confirm-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingInputDialog)this.peek()).setConfirmPrompt(entry);
            } else if ("field-grammar".equals(localName) || "field-grammar".equals(qName)) {
                BindingGrammarEntry entry = (BindingGrammarEntry)this.pop();
                ((BindingFieldDialog)this.peek()).setFieldGrammar(entry);
            } else if ("menu-option".equals(localName) || "menu-option".equals(qName)) {
                Map map = (Map)this.pop();
                if (map.containsKey("menu-option-grammar")) {
                    ((BindingMenuDialog)this.peek()).putOptionGrammar((String)map.get("id"), (BindingGrammarEntry)map.get("menu-option-grammar"));
                }
                if (map.containsKey("menu-option-prompt")) {
                    ((BindingMenuDialog)this.peek()).putOptionPrompt((String)map.get("id"), (BindingPromptEntry)map.get("menu-option-prompt"));
                }
            } else if ("menu-option-grammar".equals(localName) || "menu-option-grammar".equals(qName)) {
                BindingGrammarEntry entry = (BindingGrammarEntry)this.pop();
                ((Map)this.peek()).put("menu-option-grammar", entry);
            } else if ("menu-option-prompt".equals(localName) || "menu-option-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((Map)this.peek()).put("menu-option-prompt", entry);
            } else if ("confirm-accept-prompt".equals(localName) || "confirm-accept-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingInputDialog)this.peek()).setConfirmAcceptPrompt(entry);
            } else if ("confirm-reject-prompt".equals(localName) || "confirm-reject-prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((BindingInputDialog)this.peek()).setConfirmRejectPrompt(entry);
            } else if ("confirm-accept-grammar".equals(localName) || "confirm-accept-grammar".equals(qName)) {
                BindingGrammarEntry entry = (BindingGrammarEntry)this.pop();
                ((BindingInputDialog)this.peek()).setConfirmAcceptGrammar(entry);
            } else if ("confirm-reject-grammar".equals(localName) || "confirm-reject-grammar".equals(qName)) {
                BindingGrammarEntry entry = (BindingGrammarEntry)this.pop();
                ((BindingInputDialog)this.peek()).setConfirmRejectGrammar(entry);
            } else if ("prompt".equals(localName) || "prompt".equals(qName)) {
                BindingPromptEntry entry = (BindingPromptEntry)this.pop();
                ((Object[])this.peek())[1] = entry;
            } else if ("grammar".equals(localName) || "grammar".equals(qName)) {
                BindingGrammarEntry entry = (BindingGrammarEntry)this.pop();
                ((Object[])this.peek())[2] = entry;
            } else if ("custom".equals(localName) || "custom".equals(qName)) {
                Object[] array = (Object[])this.pop();
                if (array[1] != null) {
                    ((BindingDialog)this.peek()).putCustomPrompt((String)array[0], (BindingPromptEntry)array[1]);
                }
                if (array[2] != null) {
                    ((BindingDialog)this.peek()).putCustomGrammar((String)array[0], (BindingGrammarEntry)array[2]);
                }
            } else if ("translation".equals(localName) || "translation".equals(qName)) {
                if (this.peek() instanceof BindingPromptTranslation) {
                    BindingPromptTranslation trans = (BindingPromptTranslation)this.pop();
                    ((BindingPromptEntry)this.peek()).addTranslation(trans);
                } else {
                    BindingGrammarTranslation trans = (BindingGrammarTranslation)this.pop();
                    ((BindingGrammarEntry)this.peek()).addTranslation(trans);
                }
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder.endElement(uri, localName, qName);
                if (this.peek() instanceof BindingPromptTranslation) {
                    ((BindingPromptTranslation)this.peek()).add(this.promptDecoder.getResult());
                } else {
                    ((BindingGrammarTranslation)this.peek()).add(this.grammarDecoder.getResult());
                }
                this.currentDecoder = null;
            }
        }
    }

    public MediaBinding getResult() {
        return this.result;
    }
}

