/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.vtp.framework.media.binding.BindingDialog;
import org.eclipse.vtp.framework.media.binding.BindingFieldDialog;
import org.eclipse.vtp.framework.media.binding.BindingGrammarEntry;
import org.eclipse.vtp.framework.media.binding.BindingGrammarTranslation;
import org.eclipse.vtp.framework.media.binding.BindingGroup;
import org.eclipse.vtp.framework.media.binding.BindingInputDialog;
import org.eclipse.vtp.framework.media.binding.BindingMenuDialog;
import org.eclipse.vtp.framework.media.binding.BindingMessageDialog;
import org.eclipse.vtp.framework.media.binding.BindingModule;
import org.eclipse.vtp.framework.media.binding.BindingPromptEntry;
import org.eclipse.vtp.framework.media.binding.BindingPromptTranslation;
import org.eclipse.vtp.framework.media.binding.BindingRecordingDialog;
import org.eclipse.vtp.framework.media.binding.MediaBinding;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.eclipse.vtp.framework.media.xml.GrammarEncoder;
import org.eclipse.vtp.framework.media.xml.PromptEncoder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BindingEncoder
extends AbstractEncoder {
    private final PromptEncoder promptEncoder = new PromptEncoder("brand");
    private final GrammarEncoder grammarEncoder = new GrammarEncoder("brand");
    private MediaBinding source = null;

    public BindingEncoder() {
    }

    public BindingEncoder(MediaBinding source) {
        this.setSource(source);
    }

    public void setSource(MediaBinding source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        if (this.source == null) {
            return;
        }
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        this.promptEncoder.setContentHandler(handler);
        this.grammarEncoder.setContentHandler(handler);
        AttributesImpl atts = new AttributesImpl();
        handler.startDocument();
        this.encodeStartNamespace("binding", "http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0", atts);
        handler.startElement("http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0", "descriptor", "binding:descriptor", atts);
        atts.clear();
        Iterator i = this.source.getModules().iterator();
        while (i.hasNext()) {
            BindingModule module = (BindingModule)i.next();
            atts.addAttribute("", "name", "name", "CDATA", module.getName());
            handler.startElement("", "module", "module", atts);
            atts.clear();
            if (module.getGroup("") != null) {
                handler.startElement("", "shared", "shared", atts);
                atts.clear();
                this.encodeDialogs(atts, module.getGroup("").getDialogs());
                handler.endElement("", "shared", "shared");
            }
            Iterator j = module.getGroups().iterator();
            while (j.hasNext()) {
                BindingGroup group = (BindingGroup)j.next();
                if (group.getName().length() == 0) continue;
                atts.addAttribute("", "name", "name", "CDATA", group.getName());
                handler.startElement("", "instance", "instance", atts);
                atts.clear();
                this.encodeDialogs(atts, group.getDialogs());
                handler.endElement("", "instance", "instance");
            }
            handler.endElement("", "module", "module");
        }
        handler.endElement("http://eclipse.org/vtp/xsd/openVXML/media/binding#1.0", "descriptor", "binding:descriptor");
        this.encodeEndNamespace("binding");
        handler.endDocument();
    }

    private void encodeDialogs(AttributesImpl atts, Collection dialogs) throws SAXException {
        Iterator i = dialogs.iterator();
        while (i.hasNext()) {
            BindingInputDialog menuDlg;
            BindingDialog dlg = (BindingDialog)i.next();
            atts.addAttribute("", "name", "name", "CDATA", dlg.getName());
            if (dlg.getBargeIn() != null) {
                atts.addAttribute("", "barge-in", "barge-in", "CDATA", String.valueOf(dlg.getBargeIn()));
            }
            if (dlg instanceof BindingMessageDialog) {
                this.getContentHandler().startElement("", "message-dialog", "message-dialog", atts);
                atts.clear();
                this.encodePromptEntry(atts, "message-prompt", ((BindingMessageDialog)dlg).getMessagePrompt());
                this.encodeCustomElements(atts, dlg);
                this.getContentHandler().endElement("", "message-dialog", "message-dialog");
                continue;
            }
            if (!(dlg instanceof BindingInputDialog)) continue;
            BindingInputDialog inputDlg = (BindingInputDialog)dlg;
            if (inputDlg.getInputMode() == 0) {
                atts.addAttribute("", "input-mode", "input-mode", "CDATA", "dtmf");
            } else if (inputDlg.getInputMode() == 1) {
                atts.addAttribute("", "input-mode", "input-mode", "CDATA", "voice");
            } else if (inputDlg.getInputMode() == 2) {
                atts.addAttribute("", "input-mode", "input-mode", "CDATA", "hybrid");
            }
            atts.addAttribute("", "initial-input-timeout", "initial-input-timeout", "CDATA", String.valueOf(inputDlg.getInitialInputTimeout()));
            if (inputDlg.getInputMode() != 1) {
                atts.addAttribute("", "inter-digit-timeout", "inter-digit-timeout", "CDATA", String.valueOf(inputDlg.getInterDigitTimeout()));
                atts.addAttribute("", "termination-timeout", "termination-timeout", "CDATA", String.valueOf(inputDlg.getTerminationTimeout()));
                if (inputDlg.getTerminationCharacter() != '\u0000') {
                    atts.addAttribute("", "termination-character", "termination-character", "CDATA", String.valueOf(inputDlg.getTerminationCharacter()));
                }
            }
            if (inputDlg.getInputMode() != 0) {
                atts.addAttribute("", "speech-completion-timeout", "speech-completion-timeout", "CDATA", String.valueOf(inputDlg.getSpeechCompletionTimeout()));
                atts.addAttribute("", "incomplete-speech-timeout", "incomplete-speech-timeout", "CDATA", String.valueOf(inputDlg.getIncompleteSpeechTimeout()));
                if (inputDlg.getConfidenceLevel() != null) {
                    atts.addAttribute("", "confidence-level", "confidence-level", "CDATA", inputDlg.getConfidenceLevel().toString());
                }
                atts.addAttribute("", "maximum-speech-length", "maximum-speech-length", "CDATA", String.valueOf(inputDlg.getMaximumSpeechLength()));
                atts.addAttribute("", "maximum-n-best-results", "maximum-n-best-results", "CDATA", String.valueOf(inputDlg.getMaximumNBestResults()));
                if (inputDlg.getSensitivity() != null) {
                    atts.addAttribute("", "sensitivity", "sensitivity", "CDATA", inputDlg.getSensitivity().toString());
                }
                if (inputDlg.getSpeedVsAccuracy() != null) {
                    atts.addAttribute("", "speed-vs-accuracy", "speed-vs-accuracy", "CDATA", inputDlg.getSpeedVsAccuracy().toString());
                }
            }
            boolean confirm = true;
            if (inputDlg.getConfirmMode() == 1) {
                atts.addAttribute("", "confirmation", "confirmation", "CDATA", "always");
            } else if (inputDlg.getConfirmMode() == 2) {
                atts.addAttribute("", "confirmation", "confirmation", "CDATA", "conditional");
            } else {
                confirm = false;
            }
            if (dlg instanceof BindingFieldDialog) {
                BindingFieldDialog fieldDlg = (BindingFieldDialog)dlg;
                this.getContentHandler().startElement("", "field-dialog", "field-dialog", atts);
                atts.clear();
                this.encodePromptEntry(atts, "field-prompt", fieldDlg.getFieldPrompt());
                this.encodeGrammarEntry(atts, "field-grammar", fieldDlg.getFieldGrammar());
                this.encodePromptEntry(atts, "no-input-prompt", fieldDlg.getNoInputPrompt());
                this.encodePromptEntry(atts, "no-match-prompt", fieldDlg.getNoMatchPrompt());
                if (confirm) {
                    this.encodePromptEntry(atts, "confirm-prompt", fieldDlg.getConfirmPrompt());
                    this.encodePromptEntry(atts, "confirm-accept-prompt", fieldDlg.getConfirmAcceptPrompt());
                    this.encodePromptEntry(atts, "confirm-reject-prompt", fieldDlg.getConfirmRejectPrompt());
                    this.encodeGrammarEntry(atts, "confirm-accept-grammar", fieldDlg.getConfirmAcceptGrammar());
                    this.encodeGrammarEntry(atts, "confirm-reject-grammar", fieldDlg.getConfirmRejectGrammar());
                }
                this.encodeCustomElements(atts, dlg);
                this.getContentHandler().endElement("", "field-dialog", "field-dialog");
                continue;
            }
            if (dlg instanceof BindingMenuDialog) {
                menuDlg = (BindingMenuDialog)dlg;
                this.getContentHandler().startElement("", "menu-dialog", "menu-dialog", atts);
                atts.clear();
                this.encodePromptEntry(atts, "menu-prompt", ((BindingMenuDialog)dlg).getMenuPrompt());
                Iterator j = ((BindingMenuDialog)dlg).getOptionIDs().iterator();
                while (j.hasNext()) {
                    Boolean silent;
                    String id = (String)j.next();
                    atts.addAttribute("", "id", "id", "CDATA", id);
                    Integer dtmf = ((BindingMenuDialog)dlg).getOptionDtmfSetting(id);
                    if (dtmf != null) {
                        atts.addAttribute("", "dtmf", "dtmf", "CDATA", dtmf.toString());
                    }
                    if ((silent = ((BindingMenuDialog)dlg).getOptionSilentSetting(id)) != null) {
                        atts.addAttribute("", "silent", "silent", "CDATA", silent.toString());
                    }
                    this.getContentHandler().startElement("", "menu-option", "menu-option", atts);
                    atts.clear();
                    this.encodePromptEntry(atts, "menu-option-prompt", ((BindingMenuDialog)dlg).getOptionPrompt(id));
                    this.encodeGrammarEntry(atts, "menu-option-grammar", ((BindingMenuDialog)dlg).getOptionGrammar(id));
                    this.getContentHandler().endElement("", "menu-option", "menu-option");
                }
                this.encodePromptEntry(atts, "no-input-prompt", menuDlg.getNoInputPrompt());
                this.encodePromptEntry(atts, "no-match-prompt", menuDlg.getNoMatchPrompt());
                if (confirm) {
                    this.encodePromptEntry(atts, "confirm-prompt", menuDlg.getConfirmPrompt());
                    this.encodePromptEntry(atts, "confirm-accept-prompt", menuDlg.getConfirmAcceptPrompt());
                    this.encodePromptEntry(atts, "confirm-reject-prompt", menuDlg.getConfirmRejectPrompt());
                    this.encodeGrammarEntry(atts, "confirm-accept-grammar", menuDlg.getConfirmAcceptGrammar());
                    this.encodeGrammarEntry(atts, "confirm-reject-grammar", menuDlg.getConfirmRejectGrammar());
                }
                this.encodeCustomElements(atts, dlg);
                this.getContentHandler().endElement("", "menu-dialog", "menu-dialog");
                continue;
            }
            if (!(dlg instanceof BindingRecordingDialog)) continue;
            menuDlg = (BindingRecordingDialog)dlg;
            atts.addAttribute("", "final-silence", "final-silence", "CDATA", String.valueOf(((BindingRecordingDialog)menuDlg).getFinalSilence()));
            atts.addAttribute("", "max-time", "max-time", "CDATA", String.valueOf(((BindingRecordingDialog)menuDlg).getMaxTime()));
            atts.addAttribute("", "beep", "beep", "CDATA", String.valueOf(((BindingRecordingDialog)menuDlg).isBeepOn() == null ? Boolean.TRUE : ((BindingRecordingDialog)menuDlg).isBeepOn()));
            atts.addAttribute("", "dtmf-termination-on", "dtmf-termination-on", "CDATA", String.valueOf(((BindingRecordingDialog)menuDlg).isDtmfTermOn() == null ? Boolean.TRUE : ((BindingRecordingDialog)menuDlg).isDtmfTermOn()));
            this.getContentHandler().startElement("", "recording-dialog", "recording-dialog", atts);
            atts.clear();
            this.encodePromptEntry(atts, "recording-prompt", ((BindingRecordingDialog)dlg).getRecordingPrompt());
            this.encodePromptEntry(atts, "no-input-prompt", menuDlg.getNoInputPrompt());
            this.encodePromptEntry(atts, "no-match-prompt", menuDlg.getNoMatchPrompt());
            if (confirm) {
                this.encodePromptEntry(atts, "confirm-prompt", menuDlg.getConfirmPrompt());
                this.encodePromptEntry(atts, "confirm-accept-prompt", menuDlg.getConfirmAcceptPrompt());
                this.encodePromptEntry(atts, "confirm-reject-prompt", menuDlg.getConfirmRejectPrompt());
                this.encodeGrammarEntry(atts, "confirm-accept-grammar", menuDlg.getConfirmAcceptGrammar());
                this.encodeGrammarEntry(atts, "confirm-reject-grammar", menuDlg.getConfirmRejectGrammar());
            }
            this.encodeCustomElements(atts, dlg);
            this.getContentHandler().endElement("", "recording-dialog", "recording-dialog");
        }
    }

    private void encodeCustomElements(AttributesImpl atts, BindingDialog dlg) throws SAXException {
        HashSet ids = new HashSet(dlg.getCustomPromptIDs());
        ids.addAll(dlg.getCustomGrammarIDs());
        Iterator j = ids.iterator();
        while (j.hasNext()) {
            String customId = (String)j.next();
            BindingPromptEntry customPrompt = dlg.getCustomPrompt(customId);
            BindingGrammarEntry customGrammar = dlg.getCustomGrammar(customId);
            if (customPrompt == null && customGrammar == null) continue;
            atts.addAttribute("", "id", "id", "CDATA", customId);
            this.getContentHandler().startElement("", "custom", "custom", atts);
            atts.clear();
            if (customPrompt != null) {
                this.encodePromptEntry(atts, "prompt", customPrompt);
            }
            if (customGrammar != null) {
                this.encodeGrammarEntry(atts, "grammar", customGrammar);
            }
            this.getContentHandler().endElement("", "custom", "custom");
        }
    }

    private void encodePromptEntry(AttributesImpl atts, String element, BindingPromptEntry entry) throws SAXException {
        if (entry == null) {
            return;
        }
        atts.addAttribute("", "name", "name", "CDATA", entry.getName());
        this.getContentHandler().startElement("", element, element, atts);
        atts.clear();
        Iterator j = entry.getTranslations().iterator();
        while (j.hasNext()) {
            BindingPromptTranslation trans = (BindingPromptTranslation)j.next();
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(trans.getLocale()));
            this.getContentHandler().startElement("", "translation", "translation", atts);
            atts.clear();
            Iterator k = trans.getAll().iterator();
            while (k.hasNext()) {
                this.promptEncoder.setSource((Prompt)k.next());
                this.promptEncoder.encode();
            }
            this.getContentHandler().endElement("", "translation", "translation");
        }
        this.getContentHandler().endElement("", element, element);
    }

    private void encodeGrammarEntry(AttributesImpl atts, String element, BindingGrammarEntry entry) throws SAXException {
        if (entry == null) {
            return;
        }
        atts.addAttribute("", "name", "name", "CDATA", entry.getName());
        this.getContentHandler().startElement("", element, element, atts);
        atts.clear();
        Iterator j = entry.getTranslations().iterator();
        while (j.hasNext()) {
            BindingGrammarTranslation trans = (BindingGrammarTranslation)j.next();
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(trans.getLocale()));
            this.getContentHandler().startElement("", "translation", "translation", atts);
            atts.clear();
            Iterator k = trans.getAll().iterator();
            while (k.hasNext()) {
                this.grammarEncoder.setSource((Grammar)k.next());
                this.grammarEncoder.encode();
            }
            this.getContentHandler().endElement("", "translation", "translation");
        }
        this.getContentHandler().endElement("", element, element);
    }
}

