/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GrammarDecoder
extends AbstractDecoder {
    private final String refernceContainer;
    private Grammar result = null;

    public GrammarDecoder(String refernceContainer) {
        this.refernceContainer = refernceContainer == null ? "" : refernceContainer;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.result = null;
        if ("characters".equals(localName) || "characters".equals(qName)) {
            this.push(new CharactersGrammar());
        } else if ("file".equals(localName) || "file".equals(qName)) {
            this.push(new FileGrammar());
        } else if ("reference".equals(localName) || "reference".equals(qName)) {
            this.push(new ReferenceGrammar("", atts.getValue(this.refernceContainer)));
        } else if ("text".equals(localName) || "text".equals(qName)) {
            this.push(new TextGrammar());
        } else {
            return;
        }
        this.startCollectingCharacters();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("characters".equals(localName) || "characters".equals(qName)) {
            ((CharactersGrammar)this.peek()).setCharacters(this.stopCollectingCharacters());
        } else if ("file".equals(localName) || "file".equals(qName)) {
            ((FileGrammar)this.peek()).setPath(this.stopCollectingCharacters());
        } else if ("reference".equals(localName) || "reference".equals(qName)) {
            ((ReferenceGrammar)this.peek()).setName(this.stopCollectingCharacters());
        } else if ("text".equals(localName) || "text".equals(qName)) {
            ((TextGrammar)this.peek()).setContent(this.stopCollectingCharacters());
        } else {
            return;
        }
        this.result = (Grammar)this.pop();
    }

    public Grammar getResult() {
        return this.result;
    }
}

