/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import org.eclipse.vtp.framework.media.language.LanguageCategory;
import org.eclipse.vtp.framework.media.language.LanguageEntry;
import org.eclipse.vtp.framework.media.language.LanguageGroup;
import org.eclipse.vtp.framework.media.language.MediaLanguage;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LanguageDecoder
extends AbstractDecoder {
    private MediaLanguage result = null;

    public void startDocument() throws SAXException {
        this.result = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/language#1.0".equals(uri) && "descriptor".equals(localName) || "language:descriptor".equals(qName)) {
            this.push(new MediaLanguage(this.decodeLocale(atts.getValue("http://www.w3.org/XML/1998/namespace", "lang"))));
        } else if ("translator".equals(localName) || "translator".equals(qName)) {
            this.startCollectingCharacters();
        } else if ("prompts".equals(localName) || "prompts".equals(qName)) {
            this.push(new LanguageCategory());
        } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
            this.push(new LanguageCategory());
        } else if ("group".equals(localName) || "group".equals(qName)) {
            this.push(new LanguageGroup(atts.getValue("name")));
        } else if ("entry".equals(localName) || "entry".equals(qName)) {
            this.startCollectingCharacters();
            this.push(new LanguageEntry(atts.getValue("name")));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/language#1.0".equals(uri) && "descriptor".equals(localName) || "language:descriptor".equals(qName)) {
            this.result = (MediaLanguage)this.pop();
        } else if ("translator".equals(localName) || "translator".equals(qName)) {
            String content = this.stopCollectingCharacters().trim();
            ((MediaLanguage)this.peek()).setTranslator(content);
        } else if ("prompts".equals(localName) || "prompts".equals(qName)) {
            LanguageCategory category = (LanguageCategory)this.pop();
            ((MediaLanguage)this.peek()).setPromptsCategory(category);
        } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
            LanguageCategory category = (LanguageCategory)this.pop();
            ((MediaLanguage)this.peek()).setGrammarsCategory(category);
        } else if ("group".equals(localName) || "group".equals(qName)) {
            LanguageGroup group = (LanguageGroup)this.pop();
            ((LanguageCategory)this.peek()).addGroup(group);
        } else if ("entry".equals(localName) || "entry".equals(qName)) {
            LanguageEntry entry = (LanguageEntry)this.pop();
            String content = this.stopCollectingCharacters().trim();
            entry.setContent(content);
            ((LanguageGroup)this.peek()).addEntry(entry);
        }
    }

    public MediaLanguage getResult() {
        return this.result;
    }
}

