/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Iterator;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryGrammarTranslation;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptTranslation;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.eclipse.vtp.framework.media.xml.GrammarEncoder;
import org.eclipse.vtp.framework.media.xml.PromptEncoder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LibraryEncoder
extends AbstractEncoder {
    private final PromptEncoder promptEncoder = new PromptEncoder("library");
    private final GrammarEncoder grammarEncoder = new GrammarEncoder("library");
    private MediaLibrary source = null;

    public LibraryEncoder() {
    }

    public LibraryEncoder(MediaLibrary source) {
        this.setSource(source);
    }

    public void setSource(MediaLibrary source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        Iterator k;
        Object trans;
        Iterator j;
        Object entry;
        if (this.source == null) {
            return;
        }
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        this.promptEncoder.setContentHandler(handler);
        this.grammarEncoder.setContentHandler(handler);
        AttributesImpl atts = new AttributesImpl();
        handler.startDocument();
        this.encodeStartNamespace("library", "http://eclipse.org/vtp/xsd/openVXML/media/library#1.0", atts);
        handler.startElement("http://eclipse.org/vtp/xsd/openVXML/media/library#1.0", "descriptor", "library:descriptor", atts);
        atts.clear();
        handler.startElement("", "prompts", "prompts", atts);
        Iterator i = this.source.getPrompts().getEntries().iterator();
        while (i.hasNext()) {
            entry = (LibraryPromptEntry)i.next();
            atts.addAttribute("", "name", "name", "CDATA", ((LibraryPromptEntry)entry).getName());
            handler.startElement("", "entry", "entry", atts);
            atts.clear();
            j = ((LibraryPromptEntry)entry).getTranslations().iterator();
            while (j.hasNext()) {
                trans = (LibraryPromptTranslation)j.next();
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(((LibraryPromptTranslation)trans).getLocale()));
                handler.startElement("", "translation", "translation", atts);
                atts.clear();
                k = ((LibraryPromptTranslation)trans).getAll().iterator();
                while (k.hasNext()) {
                    this.promptEncoder.setSource((Prompt)k.next());
                    this.promptEncoder.encode();
                }
                handler.endElement("", "translation", "translation");
            }
            handler.endElement("", "entry", "entry");
        }
        handler.endElement("", "prompts", "prompts");
        handler.startElement("", "grammars", "grammars", atts);
        i = this.source.getGrammars().getEntries().iterator();
        while (i.hasNext()) {
            entry = (LibraryGrammarEntry)i.next();
            atts.addAttribute("", "name", "name", "CDATA", ((LibraryGrammarEntry)entry).getName());
            handler.startElement("", "entry", "entry", atts);
            atts.clear();
            j = ((LibraryGrammarEntry)entry).getTranslations().iterator();
            while (j.hasNext()) {
                trans = (LibraryGrammarTranslation)j.next();
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(((LibraryGrammarTranslation)trans).getLocale()));
                handler.startElement("", "translation", "translation", atts);
                atts.clear();
                k = ((LibraryGrammarTranslation)trans).getAll().iterator();
                while (k.hasNext()) {
                    this.grammarEncoder.setSource((Grammar)k.next());
                    this.grammarEncoder.encode();
                }
                handler.endElement("", "translation", "translation");
            }
            handler.endElement("", "entry", "entry");
        }
        handler.endElement("", "grammars", "grammars");
        handler.endElement("http://eclipse.org/vtp/xsd/openVXML/media/library#1.0", "descriptor", "library:descriptor");
        this.encodeEndNamespace("library");
        handler.endDocument();
    }
}

