/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.eclipse.vtp.framework.media.xml.SAXExceptionWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PromptEncoder
extends AbstractEncoder
implements Prompt.Visitor {
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private final String referenceContainer;
    private Prompt source = null;
    private final AttributesImpl atts = new AttributesImpl();

    public PromptEncoder(String referenceContainer) {
        this.referenceContainer = referenceContainer == null ? "" : referenceContainer;
    }

    public PromptEncoder(String referenceContainer, Prompt source) {
        this(referenceContainer);
        this.source = source;
    }

    public Prompt getSource() {
        return this.source;
    }

    public void setSource(Prompt source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        if (this.source == null) {
            return;
        }
        if (this.getContentHandler() == null) {
            return;
        }
        try {
            this.source.accept(this);
        }
        catch (SAXExceptionWrapper e) {
            throw (SAXException)e.getCause();
        }
    }

    public Object charactersPrompt(CharactersPrompt charactersPrompt) {
        try {
            this.getContentHandler().startElement("", "characters", "characters", EMPTY_ATTS);
            this.getContentHandler().characters(charactersPrompt.getCharacters().toCharArray(), 0, charactersPrompt.getCharacters().length());
            this.getContentHandler().endElement("", "characters", "characters");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object datePrompt(DatePrompt datePrompt) {
        try {
            this.getContentHandler().startElement("", "date", "date", EMPTY_ATTS);
            String dateStr = this.encodeDate(datePrompt.getValue());
            this.getContentHandler().characters(dateStr.toCharArray(), 0, dateStr.length());
            this.getContentHandler().endElement("", "date", "date");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object dateTimePrompt(DateTimePrompt dateTimePrompt) {
        try {
            if (dateTimePrompt.isShowingTimeZone()) {
                this.atts.addAttribute("", "timezone", "timezone", "CDATA", "true");
            }
            this.getContentHandler().startElement("", "date-time", "date-time", this.atts);
            this.atts.clear();
            String dateTimeStr = this.encodeDateTime(dateTimePrompt.getValue());
            this.getContentHandler().characters(dateTimeStr.toCharArray(), 0, dateTimeStr.length());
            this.getContentHandler().endElement("", "date-time", "date-time");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object digitsPrompt(DigitsPrompt digitsPrompt) {
        try {
            this.getContentHandler().startElement("", "digits", "digits", EMPTY_ATTS);
            this.getContentHandler().characters(digitsPrompt.getContent().toCharArray(), 0, digitsPrompt.getContent().length());
            this.getContentHandler().endElement("", "digits", "digits");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object filePrompt(FilePrompt filePrompt) {
        try {
            this.getContentHandler().startElement("", "file", "file", EMPTY_ATTS);
            this.getContentHandler().characters(filePrompt.getPath().toCharArray(), 0, filePrompt.getPath().length());
            this.getContentHandler().endElement("", "file", "file");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object moneyPrompt(MoneyPrompt moneyPrompt) {
        try {
            if (moneyPrompt.getCurrency() != null) {
                this.atts.addAttribute("", "currency", "currency", "CDATA", moneyPrompt.getCurrency().getCurrencyCode());
            }
            this.getContentHandler().startElement("", "money", "money", this.atts);
            this.atts.clear();
            String valueStr = moneyPrompt.getValue().toString();
            this.getContentHandler().characters(valueStr.toCharArray(), 0, valueStr.length());
            this.getContentHandler().endElement("", "money", "money");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object numberPrompt(NumberPrompt numberPrompt) {
        try {
            this.getContentHandler().startElement("", "number", "number", EMPTY_ATTS);
            String valueStr = String.valueOf(numberPrompt.getValue());
            this.getContentHandler().characters(valueStr.toCharArray(), 0, valueStr.length());
            this.getContentHandler().endElement("", "number", "number");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object ordinalPrompt(OrdinalPrompt ordinalPrompt) {
        try {
            this.getContentHandler().startElement("", "ordinal", "ordinal", EMPTY_ATTS);
            String valueStr = String.valueOf(ordinalPrompt.getValue());
            this.getContentHandler().characters(valueStr.toCharArray(), 0, valueStr.length());
            this.getContentHandler().endElement("", "ordinal", "ordinal");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object referencePrompt(ReferencePrompt referencePrompt) {
        try {
            if (referencePrompt.getContainer().length() > 0) {
                this.atts.addAttribute("", this.referenceContainer, this.referenceContainer, "CDATA", referencePrompt.getContainer());
            }
            this.getContentHandler().startElement("", "reference", "reference", this.atts);
            this.atts.clear();
            this.getContentHandler().characters(referencePrompt.getName().toCharArray(), 0, referencePrompt.getName().length());
            this.getContentHandler().endElement("", "reference", "reference");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object textPrompt(TextPrompt textPrompt) {
        try {
            this.getContentHandler().startElement("", "text", "text", EMPTY_ATTS);
            this.getContentHandler().characters(textPrompt.getContent().toCharArray(), 0, textPrompt.getContent().length());
            this.getContentHandler().endElement("", "text", "text");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object timePrompt(TimePrompt timePrompt) {
        try {
            if (timePrompt.isShowingTimeZone()) {
                this.atts.addAttribute("", "timezone", "timezone", "CDATA", "true");
            }
            this.getContentHandler().startElement("", "time", "time", this.atts);
            this.atts.clear();
            String timeStr = this.encodeTime(timePrompt.getValue());
            this.getContentHandler().characters(timeStr.toCharArray(), 0, timeStr.length());
            this.getContentHandler().endElement("", "time", "time");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }

    public Object variablePrompt(VariablePrompt variablePrompt) {
        try {
            this.atts.addAttribute("", "type", "type", "CDATA", VariablePrompt.getTypeName(variablePrompt.getType()));
            this.getContentHandler().startElement("", "variable", "variable", this.atts);
            this.atts.clear();
            this.getContentHandler().characters(variablePrompt.getVariable().toCharArray(), 0, variablePrompt.getVariable().length());
            this.getContentHandler().endElement("", "variable", "variable");
        }
        catch (SAXException e) {
            throw new SAXExceptionWrapper(e);
        }
        return null;
    }
}

