/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.If;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;
import org.eclipse.vtp.framework.widgets.vxml.Variable;

public class Block
extends FormElement {
    protected Vector actions;
    protected Vector variables;

    public Block(String name) {
        super(name);
        this.init();
    }

    public Block(String name, String expression) {
        super(name, expression);
        this.init();
    }

    public Block(String name, String expression, String condition) {
        super(name, expression, condition);
        this.init();
    }

    private void init() {
        this.actions = new Vector();
        this.variables = new Vector();
    }

    public void addAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Cannot add null action.");
        }
        this.actions.addElement(action);
    }

    public void addIfClause(If ifClause) {
        if (ifClause == null) {
            throw new IllegalArgumentException("Cannot add null if clause.");
        }
        this.actions.addElement(ifClause);
    }

    public void addVariable(Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Cannot add null variable.");
        }
        this.variables.addElement(variable);
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.variables.size()) {
            ((Variable)this.variables.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.actions.size()) {
            ((VXMLWidget)this.actions.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</block>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<block");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

