/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.Output;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;
import org.eclipse.vtp.framework.widgets.vxml.grammar.Grammar;

public class Choice
extends VXMLWidget {
    protected Grammar grammar;
    protected String dtmf;
    protected String targetURI;
    protected Output output;

    public Choice(String targetURI) {
        this.init(null, targetURI, null, null);
    }

    public Choice(String targetURI, String dtmf) {
        this.init(dtmf, targetURI, null, null);
    }

    public Choice(String targetURI, Output output) {
        this.init(null, targetURI, output, null);
    }

    public Choice(String targetURI, String dtmf, Output output) {
        this.init(dtmf, targetURI, output, null);
    }

    public Choice(String targetURI, String dtmf, Grammar grammar) {
        this.init(dtmf, targetURI, null, grammar);
    }

    private void init(String dtmf, String targetURI, Output output, Grammar grammar) {
        if (targetURI == null) {
            throw new IllegalArgumentException("Target URI cannot be null.");
        }
        if (targetURI.equals("")) {
            throw new IllegalArgumentException("Target URI cannot be empty.");
        }
        this.dtmf = dtmf;
        this.targetURI = targetURI;
        this.output = output;
        this.grammar = grammar;
    }

    public String getDTMF() {
        return this.dtmf;
    }

    public String getTargetURI() {
        return this.targetURI;
    }

    public Output getOutput() {
        return this.output;
    }

    public Grammar getGrammarURI() {
        return this.grammar;
    }

    public void setDTMF(String dtmf) {
        this.dtmf = dtmf;
    }

    public void setTargetURI(String targetURI) {
        if (targetURI == null) {
            throw new IllegalArgumentException("Target URI cannot be null.");
        }
        if (targetURI.equals("")) {
            throw new IllegalArgumentException("Target URI cannot be empty.");
        }
        this.targetURI = targetURI;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public void setGrammarURI(Grammar grammar) {
        this.grammar = grammar;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        if (this.dtmf != null) {
            out.print(" dtmf='");
            out.print(XMLUtilities.encodeAttribute((String)this.dtmf));
            out.print("'");
        }
        out.print(" next='");
        out.print(XMLUtilities.encodeAttribute((String)this.targetURI));
        out.print("'");
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        if (this.grammar != null) {
            this.grammar.writeWidget(out, indent + 1);
        }
        if (this.output != null) {
            this.output.writeWidget(out, indent + 1);
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</choice>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<choice");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }
}

