/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.eclipse.vtp.framework.widgets.vxml.VXMLWidget;

public abstract class FormElement
extends VXMLWidget {
    protected String name;
    protected String expression;
    protected String condition;

    public FormElement(String name) {
        this.init(name, null, null);
    }

    public FormElement(String name, String expression) {
        this.init(name, expression, null);
    }

    public FormElement(String name, String expression, String condition) {
        this.init(name, expression, condition);
    }

    private void init(String name, String expression, String condition) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        if (expression != null && expression.equals("")) {
            throw new IllegalArgumentException("Expression cannot be empty.");
        }
        if (condition != null && condition.equals("")) {
            throw new IllegalArgumentException("Condition cannot be empty.");
        }
        this.name = name;
        this.expression = expression;
        this.condition = condition;
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null.");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        this.name = name;
    }

    public void setExpression(String expression) {
        if (expression != null && expression.equals("")) {
            throw new IllegalArgumentException("Expression cannot be empty.");
        }
        this.expression = expression;
    }

    public void setCondition(String condition) {
        if (condition != null && condition.equals("")) {
            throw new IllegalArgumentException("Condition cannot be empty.");
        }
        this.condition = condition;
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        out.print(" name='");
        out.print(XMLUtilities.encodeAttribute((String)this.name));
        out.print("'");
        if (this.expression != null) {
            out.print(" expr='");
            out.print(XMLUtilities.encodeAttribute((String)this.expression));
            out.print("'");
        }
        if (this.condition != null) {
            out.print(" cond='");
            out.print(XMLUtilities.encodeAttribute((String)this.condition));
            out.print("'");
        }
    }
}

