/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.widgets.vxml;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.vtp.framework.util.HashtableUtilities;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Filled;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Prompt;

public class Recording
extends FormElement {
    private boolean dtmfTermOn = true;
    private boolean beep = false;
    private String maxtime = null;
    private String finalSilence = null;
    private String fileType = null;
    private String timeout = null;
    private Prompt prompt;
    protected Vector eventHandlers;
    protected Vector filledHandlers;
    protected Hashtable properties;

    public Recording(String name) {
        super(name);
        this.init();
    }

    public Recording(String name, String expression) {
        super(name, expression);
        this.init();
    }

    public Recording(String name, String expression, String condition) {
        super(name, expression, condition);
        this.init();
    }

    private void init() {
        this.eventHandlers = new Vector();
        this.filledHandlers = new Vector();
        this.properties = new Hashtable();
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
        prompt.setTimeout(this.timeout);
    }

    public void addEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Cannot add null event handler.");
        }
        this.eventHandlers.addElement(eventHandler);
    }

    public void addFilledHandler(Filled filled) {
        if (filled == null) {
            throw new IllegalArgumentException("Cannot add null filled handler.");
        }
        this.filledHandlers.addElement(filled);
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.properties.put(key, value);
    }

    protected void writeEventHandlers(PrintStream out, int indent) throws IOException {
        int i = 0;
        while (i < this.filledHandlers.size()) {
            ((Filled)this.filledHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
        i = 0;
        while (i < this.eventHandlers.size()) {
            ((EventHandler)this.eventHandlers.elementAt(i)).writeWidget(out, indent + 1);
            ++i;
        }
    }

    protected void writeChildren(PrintStream out, int indent) throws IOException {
        String[] keys = HashtableUtilities.getKeys((Hashtable)this.properties);
        int i = 0;
        while (i < keys.length) {
            out.println("<property name='" + keys[i] + "' value='" + this.properties.get(keys[i]) + "'/>");
            ++i;
        }
        super.writeChildren(out, indent);
        this.prompt.writeWidget(out, indent + 1);
    }

    protected void writeAttributes(PrintStream out) throws IOException {
        super.writeAttributes(out);
        out.print(" beep=\"");
        out.print(this.beep);
        out.print("\" ");
        out.print("dtmfterm=\"");
        out.print(this.dtmfTermOn);
        out.print("\" ");
        if (this.maxtime != null) {
            out.print("maxtime=\"");
            out.print(this.maxtime);
            out.print("\" ");
        }
        if (this.finalSilence != null) {
            out.print("finalsilence=\"");
            out.print(this.finalSilence);
            out.print("\" ");
        }
        if (this.fileType != null) {
            out.print("type=\"");
            out.print(this.fileType);
            out.print("\"");
        }
    }

    protected void writeEndTag(PrintStream out, int indent) throws IOException {
        out.println("</record>");
    }

    protected void writeStartTagEntry(PrintStream out, int indent) throws IOException {
        out.print("<record");
    }

    protected void writeStartTagExit(PrintStream out, int indent) throws IOException {
        out.println(">");
    }

    public boolean isBeep() {
        return this.beep;
    }

    public void setBeep(boolean beep) {
        this.beep = beep;
    }

    public boolean isDtmfTermOn() {
        return this.dtmfTermOn;
    }

    public void setDtmfTermOn(boolean dtmfTermOn) {
        this.dtmfTermOn = dtmfTermOn;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFinalSilence() {
        return this.finalSilence;
    }

    public void setFinalSilence(String finalSilence) {
        this.finalSilence = finalSilence;
    }

    public String getMaxtime() {
        return this.maxtime;
    }

    public void setMaxtime(String maxtime) {
        this.maxtime = maxtime;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
        if (this.prompt != null) {
            this.prompt.setTimeout(timeout);
        }
    }
}

