/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPDirectiveValidator
extends JSPValidator
implements ISourceValidator {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private HashMap fReservedPrefixes = new HashMap();
    private HashMap fDuplicatePrefixes = new HashMap();
    private IDocument fDocument;
    private IValidator fMessageOriginator;
    private IFile fFile;
    private boolean fEnableSourceValidation = true;

    public JSPDirectiveValidator() {
        this.fReservedPrefixes.put("jsp", "");
        this.fReservedPrefixes.put("jspx", "");
        this.fReservedPrefixes.put("java", "");
        this.fReservedPrefixes.put("javax", "");
        this.fReservedPrefixes.put("servlet", "");
        this.fReservedPrefixes.put("sun", "");
        this.fReservedPrefixes.put("sunw", "");
        this.fMessageOriginator = this;
    }

    public JSPDirectiveValidator(IValidator validator) {
        this.fReservedPrefixes.put("jsp", "");
        this.fReservedPrefixes.put("jspx", "");
        this.fReservedPrefixes.put("java", "");
        this.fReservedPrefixes.put("javax", "");
        this.fReservedPrefixes.put("servlet", "");
        this.fReservedPrefixes.put("sun", "");
        this.fReservedPrefixes.put("sunw", "");
        this.fMessageOriginator = validator;
    }

    /*
     * Exception decompiling
     */
    protected void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void performValidation(IFile f, IReporter reporter, IStructuredDocument sDoc) {
        this.fDuplicatePrefixes.clear();
        this.fDocument = sDoc;
        IStructuredDocumentRegion region = sDoc.getFirstStructuredDocumentRegion();
        while (region != null && !reporter.isCancelled()) {
            if (region.getType() == "JSP_DIRECTIVE_NAME") {
                this.validateDirective(reporter, f, sDoc, region);
            }
            region = region.getNext();
        }
        this.fDuplicatePrefixes.clear();
        this.fDocument = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(IDocument document) {
        IFile file;
        block6: {
            this.fDuplicatePrefixes.clear();
            this.fDocument = document;
            IStructuredModel model = null;
            file = null;
            try {
                String baseLocation;
                Path basePath;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (model != null && (basePath = new Path(baseLocation = model.getBaseLocation())).segmentCount() > 1 && !(file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)basePath)).exists()) {
                    file = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (model == null) break block6;
            }
            model.releaseFromRead();
        }
        this.fFile = file;
        boolean bl = this.fEnableSourceValidation = this.fFile != null && this.fDocument instanceof IStructuredDocument && JSPBatchValidator.isBatchValidatorPreferenceEnabled(this.fFile) && this.shouldReallyValidate(this.fFile);
        if (DEBUG) {
            Logger.log(1, String.valueOf(this.getClass().getName()) + " enablement for source validation: " + this.fEnableSourceValidation);
        }
    }

    public void disconnect(IDocument document) {
        this.fDuplicatePrefixes.clear();
        this.fDocument = null;
        this.fFile = null;
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.fEnableSourceValidation) {
            if (DEBUG) {
                Logger.log(1, String.valueOf(this.getClass().getName()) + " revalidating " + dirtyRegion);
            }
            this.validate(dirtyRegion, helper, reporter, this.fFile);
        }
    }

    private void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter, IFile file) {
        IStructuredDocument sDoc = (IStructuredDocument)this.fDocument;
        IStructuredDocumentRegion[] regions = sDoc.getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        int i = 0;
        while (i < regions.length) {
            if (regions[i].getType() == "JSP_DIRECTIVE_NAME") {
                this.validateDirective(reporter, file, sDoc, regions[i]);
            }
            ++i;
        }
    }

    private void validateDirective(IReporter reporter, IFile file, IStructuredDocument sDoc, IStructuredDocumentRegion sdRegion) {
        if (this.getDirectiveName(sdRegion).equals("taglib")) {
            int sev;
            ITextRegion valueRegion = this.getAttributeValueRegion(sdRegion, "prefix");
            if (valueRegion == null) {
                return;
            }
            String taglibPrefix = sdRegion.getText(valueRegion);
            int start = sdRegion.getStartOffset(valueRegion);
            int length = valueRegion.getTextLength();
            taglibPrefix = StringUtils.stripQuotes((String)taglibPrefix);
            JSPValidator.LocalizedMessage message = null;
            if (this.isReservedPrefix(taglibPrefix)) {
                sev = 1;
                String msgText = String.valueOf(JSPCoreMessages.JSPDirectiveValidator_0) + taglibPrefix + "'";
                message = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText, (IResource)file);
            } else if (this.isDuplicatePrefix(sdRegion, taglibPrefix)) {
                sev = 2;
                String msgText = String.valueOf(JSPCoreMessages.JSPDirectiveValidator_2) + taglibPrefix + "'";
                JSPValidator.LocalizedMessage localizedMessage = message = file == null ? new JSPValidator.LocalizedMessage(this, sev, msgText) : new JSPValidator.LocalizedMessage((JSPValidator)this, sev, msgText, (IResource)file);
            }
            if (message != null) {
                int lineNo = sDoc.getLineOfOffset(start);
                message.setLineNo(lineNo);
                message.setOffset(start);
                message.setLength(length);
                reporter.addMessage(this.fMessageOriginator, (IMessage)message);
            }
        }
    }

    private boolean isDuplicatePrefix(IStructuredDocumentRegion region, String taglibPrefix) {
        boolean dupe = false;
        Object o = this.fDuplicatePrefixes.get(taglibPrefix);
        if (o == null) {
            this.fDuplicatePrefixes.put(taglibPrefix, region);
        } else if (o instanceof IStructuredDocumentRegion) {
            if (((IStructuredDocumentRegion)o).isDeleted()) {
                this.fDuplicatePrefixes.put(taglibPrefix, region);
            } else if (region != o) {
                dupe = true;
            }
        }
        return dupe;
    }

    public void cleanup(IReporter reporter) {
        super.cleanup(reporter);
        this.fDuplicatePrefixes.clear();
    }

    private boolean isReservedPrefix(String name) {
        return this.fReservedPrefixes.get(name) != null;
    }
}

