/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.internal.databinding.internal.IdentityWrapper;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;

public class ObservableTracker {
    private static ThreadLocal currentChangeListener = new ThreadLocal();
    private static ThreadLocal currentStaleListener = new ThreadLocal();
    private static ThreadLocal currentObservableSet = new ThreadLocal();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IObservable[] runAndMonitor(Runnable runnable, IChangeListener changeListener, IStaleListener staleListener) {
        Set lastObservableSet = (Set)currentObservableSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        HashSet observableSet = new HashSet();
        currentObservableSet.set(observableSet);
        currentChangeListener.set(changeListener);
        currentStaleListener.set(staleListener);
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            currentObservableSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
            throw throwable;
        }
        {
            Object var7_10 = null;
            currentObservableSet.set(lastObservableSet);
            currentChangeListener.set(lastChangeListener);
            currentStaleListener.set(lastStaleListener);
            int i = 0;
        }
        IObservable[] result = new IObservable[observableSet.size()];
        Iterator it = observableSet.iterator();
        while (it.hasNext()) {
            IdentityWrapper wrapper = (IdentityWrapper)it.next();
            result[i++] = (IObservable)wrapper.unwrap();
        }
        return result;
    }

    public static void getterCalled(IObservable observable) {
        Set lastObservableSet = (Set)currentObservableSet.get();
        IChangeListener lastChangeListener = (IChangeListener)currentChangeListener.get();
        IStaleListener lastStaleListener = (IStaleListener)currentStaleListener.get();
        boolean added = false;
        if (lastObservableSet != null) {
            added = lastObservableSet.add(new IdentityWrapper(observable));
        }
        if (added && lastChangeListener != null) {
            observable.addChangeListener(lastChangeListener);
        }
        if (added && lastStaleListener != null) {
            observable.addStaleListener(lastStaleListener);
        }
    }
}

