/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class PlatformURLResourceConnection
extends PlatformURLConnection {
    public static final String RESOURCE = "resource";
    public static final String RESOURCE_URL_STRING = "platform:/resource/";
    private static URL rootURL;
    static /* synthetic */ Class class$0;

    public PlatformURLResourceConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return false;
    }

    protected URL resolve() throws IOException {
        String filePath = this.url.getFile().trim();
        IPath spec = new Path(filePath = URLDecoder.decode(filePath, "UTF-8")).makeRelative();
        if (!spec.segment(0).equals(RESOURCE)) {
            throw new IOException(NLS.bind((String)Messages.url_badVariant, (Object)this.url));
        }
        int count = spec.segmentCount();
        if (count == 1) {
            return rootURL;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(spec.segment(1));
        if (!project.exists()) {
            String message = NLS.bind((String)Messages.url_couldNotResolve, (Object)project.getName(), (Object)this.url.toExternalForm());
            throw new IOException(message);
        }
        IPath result = null;
        if (count == 2) {
            result = project.getLocation();
        } else {
            spec = spec.removeFirstSegments(2);
            result = project.getFile(spec).getLocation();
        }
        return new URL("file", "", result.toString());
    }

    public static void startup(IPath root) {
        if (rootURL != null) {
            return;
        }
        try {
            rootURL = root.toFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.resources.PlatformURLResourceConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register((String)RESOURCE, (Class)clazz);
    }
}

