/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.editorlaunch;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.editorlaunch.IExternalSQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorage;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorageEditorInput;

public class LaunchEditor {
    public static int incNumber = 0;
    private static final String EXTERNAL_SQL_EDITOR_EXT_POINT = "org.eclipse.wst.rdb.server.extensions.externalSQLEditor";
    private static final String EXTERNAL_SQL_EDITOR_ID = "id";
    private static final String EXTERNAL_SQL_EDITOR_CLASS = "class";

    public void launchSQLEditor(String ddl, ConnectionInfo conInfo, String title) {
        if (title == null | title.length() == 0) {
            title = ServerExtensionsPlugin.getString("DEFAULT_TITLE");
        }
        title = String.valueOf(title) + "_" + Integer.toString(++incNumber);
        IExtension extension = this.getExternalSQLEditor();
        if (extension != null) {
            this.launchExternalEditor(extension, ddl, title);
        } else {
            SQLEditorStorage stor = new SQLEditorStorage(title, ddl);
            SQLEditorStorageEditorInput input = new SQLEditorStorageEditorInput((IStorage)stor);
            input.setConnectionInfo(conInfo);
            try {
                ServerExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.eclipse.wst.rdb.server.extensions.editorlaunch.SQLEditorForServerExplorer");
            }
            catch (Exception ex) {
                ServerExtensionsPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            }
        }
    }

    private void launchExternalEditor(IExtension extension, String ddl, String inputTitle) {
        if (extension == null) {
            return;
        }
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            try {
                IConfigurationElement currentConfigElement = configElements[i];
                String editorID = currentConfigElement.getAttribute(EXTERNAL_SQL_EDITOR_ID);
                IExternalSQLEditor extEditor = (IExternalSQLEditor)currentConfigElement.createExecutableExtension(EXTERNAL_SQL_EDITOR_CLASS);
                IEditorInput input = extEditor.getEditorInput(ddl, inputTitle);
                ServerExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, editorID);
            }
            catch (CoreException ex) {
                ServerExtensionsPlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            }
            ++i;
        }
    }

    private IExtension getExternalSQLEditor() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_SQL_EDITOR_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            return extensions[0];
        }
        return null;
    }
}

