/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.vtp.framework.kernel.api.AppTransfer;
import org.eclipse.vtp.framework.kernel.api.Application;
import org.eclipse.vtp.framework.kernel.api.ApplicationTransferDestination;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Disconnect;
import org.eclipse.vtp.framework.kernel.api.DisconnectDestination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.eclipse.vtp.framework.kernel.api.Transfer;
import org.eclipse.vtp.framework.kernel.api.TransferDestination;
import org.eclipse.vtp.framework.kernel.core.DefaultModule;
import org.eclipse.vtp.framework.kernel.core.KernelRegistry;
import org.eclipse.vtp.framework.kernel.core.PersonaManager;
import org.eclipse.vtp.framework.kernel.core.Resource;
import org.eclipse.vtp.framework.kernel.core.ResourceGroup;
import org.eclipse.vtp.framework.kernel.modules.ApplicationStartModule;
import org.eclipse.vtp.framework.kernel.modules.AttachedDataModule;
import org.eclipse.vtp.framework.kernel.modules.DatabaseQueryModule;
import org.eclipse.vtp.framework.kernel.modules.DatabaseQuerySettingsStructure;
import org.eclipse.vtp.framework.kernel.modules.DecisionModule;
import org.eclipse.vtp.framework.kernel.modules.FieldModule;
import org.eclipse.vtp.framework.kernel.modules.ForEachModule;
import org.eclipse.vtp.framework.kernel.modules.MenuModule;
import org.eclipse.vtp.framework.kernel.modules.PlayPromptModule;
import org.eclipse.vtp.framework.kernel.modules.SubdialogModule;
import org.eclipse.vtp.framework.kernel.modules.VariableAssignmentModule;
import org.eclipse.vtp.framework.kernel.modules.WebServiceCallModule;
import org.eclipse.vtp.framework.kernel.modules.WebServiceCallSettings;
import org.eclipse.vtp.framework.kernel.modules.WormholeModule;
import org.eclipse.vtp.framework.kernel.spi.GrammarSolver;
import org.eclipse.vtp.framework.kernel.spi.KernelDataPoint;
import org.eclipse.vtp.framework.kernel.spi.PromptSolver;
import org.eclipse.vtp.framework.kernel.spi.RecordingModule;
import org.eclipse.vtp.framework.media.util.BrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.CustomBindingIndex;
import org.eclipse.vtp.framework.media.util.CustomBrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.util.DefaultBrandLibraryIndex;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.xml.MediaXML;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.util.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultApplication
implements Application {
    private KernelRegistry registry;
    private String applicationId;
    private String versionId;
    private String applicationServerId;
    private Map modules;
    private Destination entryPoint;
    private List availableLanguages;
    private ResourceGroup applicationBundle;
    private PromptSolver promptSolver;
    private GrammarSolver grammarSolver;
    private ClassLoader applicationClassLoader;
    private String brand;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultApplication(KernelRegistry registry, String brand, String contextPath, ResourceGroup applicationGroup, ResourceGroup personasGroup) throws Exception {
        block104: {
            super();
            this.registry = null;
            this.applicationId = "";
            this.versionId = "";
            this.applicationServerId = null;
            this.registry = registry;
            this.modules = new HashMap<K, V>();
            this.availableLanguages = new ArrayList<E>();
            this.availableLanguages.add(Locale.ENGLISH);
            this.brand = brand;
            this.applicationBundle = applicationGroup;
            this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
            applicationDefinition = null;
            buildDefinition = null;
            callDesignDocumentStream = null;
            buildPathDocumentStream = null;
            try {
                try {
                    builderFactory = DocumentBuilderFactory.newInstance();
                    builder = builderFactory.newDocumentBuilder();
                    callDesignDocumentStream = ((Resource)applicationGroup.getResourceItem("CallDesign.xml")).getInputStream();
                    applicationDefinition = builder.parse(callDesignDocumentStream);
                    buildPathDocumentStream = ((Resource)applicationGroup.getResourceItem(".buildPath")).getInputStream();
                    buildDefinition = builder.parse(buildPathDocumentStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable var13_13) {
                var12_15 = null;
                try {
                    callDesignDocumentStream.close();
                }
                catch (Exception v0) {}
                try {
                    buildPathDocumentStream.close();
                    throw var13_13;
                }
                catch (Exception v1) {}
                throw var13_13;
            }
            {
                var12_16 = null;
            }
            try {}
            catch (Exception v2) {}
            callDesignDocumentStream.close();
            try {}
            catch (Exception v3) {}
            buildPathDocumentStream.close();
            startModuleId = "";
            buildRoot = buildDefinition.getDocumentElement();
            this.applicationId = buildRoot.getAttribute("name");
            this.versionId = buildRoot.getAttribute("version");
            this.applicationServerId = buildRoot.getAttribute("full-server-id");
            documentRoot = applicationDefinition.getDocumentElement();
            elements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)documentRoot, (String)"elements"));
            i = 0;
            while (true) {
                block100: {
                    if (i >= elements.length) break;
                    instanceId = elements[i].getAttribute("instance-id");
                    tagName = elements[i].getTagName();
                    if (tagName.equals("module")) {
                        moduleName = elements[i].getAttribute("module");
                        moduleGroupVersion = elements[i].getAttribute("version-number");
                        moduleGroupName = elements[i].getAttribute("module-group");
                        vendorName = elements[i].getAttribute("vendor");
                        module = new DefaultModule(this.applicationClassLoader, applicationGroup, vendorName, moduleGroupName, moduleGroupVersion, moduleName, instanceId);
                        settings = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)elements[i], (String)"settings"));
                        s = 0;
                        while (true) {
                            if (s >= settings.length) break;
                            settingName = settings[s].getAttribute("name");
                            settingValue = settings[s].getAttribute("value");
                            module.addSetting(settingName, settingValue);
                            ++s;
                        }
                        configurations = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)elements[i], (String)"configuration"));
                        s = 0;
                        while (true) {
                            if (s >= configurations.length) {
                                this.modules.put(instanceId, module);
                                break block100;
                            }
                            settingName = configurations[s].getAttribute("name");
                            settingValue = configurations[s].getAttribute("value");
                            module.setConfiguration(settingName, settingValue);
                            ++s;
                        }
                    }
                    if (tagName.equals("disconnect")) {
                        this.modules.put(instanceId, new Disconnect());
                    } else if (tagName.equals("transfer")) {
                        target = elements[i].getAttribute("target");
                        targetType = elements[i].getAttribute("target-type");
                        if (targetType.equals("")) {
                            target = elements[i].getAttribute("dn");
                            targetType = "0";
                        }
                        this.modules.put(instanceId, new Transfer(Integer.parseInt(targetType), target));
                    } else if (tagName.equals("app-transfer")) {
                        dn = elements[i].getAttribute("dn");
                        this.modules.put(instanceId, new AppTransfer(dn));
                    } else if (tagName.equals("app-start")) {
                        startModuleId = instanceId;
                        sam = new ApplicationStartModule(instanceId);
                        sam.readSettings(elements[i]);
                        this.modules.put(instanceId, sam);
                    } else if (tagName.equals("subdialog")) {
                        sm = new SubdialogModule(instanceId);
                        sm.readSettings(elements[i]);
                        this.modules.put(instanceId, sm);
                    } else if (tagName.equals("assign")) {
                        sam = new VariableAssignmentModule(instanceId);
                        sam.readSettings(elements[i]);
                        this.modules.put(instanceId, sam);
                    } else if (tagName.equals("worm-hole-entry")) {
                        exitId = elements[i].getAttribute("exit-id");
                        wm = (WormholeModule)this.modules.get(exitId);
                        if (wm == null) {
                            wm = new WormholeModule(instanceId);
                            this.modules.put(exitId, wm);
                        }
                        this.modules.put(instanceId, wm);
                    } else if (tagName.equals("prompt")) {
                        ppm = new PlayPromptModule(instanceId);
                        this.modules.put(instanceId, ppm);
                    } else if (tagName.equals("database-query")) {
                        dqm = new DatabaseQueryModule(instanceId);
                        settings = new DatabaseQuerySettingsStructure();
                        nl = elements[i].getElementsByTagName("settings");
                        if (nl.getLength() > 0) {
                            settings.read((Element)nl.item(0));
                        }
                        dqm.setDatabaseQuerySettings((DatabaseQuerySettingsStructure)settings);
                        this.modules.put(instanceId, dqm);
                    } else if (tagName.equals("web-service-call")) {
                        wscm = new WebServiceCallModule(instanceId);
                        settings = new WebServiceCallSettings();
                        nl = elements[i].getElementsByTagName("settings");
                        if (nl.getLength() > 0) {
                            settings.read((Element)nl.item(0));
                        }
                        wscm.setWebServiceCallSettings((WebServiceCallSettings)settings);
                        this.modules.put(instanceId, wscm);
                    } else if (tagName.equals("for-each")) {
                        fem = new ForEachModule(instanceId);
                        fem.readSettings(elements[i]);
                        this.modules.put(instanceId, fem);
                    } else if (tagName.equals("recording")) {
                        fem = new RecordingModule(instanceId);
                        fem.readSettings(elements[i]);
                        this.modules.put(instanceId, fem);
                    } else if (tagName.equals("field")) {
                        fm = new FieldModule(instanceId);
                        fm.readSettings(elements[i]);
                        this.modules.put(instanceId, fm);
                    } else if (tagName.equals("comparison")) {
                        dm = new DecisionModule(instanceId);
                        dm.readSettings(elements[i]);
                        this.modules.put(instanceId, dm);
                    } else if (tagName.equals("menu")) {
                        mm = new MenuModule(instanceId);
                        mm.readSettings(elements[i]);
                        this.modules.put(instanceId, mm);
                    }
                }
                ++i;
            }
            destinationElements = XMLUtilities.getElementsOfNodeList((NodeList)XMLUtilities.getNamedNodeList((Element)documentRoot, (String)"destinations"));
            i = 0;
            while (true) {
                block101: {
                    if (i >= destinationElements.length) break;
                    destinationElement = destinationElements[i];
                    originElement = null;
                    targetElement = null;
                    nodeList2 = destinationElement.getElementsByTagName("origin");
                    if (nodeList2.getLength() > 0) {
                        originElement = (Element)nodeList2.item(0);
                    }
                    if ((nodeList2 = destinationElement.getElementsByTagName("target")).getLength() > 0) {
                        targetElement = (Element)nodeList2.item(0);
                    }
                    originId = originElement.getAttribute("instance-id");
                    targetId = targetElement.getAttribute("instance-id");
                    dataPoints = new HashMap<String, HashMap<String, KernelDataPoint>>();
                    nodeList3 = destinationElements[i].getElementsByTagName("data-point");
                    d = 0;
                    while (true) {
                        if (d >= nodeList3.getLength()) {
                            destination /* !! */  = null;
                            originObject = this.modules.get(originId);
                            targetObject = this.modules.get(targetId);
                            if (!(targetObject instanceof Module)) break;
                            destination /* !! */  = new ModuleDestination((Module)targetObject);
                            break block101;
                        }
                        dataPointElement = (Element)nodeList3.item(d);
                        destPoints = (HashMap<String, KernelDataPoint>)dataPoints.get(dataPointElement.getAttribute("parent"));
                        if (destPoints == null) {
                            destPoints = new HashMap<String, KernelDataPoint>();
                            dataPoints.put(dataPointElement.getAttribute("parent"), destPoints);
                        }
                        destPoints.put(dataPointElement.getAttribute("name"), new KernelDataPoint(dataPointElement.getAttribute("name"), "static".equals(dataPointElement.getAttribute("type")) != false ? 0 : 1, dataPointElement.getAttribute("value")));
                        ++d;
                    }
                    if (targetObject instanceof Transfer) {
                        destination /* !! */  = new TransferDestination((Transfer)targetObject);
                    } else if (targetObject instanceof AppTransfer) {
                        destination /* !! */  = new ApplicationTransferDestination((AppTransfer)targetObject);
                    } else if (targetObject instanceof Disconnect) {
                        destination /* !! */  = new DisconnectDestination((Disconnect)targetObject);
                    }
                }
                if (originObject instanceof Module) {
                    referenceElements = XMLUtilities.getElementsOfNodeList((NodeList)originElement.getElementsByTagName("endpoint-reference"));
                    r = 0;
                    while (true) {
                        if (r >= referenceElements.length) {
                            hookElements = XMLUtilities.getElementsOfNodeList((NodeList)originElement.getElementsByTagName("hookpoint-reference"));
                            r = 0;
                            break;
                        }
                        moduleReferenceElement = referenceElements[r];
                        moduleEndPointName = moduleReferenceElement.getAttribute("end-point-name");
                        originModule = (Module)originObject;
                        destMap = (Map)dataPoints.get(moduleEndPointName);
                        if (destMap != null && destMap.size() > 0) {
                            adm = new AttachedDataModule(Guid.createGUID());
                            adm.addValues(destMap);
                            originModule.registerEndPointDestination(moduleEndPointName, new ModuleDestination(adm));
                            originModule = adm;
                            moduleEndPointName = "Next";
                        }
                        originModule.registerEndPointDestination(moduleEndPointName, destination /* !! */ );
                        ++r;
                    }
                    while (r < hookElements.length) {
                        moduleReferenceElement = hookElements[r];
                        moduleEndPointName = moduleReferenceElement.getAttribute("end-point-name");
                        originModule = (Module)originObject;
                        destMap = (Map)dataPoints.get(moduleEndPointName);
                        if (destMap != null && destMap.size() > 0) {
                            adm = new AttachedDataModule(Guid.createGUID());
                            adm.addValues(destMap);
                            originModule.registerHookDestination(moduleEndPointName, new ModuleDestination(adm));
                            originModule = adm;
                            moduleEndPointName = "Next";
                        }
                        originModule.registerHookDestination(moduleEndPointName, destination /* !! */ );
                        ++r;
                    }
                }
                if ((asm = (ApplicationStartModule)this.modules.get(startModuleId)) != null) {
                    this.entryPoint = new ModuleDestination(asm);
                }
                ++i;
            }
            langElems = XMLUtilities.getElementsOfNodeList((NodeList)buildDefinition.getElementsByTagName("language"));
            personaIndexes = new LinkedList<PersonaIndex>();
            i = 0;
            while (true) {
                if (i >= langElems.length) {
                    defBindingIndex = new DefaultBindingIndex();
                    defBindRes = (Resource)applicationGroup.getResourceItem("/Brands/Default/.binding");
                    defBindStream = null;
                    ** try [egrp 5[TRYBLOCK] [5 : 2350->2379)] { 
lbl287:
                    // 1 sources

                    break;
                }
                personaIndexes.add(PersonaManager.getPersona(new Locale(langElems[i].getAttribute("locale")), langElems[i].getAttribute("persona"), personasGroup, contextPath));
                ++i;
            }
            {
                defBindStream = defBindRes.getInputStream();
                defBindingIndex.setBinding(MediaXML.loadBinding((Source)new StreamSource(defBindStream)));
            }
lbl295:
            // 1 sources

            catch (Throwable targetId) {
                originId = null;
                try {
                    defBindStream.close();
                    throw targetId;
                }
                catch (Throwable v4) {}
                throw targetId;
            }
            {
                originId = null;
            }
            try {}
            catch (Throwable v5) {}
            defBindStream.close();
            defBrandIndex = new DefaultBrandLibraryIndex();
            defBrandIndex.setPersonas(personaIndexes.toArray(new PersonaIndex[personaIndexes.size()]));
            defBrandPromptsRes = (Resource)applicationGroup.getResourceItem("/Brands/Default/Prompts.xml");
            defBrandStream = null;
            try {
                defBrandStream = defBrandPromptsRes.getInputStream();
                defBrandIndex.setLibrary(MediaXML.loadLibrary((Source)new StreamSource(defBrandStream)));
            }
            catch (Throwable destination) {
                nodeList3 = null;
                try {
                    defBrandStream.close();
                    throw destination;
                }
                catch (Throwable v6) {}
                throw destination;
            }
            {
                nodeList3 = null;
            }
            try {}
            catch (Throwable v7) {}
            defBrandStream.close();
            defBrandFilesRes = (Resource)applicationGroup.getResourceItem("/Brands/Default/Media Files/.audioFiles");
            defFilesStream = null;
            try {
                defFilesStream = defBrandFilesRes.getInputStream();
                defBrandIndex.setFiles(MediaXML.loadFiles((Source)new StreamSource(defFilesStream)));
            }
            catch (Throwable targetObject) {
                originObject = null;
                try {
                    defFilesStream.close();
                    throw targetObject;
                }
                catch (Throwable v8) {}
                throw targetObject;
            }
            {
                originObject = null;
            }
            try {}
            catch (Throwable v9) {}
            defFilesStream.close();
            defBrandIndex.setFilePrefix(String.valueOf(contextPath) + "/openVXML-files/application/Brands/Default/Media%20Files");
            defBindingIndex.setBrand((BrandLibraryIndex)defBrandIndex);
            indexMap = new HashMap<String, CustomBindingIndex>(1);
            if (brand.equals("") || brand.equals("Default") || (custBrandBindRes = (Resource)applicationGroup.getResourceItem("/Brands/" + brand + "/.binding")) == null) break block104;
            custBrandBindStream = null;
            custBrandPromptStream = null;
            custBrandFileStream = null;
            try {
                custBindingIndex = new CustomBindingIndex();
                custBrandBindStream = custBrandBindRes.getInputStream();
                custBindingIndex.setBinding(MediaXML.loadBinding((Source)new StreamSource(custBrandBindStream)));
                custBindingIndex.setParentIndex(defBindingIndex);
                custBrandIndex = new CustomBrandLibraryIndex();
                custBrandPromptsRes = (Resource)applicationGroup.getResourceItem("/Brands/" + brand + "/Prompts.xml");
                custBrandPromptsRes = (Resource)applicationGroup.getResourceItem("/Brands/" + brand + "/Prompts.xml");
                custBrandPromptStream = custBrandPromptsRes.getInputStream();
                custBrandIndex.setLibrary(MediaXML.loadLibrary((Source)new StreamSource(custBrandPromptStream)));
                custBrandFilesRes = (Resource)applicationGroup.getResourceItem("/Brands/" + brand + "/Media Files/.audioFiles");
                custBrandFilesRes = (Resource)applicationGroup.getResourceItem("/Brands/" + brand + "/Media Files/.audioFiles");
                custBrandFileStream = custBrandFilesRes.getInputStream();
                custBrandIndex.setFiles(MediaXML.loadFiles((Source)new StreamSource(custBrandFileStream)));
                custBrandIndex.setFilePrefix(String.valueOf(contextPath) + "/openVXML-files/application/Brands/" + brand + "/Media%20Files");
                custBrandIndex.setParentIndex(defBrandIndex);
                custBindingIndex.setBrand((BrandLibraryIndex)custBrandIndex);
                indexMap.put(brand, custBindingIndex);
            }
            catch (Throwable var35_54) {
                var34_53 = null;
                try {
                    custBrandBindStream.close();
                }
                catch (Throwable v10) {}
                try {
                    custBrandPromptStream.close();
                }
                catch (Throwable v11) {}
                try {
                    custBrandFileStream.close();
                    throw var35_54;
                }
                catch (Throwable v12) {}
                throw var35_54;
            }
            {
                var34_53 = null;
            }
            try {}
            catch (Throwable v13) {}
            custBrandBindStream.close();
            try {}
            catch (Throwable v14) {}
            custBrandPromptStream.close();
            try {}
            catch (Throwable v15) {}
            custBrandFileStream.close();
        }
        this.promptSolver = new PromptSolver(defBindingIndex, indexMap);
        this.grammarSolver = new GrammarSolver(defBindingIndex, indexMap);
    }

    public Destination getEntryPoint() {
        return this.entryPoint;
    }

    public void conversationEnded(String id) {
    }

    public List getAvailableLanguages() {
        return Collections.unmodifiableList(this.availableLanguages);
    }

    public Locale getDefaultLanguage() {
        return new Locale("en");
    }

    public PromptSolver getPromptSolver() {
        return this.promptSolver;
    }

    public GrammarSolver getGrammarSolver() {
        return this.grammarSolver;
    }

    public ClassLoader getClassLoader() {
        return this.applicationClassLoader;
    }

    public String getName() {
        return this.applicationId;
    }

    public String getVersion() {
        return this.versionId;
    }

    public String getBrand() {
        return this.brand;
    }

    public ResourceGroup getApplicationBundle() {
        return this.applicationBundle;
    }

    public String getConfigurationProperty(String name) {
        return this.registry.getConfigurationProperty(name);
    }

    public String[] getConfigurationPropertyNames() {
        return this.registry.getConfigurationPropertyNames();
    }
}

