/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.infoserv.api.InformationService;
import org.eclipse.vtp.framework.infoserv.api.Reporter;
import org.eclipse.vtp.framework.kernel.api.Application;
import org.eclipse.vtp.framework.kernel.api.ApplicationManager;
import org.eclipse.vtp.framework.kernel.api.CallContext;
import org.eclipse.vtp.framework.kernel.api.CallManager;
import org.eclipse.vtp.framework.kernel.api.CallMediator;
import org.eclipse.vtp.framework.kernel.core.DefaultCallMediator;
import org.eclipse.vtp.framework.kernel.core.KernelRegistry;
import org.eclipse.vtp.framework.util.Guid;
import org.eclipse.vtp.framework.widgets.WidgetDocument;
import org.eclipse.vtp.framework.widgets.vxml.Action;
import org.eclipse.vtp.framework.widgets.vxml.Assignment;
import org.eclipse.vtp.framework.widgets.vxml.Block;
import org.eclipse.vtp.framework.widgets.vxml.Catch;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.Disconnect;
import org.eclipse.vtp.framework.widgets.vxml.EventHandler;
import org.eclipse.vtp.framework.widgets.vxml.Form;
import org.eclipse.vtp.framework.widgets.vxml.FormElement;
import org.eclipse.vtp.framework.widgets.vxml.Goto;
import org.eclipse.vtp.framework.widgets.vxml.Output;
import org.eclipse.vtp.framework.widgets.vxml.Prompt;
import org.eclipse.vtp.framework.widgets.vxml.Submit;
import org.eclipse.vtp.framework.widgets.vxml.TextOutput;
import org.eclipse.vtp.framework.widgets.vxml.VXMLDocument;

public class DefaultCallManager
implements CallManager {
    private Map calls = new HashMap();
    private Map callTimers = new HashMap();
    private ApplicationManager applicationManager;
    private long callCount = 0L;
    private InformationService informationService;
    private Reporter reporter;

    public DefaultCallManager(KernelRegistry registry) {
        this.applicationManager = registry.getApplicationManager();
        this.setInformationService(registry.getInformationService());
    }

    public void setInformationService(InformationService informationService) {
        this.informationService = informationService;
        this.reporter = informationService.createReporter();
    }

    public ApplicationManager getApplicationManager() {
        return this.applicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WidgetDocument initializeCall(Map request) {
        WidgetDocument document = null;
        String conversationId = Guid.createGUID();
        CallContext context = new CallContext();
        context.setValue("KERNEL_CALL_ID", conversationId);
        Set entries = request.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            context.setValue((String)entry.getKey(), entry.getValue());
        }
        if (this.getSingleRequestString(request, "ANI") == null) {
            context.setValue("KERNEL_CALL_ANI", "");
        } else {
            context.setValue("KERNEL_CALL_ANI", this.getSingleRequestString(request, "ANI"));
        }
        if (this.getSingleRequestString(request, "DNIS") == null) {
            context.setValue("KERNEL_CALL_DNIS", "");
        } else {
            context.setValue("KERNEL_CALL_DNIS", this.getSingleRequestString(request, "DNIS"));
        }
        Application application = this.applicationManager.getApplication(this.getSingleRequestString(request, "BRAND"), this.getSingleRequestString(request, "KERNEL_CONTEXT_PATH"));
        context.setValue("KERNEL_INFORMATION_SERVICE", this.informationService);
        context.setValue("KERNEL_CONTEXT_PATH", this.getSingleRequestString(request, "KERNEL_CONTEXT_PATH"));
        DefaultCallMediator mediator = new DefaultCallMediator(context, application);
        this.reporter.report("CallBegin", 2);
        mediator.registerLifeCycleListener(this);
        this.calls.put(conversationId, mediator);
        document = mediator.getNextDocument(1);
        if (document != null) {
            if (document instanceof VXMLDocument) {
                this.completeDocument(conversationId, this.getSingleRequestString(request, "KERNEL_CONTEXT_PATH"), (VXMLDocument)document);
            }
        } else {
            this.callTimers.put(conversationId, new Long(System.currentTimeMillis()));
            document = this.buildWaitDocument(conversationId, this.getSingleRequestString(request, "KERNEL_CONTEXT_PATH"));
        }
        DefaultCallManager defaultCallManager = this;
        synchronized (defaultCallManager) {
            ++this.callCount;
        }
        return document;
    }

    public WidgetDocument continueCall(String conversationId, Map request) {
        WidgetDocument document = null;
        Object obj = this.calls.get(conversationId);
        if (obj == null) {
            document = this.buildErrorDocument();
        } else {
            CallMediator mediator = (CallMediator)obj;
            String kernelEvent = this.getSingleRequestString(request, "KERNEL_EVENT");
            if (kernelEvent.equals("FILLED")) {
                mediator.postResponse(request);
            } else if (kernelEvent.equals("NOINPUT")) {
                mediator.postNoInput();
            } else if (kernelEvent.equals("NOMATCH")) {
                mediator.postNoMatch();
            } else if (kernelEvent.equals("ERROR")) {
                mediator.postException(new RuntimeException(this.getSingleRequestString(request, "ERROR_NAME")));
            }
            document = mediator.getNextDocument(2);
            if (document != null) {
                if (document instanceof VXMLDocument) {
                    this.completeDocument(conversationId, (String)mediator.getCallContext().get("KERNEL_CONTEXT_PATH"), (VXMLDocument)document);
                }
                this.callTimers.remove(conversationId);
            } else {
                obj = this.callTimers.get(conversationId);
                if (obj != null) {
                    long timerValue = (Long)obj;
                    if (System.currentTimeMillis() - timerValue > 90000L) {
                        mediator.postException(new CallManager.TimeoutException());
                    }
                } else {
                    this.callTimers.put(conversationId, new Long(System.currentTimeMillis()));
                }
                document = this.buildWaitDocument(conversationId, (String)mediator.getCallContext().get("KERNEL_CONTEXT_PATH"));
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conversationEnded(String conversationId) {
        this.calls.remove(conversationId);
        this.callTimers.remove(conversationId);
        Runtime.getRuntime().gc();
        DefaultCallManager defaultCallManager = this;
        synchronized (defaultCallManager) {
            --this.callCount;
        }
    }

    private void completeDocument(String conversationId, String contextPath, VXMLDocument document) {
        this.addCacheControlProperties(document);
        Catch hangupCatch = new Catch("connection.disconnect.hangup");
        Goto hangupGoto = new Goto(String.valueOf(contextPath) + "/openVXML?KERNEL_CALL_ID=" + conversationId + "&KERNEL_EVENT=ERROR&ERROR_NAME=connection.disconnect.hangup");
        hangupCatch.addAction((Action)hangupGoto);
        document.addEventHandler((EventHandler)hangupCatch);
        Catch generalErrorCatch = new Catch("error");
        Assignment assignment = new Assignment("ERROR_NAME", "_event + \"\"");
        Submit generalErrorSubmit = new Submit(String.valueOf(contextPath) + "/openVXML?KERNEL_CALL_ID=" + conversationId + "&KERNEL_EVENT=ERROR", new String[]{"ERROR_NAME"});
        generalErrorCatch.addAction((Action)assignment);
        generalErrorCatch.addAction((Action)generalErrorSubmit);
    }

    private WidgetDocument buildWaitDocument(String conversationId, String contextPath) {
        VXMLDocument ret = null;
        VXMLDocument document = new VXMLDocument();
        this.addCacheControlProperties(document);
        Catch hangupCatch = new Catch("connection.disconnect.hangup");
        Goto hangupGoto = new Goto(String.valueOf(contextPath) + "/openVXML?KERNEL_CALL_ID=" + conversationId + "&KERNEL_EVENT=ERROR&ERROR_NAME=connection.disconnect.hangup");
        hangupCatch.addAction((Action)hangupGoto);
        document.addEventHandler((EventHandler)hangupCatch);
        Catch generalErrorCatch = new Catch("error");
        Assignment assignment = new Assignment("ERROR_NAME", "_event");
        Submit generalErrorSubmit = new Submit(String.valueOf(contextPath) + "/openVXML?KERNEL_CALL_ID=" + conversationId + "&KERNEL_EVENT=ERROR&ERROR_NAME=connection.disconnect.hangup", new String[]{"ERROR_NAME"});
        generalErrorCatch.addAction((Action)assignment);
        generalErrorCatch.addAction((Action)generalErrorSubmit);
        Form waitForm = new Form("WaitForm");
        Block waitBlock = new Block("WaitBlock");
        waitBlock.addAction((Action)new Goto(String.valueOf(contextPath) + "/openVXML?KERNEL_CALL_ID=" + conversationId + "&KERNEL_EVENT=NOOP"));
        waitForm.addFormElement((FormElement)waitBlock);
        document.addDialog((Dialog)waitForm);
        ret = document;
        return ret;
    }

    private WidgetDocument buildErrorDocument() {
        VXMLDocument ret = null;
        VXMLDocument document = new VXMLDocument();
        this.addCacheControlProperties(document);
        Form waitForm = new Form("ErrorForm");
        Block waitBlock = new Block("ErrorBlock");
        waitBlock.addAction((Action)new Prompt((Output)new TextOutput("I'm sorry, we are having technical difficulties with our voice response system.  Please call again when this issue is resolved.")));
        waitBlock.addAction((Action)new Disconnect());
        waitForm.addFormElement((FormElement)waitBlock);
        document.addDialog((Dialog)waitForm);
        ret = document;
        return ret;
    }

    private void addCacheControlProperties(VXMLDocument document) {
        document.setProperty("maxage", "45");
        document.setProperty("maxstale", "45");
        document.setProperty("documentmaxage", "0");
        document.setProperty("documentmaxstale", "0");
        document.setProperty("fetchaudiodelay", "30s");
    }

    private String getSingleRequestString(Map request, String name) {
        Object obj = request.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            String[] values = (String[])obj;
            if (values.length < 1) {
                return null;
            }
            return values[0];
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }
}

