/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.modules;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.vtp.framework.api.BArray;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionFailure;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.eclipse.vtp.framework.kernel.modules.DatabaseQuerySettingsStructure;

public class DatabaseQueryModule
implements Module {
    private String id;
    DatabaseQuerySettingsStructure databaseQuerySettings;
    Map hooks = new HashMap();
    Map endPoints = new HashMap();
    private Properties configuration = new Properties();

    public DatabaseQueryModule(String id) {
        this.id = id;
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public Interaction getInstance() {
        return new DatabaseQueryInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "DatabaseQuery";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return null;
    }

    public void setDatabaseQuerySettings(DatabaseQuerySettingsStructure databaseQuerySettings) {
        this.databaseQuerySettings = databaseQuerySettings;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String name, String value) {
        this.configuration.setProperty(name, value);
    }

    public class DatabaseQueryInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            ExecutionResult next;
            block47: {
                next = ExecutionResult.success((String)"Next");
                ExecutionResult noMatches = ExecutionResult.success((String)"No Matches");
                ExecutionFailure error = ExecutionResult.failure((String)"error.database.unavailable");
                BObject var = null;
                String[] parts = DatabaseQueryModule.this.databaseQuerySettings.targetVariableName.split("\\.");
                if (DatabaseQueryModule.this.databaseQuerySettings.targetVariableExists) {
                    var = conversation.getVariable(parts[0]);
                    if (var == null) {
                        var = conversation.createObject(parts[0], DatabaseQueryModule.this.databaseQuerySettings.targetVariableType, DatabaseQueryModule.this.databaseQuerySettings.targetMultiplicity == 1);
                    }
                } else {
                    var = conversation.createObject(parts[0], DatabaseQueryModule.this.databaseQuerySettings.targetVariableType, DatabaseQueryModule.this.databaseQuerySettings.targetMultiplicity == 1);
                }
                int i = 1;
                while (i < parts.length) {
                    if ((var = var.getField(parts[i])) == null) {
                        return error.withRootCause((Throwable)new Exception("Invalid variable name"));
                    }
                    ++i;
                }
                conversation.registerVariable(var);
                StringBuffer buf = new StringBuffer("select");
                List columns = DatabaseQueryModule.this.databaseQuerySettings.dataMapping;
                int dataColumns = 0;
                int i2 = 0;
                while (i2 < columns.size()) {
                    DatabaseQuerySettingsStructure.DataMapping dataMap = (DatabaseQuerySettingsStructure.DataMapping)columns.get(i2);
                    if (dataMap.mappingType == 1) {
                        if (++dataColumns != 1) {
                            buf.append(',');
                        }
                        buf.append(' ');
                        buf.append(dataMap.mappingValue);
                    }
                    ++i2;
                }
                if (dataColumns > 0) {
                    buf.append(" from ");
                    buf.append(DatabaseQueryModule.this.databaseQuerySettings.sourceDatabaseTable);
                    List criteria = DatabaseQueryModule.this.databaseQuerySettings.criteria;
                    int usedColumns = 0;
                    int i3 = 0;
                    while (i3 < criteria.size()) {
                        DatabaseQuerySettingsStructure.SelectionCriteria selcriteria = (DatabaseQuerySettingsStructure.SelectionCriteria)criteria.get(i3);
                        if (selcriteria.comparison != -1 && selcriteria.type != -1) {
                            if (selcriteria.type == 1) {
                                if (usedColumns == 0) {
                                    buf.append(" where");
                                } else {
                                    buf.append(" and");
                                }
                                BObject valueVar = null;
                                String[] valueParts = selcriteria.value.split("\\.");
                                valueVar = conversation.getVariable(valueParts[0]);
                                if (valueVar == null) {
                                    return error.withRootCause((Throwable)new Exception("Invalid variable name"));
                                }
                                int v = 1;
                                while (v < valueParts.length) {
                                    if ((valueVar = valueVar.getField(valueParts[v])) == null) {
                                        return error.withRootCause((Throwable)new Exception("Invalid variable name"));
                                    }
                                    ++v;
                                }
                                buf.append(' ');
                                buf.append(selcriteria.columnName);
                                buf.append(' ');
                                buf.append(this.comparisonString(selcriteria.comparison));
                                buf.append(' ');
                                if (valueVar.getType().getTypeName().equals("String")) {
                                    buf.append('\'');
                                }
                                buf.append(valueVar.getValue().toString());
                                if (valueVar.getType().getTypeName().equals("String")) {
                                    buf.append('\'');
                                }
                            } else if (selcriteria.type == 0) {
                                if (usedColumns == 0) {
                                    buf.append(" where");
                                } else {
                                    buf.append(" and");
                                }
                                buf.append(' ');
                                buf.append(selcriteria.columnName);
                                buf.append(' ');
                                buf.append(this.comparisonString(selcriteria.comparison));
                                buf.append(' ');
                                buf.append(selcriteria.value);
                            }
                            ++usedColumns;
                        }
                        ++i3;
                    }
                }
                try {
                    Connection con = this.getConnection(conversation);
                    Statement st = con.createStatement();
                    ResultSet rs = st.executeQuery(buf.toString());
                    if (var instanceof BArray) {
                        int s = ((BArray)var).getItems().size();
                        int i4 = 0;
                        while (i4 < s) {
                            ((BArray)var).removeItem(0);
                            ++i4;
                        }
                        i4 = 0;
                        while (i4 < (DatabaseQueryModule.this.databaseQuerySettings.resultLimit <= 0 ? Integer.MAX_VALUE : DatabaseQueryModule.this.databaseQuerySettings.resultLimit)) {
                            if (!rs.next()) {
                                if (i4 == 0) {
                                    return noMatches;
                                }
                                break block47;
                            }
                            BObject obj = conversation.createObject("Result" + i4, DatabaseQueryModule.this.databaseQuerySettings.targetVariableType, false);
                            int c = 0;
                            while (c < columns.size()) {
                                DatabaseQuerySettingsStructure.DataMapping dataMap = (DatabaseQuerySettingsStructure.DataMapping)columns.get(c);
                                if (dataMap.mappingType == 1) {
                                    if (obj.getType().hasValue()) {
                                        obj.setValue((Object)rs.getString(dataMap.mappingValue));
                                    } else {
                                        obj.getField(dataMap.fieldName).setValue((Object)rs.getString(dataMap.mappingValue));
                                    }
                                } else if (dataMap.mappingType == 0) {
                                    if (obj.getType().hasValue()) {
                                        obj.setValue((Object)dataMap.mappingValue);
                                    } else {
                                        obj.getField(dataMap.fieldName).setValue((Object)dataMap.mappingValue);
                                    }
                                }
                                ++c;
                            }
                            ((BArray)var).addItem(obj);
                            ++i4;
                        }
                        break block47;
                    }
                    if (!rs.next()) {
                        return noMatches;
                    }
                    int c = 0;
                    while (c < columns.size()) {
                        DatabaseQuerySettingsStructure.DataMapping dataMap = (DatabaseQuerySettingsStructure.DataMapping)columns.get(c);
                        if (dataMap.mappingType == 1) {
                            if (var.getType().hasValue()) {
                                var.setValue((Object)rs.getString(dataMap.mappingValue));
                            } else {
                                var.getField(dataMap.fieldName).setValue((Object)rs.getString(dataMap.mappingValue));
                            }
                        } else if (dataMap.mappingType == 0) {
                            if (var.getType().hasValue()) {
                                var.setValue((Object)dataMap.mappingValue);
                            } else {
                                var.getField(dataMap.fieldName).setValue((Object)dataMap.mappingValue);
                            }
                        }
                        ++c;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return error.withRootCause((Throwable)e);
                }
            }
            return next;
        }

        private Connection getConnection(Conversation conversation) throws SQLException {
            String lookupType = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".type");
            if ("jndi".equals(lookupType)) {
                String jndiUri = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".uri");
                String jndiUsr = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".usr");
                String jndiPwd = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".pwd");
                DataSource source = null;
                try {
                    source = (DataSource)new InitialContext().lookup("java:comp/env/" + jndiUri);
                }
                catch (NamingException e) {
                    throw new SQLException(e.getMessage());
                }
                if (jndiUsr != null && jndiUsr.length() > 0) {
                    return source.getConnection(jndiUsr, jndiPwd);
                }
                return source.getConnection();
            }
            String jdbcDvr = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".dvr");
            String jdbcUrl = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".url");
            String jdbcUsr = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".usr");
            String jdbcPwd = conversation.getConfigurationProperty("db." + DatabaseQueryModule.this.databaseQuerySettings.sourceDatabase + ".pwd");
            Class driverClass = null;
            Driver driver = null;
            try {
                driverClass = conversation.loadClass(jdbcDvr);
                driver = (Driver)driverClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                return null;
            }
            catch (Exception e) {
                SQLException ex = new SQLException("Cannot load driver: " + e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            Properties props = new Properties();
            props.setProperty("user", jdbcUsr);
            props.setProperty("password", jdbcPwd);
            return driver.connect(jdbcUrl, props);
        }

        private String comparisonString(int comparison) {
            String[] comparisonNames = new String[]{"=", "<", "<=", ">", ">=", "!="};
            return comparisonNames[comparison];
        }
    }
}

